/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybComboBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;

public class MRUComboBox
extends SybComboBox {
    public static final int MRU_LENGTH = 5;

    public MRUComboBox(String string) {
        super((Vector)MRUComboBox.convertStringToVector(string));
        this.setEditable(true);
        this.setSelectedIndex(-1);
        this.setRenderer(new ToolTipCellRenderer(this.getRenderer()));
    }

    public String getMRUList() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(128);
        String string = this.getStringValue();
        if (string != null && string.length() > 0) {
            MRUComboBox.addEscapedValue(stringBuffer, string);
            bl = true;
        } else {
            bl = false;
        }
        ComboBoxModel comboBoxModel = this.getModel();
        int n = Math.min(comboBoxModel.getSize(), 5);
        for (int i = 0; i < n; ++i) {
            String string2 = comboBoxModel.getElementAt(i).toString();
            if (string2.length() <= 0 || string2.equalsIgnoreCase(string)) continue;
            if (bl) {
                stringBuffer.append(";");
            } else {
                bl = true;
            }
            MRUComboBox.addEscapedValue(stringBuffer, string2);
        }
        return stringBuffer.toString();
    }

    public void addStringValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ComboBoxModel comboBoxModel = this.getModel();
        int n = comboBoxModel.getSize();
        Vector<String> vector = new Vector<String>(n);
        vector.add(string);
        for (int i = 0; i < n; ++i) {
            String string2 = comboBoxModel.getElementAt(i).toString();
            if (string2.equalsIgnoreCase(string)) continue;
            vector.add(string2);
        }
        if (vector.size() > 5) {
            vector.setSize(5);
        }
        this.setModel(new DefaultComboBoxModel(vector));
    }

    public String getStringValue() {
        Object object = this.isEditable() ? this.getEditor().getItem().toString() : this.getSelectedItem();
        String string = object != null ? object.toString().trim() : null;
        return string;
    }

    private static void addEscapedValue(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
    }

    private static Vector<String> convertStringToVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null && string.length() != 0) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ';') {
                    if (i < n - 1 && string.charAt(i + 1) == ';') {
                        ++i;
                        stringBuffer.append(c);
                        continue;
                    }
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() != 0) {
                vector.addElement(stringBuffer.toString());
            }
        }
        return vector;
    }

    static class ToolTipCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer _oldRenderer;

        ToolTipCellRenderer(ListCellRenderer listCellRenderer) {
            this._oldRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this._oldRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (bl) {
                String string = object.toString();
                Font font = component.getFont();
                Graphics2D graphics2D = (Graphics2D)jList.getGraphics();
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D = font.getStringBounds(string, 0, string.length(), fontRenderContext);
                JViewport jViewport = (JViewport)jList.getParent();
                int n2 = jViewport.getWidth();
                if (rectangle2D.getWidth() > (double)n2) {
                    jList.setToolTipText(object.toString());
                } else {
                    jList.setToolTipText(null);
                }
            }
            return component;
        }
    }
}

