/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class MyNode
extends DefaultMutableTreeNode
implements Comparable {
    private static boolean _fileSystemIgnoresCase = Platform.isWindows();
    private static FileSystemView _fsv = FileSystemView.getFileSystemView();
    File _file = null;
    MyNode[] _children = null;

    MyNode() {
        File[] fileArray = _fsv.getRoots();
        int n = 0;
        if (n < fileArray.length) {
            this._file = fileArray[n];
            this.setUserObject(this._file);
        }
    }

    MyNode(File file) {
        super(file);
        this._file = file;
    }

    MyNode findNode(File file) {
        MyNode myNode = null;
        if (this._file.equals(file)) {
            return this;
        }
        String string = file.getAbsolutePath();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            MyNode myNode2 = (MyNode)this.getChildAt(i);
            File file2 = myNode2.getFile();
            if (this.isComputerNode(file2)) {
                myNode = myNode2.findNode(file);
                break;
            }
            if (!_fsv.isFileSystem(file2)) continue;
            if (file2.equals(file)) {
                myNode = myNode2;
                break;
            }
            String string2 = file2.getAbsolutePath();
            if (string.length() <= string2.length()) continue;
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!string.regionMatches(_fileSystemIgnoresCase, 0, string2, 0, string2.length())) continue;
            myNode = myNode2.findNode(file);
            break;
        }
        return myNode;
    }

    private boolean isComputerNode(File file) {
        boolean bl = file.getAbsolutePath().indexOf("::") != -1;
        return bl;
    }

    File getFile() {
        return this._file;
    }

    public Enumeration children() {
        if (this._children == null) {
            this.buildChildList();
        }
        return new MyNodeEnumeration(this._children);
    }

    @Override
    public int getChildCount() {
        if (this._children == null) {
            this.buildChildList();
        }
        return this._children.length;
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (this._children == null) {
            this.buildChildList();
        }
        return this._children[n];
    }

    @Override
    public boolean isLeaf() {
        boolean bl = this._children == null ? false : this._children.length == 0;
        return bl;
    }

    private void buildChildList() {
        int n;
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this._file.listFiles();
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!_fsv.isFloppyDrive(fileArray[n]) && !fileArray[n].isDirectory()) continue;
                arrayList.add(fileArray[n]);
            }
        }
        this._children = new MyNode[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this._children[n] = new MyNode((File)arrayList.get(n));
            this._children[n].setParent(this);
        }
        Arrays.sort(this._children);
    }

    public int compareTo(Object object) {
        MyNode myNode = (MyNode)object;
        int n = _fsv.isDrive(this._file) ? (_fsv.isDrive(myNode._file) ? this._file.compareTo(myNode._file) : -1) : (_fsv.isDrive(myNode._file) ? 1 : this._file.compareTo(myNode._file));
        return n;
    }

    static class MyNodeEnumeration
    implements Enumeration {
        private int _current = 0;
        private MyNode[] _nodes = null;

        MyNodeEnumeration(MyNode[] myNodeArray) {
            this._nodes = myNodeArray;
        }

        @Override
        public boolean hasMoreElements() {
            return this._current < this._nodes.length;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this._nodes[this._current++];
            }
            throw new NoSuchElementException();
        }
    }
}

