/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EventQueuePumper;
import com.sybase.util.NativeFileChooserResources;
import com.sybase.util.SybOptionPane;
import com.sybase.util.win32.FileDlg;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class NativeFileChooser
extends JFileChooser
implements Runnable {
    private FileDlg.PB _pb = null;
    private boolean _done;
    private int _dlgType;
    private int _dlgMode;
    private boolean _fileMustExist = true;
    private boolean _overwritePrompt = false;
    private String _directoryBrowserText;

    public NativeFileChooser() {
        super(new MyFileSystemView());
    }

    public NativeFileChooser(String string) {
        super(string, (FileSystemView)new MyFileSystemView());
    }

    public NativeFileChooser(File file) {
        super(file, (FileSystemView)new MyFileSystemView());
    }

    public NativeFileChooser(FileSystemView fileSystemView) {
        super(new MyFileSystemView(fileSystemView));
    }

    @Override
    public int showDialog(Component component, String string) {
        int n;
        if (this.useNative()) {
            if (string != null) {
                this.setApproveButtonText(string);
            }
            n = this.showNativeDialog(component, this.getDialogType());
        } else {
            this.resetFileSystemView();
            n = super.showDialog(component, string);
        }
        return n;
    }

    @Override
    public int showOpenDialog(Component component) {
        int n;
        boolean bl = this._overwritePrompt;
        this._overwritePrompt = false;
        if (!this.useNative()) {
            this.resetFileSystemView();
            n = super.showOpenDialog(component);
        } else {
            n = this.showNativeDialog(component, 0);
        }
        this._overwritePrompt = bl;
        return n;
    }

    @Override
    public int showSaveDialog(Component component) {
        if (!this.useNative()) {
            this.resetFileSystemView();
            boolean bl = this._fileMustExist;
            this._fileMustExist = false;
            int n = super.showSaveDialog(component);
            this._fileMustExist = bl;
            return n;
        }
        return this.showNativeDialog(component, 1);
    }

    private void resetFileSystemView() {
        FileSystemView fileSystemView = this.getFileSystemView();
        if (fileSystemView instanceof MyFileSystemView) {
            this.setFileSystemView(((MyFileSystemView)fileSystemView).getRealFileSystemView());
        }
    }

    private boolean useNative() {
        LookAndFeel lookAndFeel;
        String string = System.getProperty("os.name");
        if (string.indexOf("Windows") != -1 && (lookAndFeel = UIManager.getLookAndFeel()).getID().equalsIgnoreCase("Windows") && FileDlg.isInstalled()) {
            return this.getFileSelectionMode() != 2;
        }
        return false;
    }

    private int showNativeDialog(Component component, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        FileFilter fileFilter = this.getFileFilter();
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        int n3 = 1;
        if (fileFilterArray != null) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (fileFilterArray[i] == fileFilter) {
                    n3 = i;
                }
                this.addFilterToBuffer(stringBuffer, fileFilterArray[i]);
            }
        }
        if (stringBuffer.indexOf("*.*") == -1) {
            stringBuffer.append(UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", this.getLocale()));
            stringBuffer.append('\u0000');
            stringBuffer.append("*.*");
            stringBuffer.append('\u0000');
        }
        stringBuffer.append('\u0000');
        File file = this.getSelectedFile();
        String string = file != null ? file.toString() : null;
        File file2 = this.getCurrentDirectory();
        String string2 = file2 != null ? file2.toString() : null;
        int n4 = 4;
        if (this._fileMustExist) {
            n4 = n4 | 0x1000 | 0x800;
        }
        if (this._overwritePrompt) {
            n4 |= 2;
        }
        Thread thread = new Thread(this);
        if (this._pb == null) {
            this._pb = new FileDlg.PB();
        }
        this._dlgType = n;
        this._dlgMode = this.getFileSelectionMode();
        this._pb.title = this.getDialogTitle();
        this._pb.filter = stringBuffer.toString();
        this._pb.initialFilterIndex = n3;
        this._pb.initialFileName = string;
        this._pb.initialDirectory = string2;
        this._pb.options = n4;
        this._pb.fileNames = null;
        this._pb.directoryBrowserText = this._directoryBrowserText;
        String string3 = this.getApproveButtonText();
        if (string3 != null && string3.length() != 0) {
            this._pb.buttonText = string3;
            this._dlgType = 2;
        }
        this._done = false;
        thread.start();
        try {
            while (true) {
                thread.join(50L);
                if (!this._done) {
                    EventQueuePumper.pump(new EventQueuePumper.Condition(){

                        @Override
                        public boolean keepGoing() {
                            return !NativeFileChooser.this._done;
                        }
                    });
                    if (component == null) continue;
                    component.repaint();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            this._pb.fileNames = null;
        }
        if (this._pb.fileNames != null && this._pb.fileNames.length > 0) {
            fileFilterArray = this.getChoosableFileFilters();
            if (fileFilterArray != null && this._pb.filterIndex >= 1 && this._pb.filterIndex < fileFilterArray.length) {
                this.setFileFilter(fileFilterArray[this._pb.filterIndex]);
            } else {
                this.setFileFilter(null);
            }
            file = new File(this._pb.fileNames[0]);
            this.setSelectedFile(file);
            n2 = 0;
        } else {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public void run() {
        if (this._dlgMode == 1) {
            FileDlg.browseForDirectory(this._pb);
        } else if (this._dlgType == 1) {
            FileDlg.getSaveFileName(this._pb);
        } else {
            FileDlg.getOpenFileName(this._pb);
        }
        this._done = true;
    }

    private void addFilterToBuffer(StringBuffer stringBuffer, FileFilter fileFilter) {
        int n;
        String string = fileFilter.getDescription();
        int n2 = string.lastIndexOf("(*.");
        if (n2 != -1 && (n = string.indexOf(")", n2 + 3)) != -1) {
            String string2 = string.substring(n2 + 1, n);
            stringBuffer.append(string);
            stringBuffer.append('\u0000');
            stringBuffer.append(string2);
            stringBuffer.append('\u0000');
        }
    }

    @Override
    public void approveSelection() {
        String string;
        String string2;
        File file;
        boolean bl = false;
        if (this._fileMustExist && (file = this.getSelectedFile()) != null && !file.exists()) {
            string2 = this.getDialogTitle();
            if (string2 == null) {
                string2 = this.getUI().getDialogTitle(this);
            }
            string = NativeFileChooserResources.getBundle().getFormatted("{0}\nFile not found.\nPlease verify the correct file name was given.", file.getName());
            SybOptionPane.showMessageDialog(this, string, string2, 0);
            bl = true;
        }
        if (this._overwritePrompt && (file = this.getSelectedFile()) != null && file.exists()) {
            string2 = this.getDialogTitle();
            if (string2 == null) {
                string2 = this.getUI().getDialogTitle(this);
            }
            if (SybOptionPane.showConfirmDialog(this, string = NativeFileChooserResources.getBundle().getFormatted("OverwritePrompt", file.getName()), string2, 0) == 1) {
                bl = true;
            }
        }
        if (!bl) {
            super.approveSelection();
        }
    }

    public void setFileMustExist(boolean bl) {
        this._fileMustExist = bl;
    }

    public boolean getFileMustExist() {
        return this._fileMustExist;
    }

    public void setOverwritePrompt(boolean bl) {
        this._overwritePrompt = bl;
    }

    public boolean getOverwritePrompt() {
        return this._overwritePrompt;
    }

    public void setDirectoryBrowserText(String string) {
        this._directoryBrowserText = string;
    }

    public String getDirectoryBrowserText() {
        return this._directoryBrowserText;
    }

    static class MyFileSystemView
    extends FileSystemView {
        FileSystemView _delegate;

        MyFileSystemView() {
            this._delegate = FileSystemView.getFileSystemView();
        }

        MyFileSystemView(FileSystemView fileSystemView) {
            this._delegate = fileSystemView;
        }

        FileSystemView getRealFileSystemView() {
            return this._delegate;
        }

        @Override
        public File[] getFiles(File file, boolean bl) {
            return new File[0];
        }

        @Override
        public File[] getRoots() {
            return new File[0];
        }

        @Override
        public File createNewFolder(File file) throws IOException {
            return this._delegate.createNewFolder(file);
        }
    }
}

