/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends JTextField {
    private boolean _allowUnit = false;

    public NumericTextField() {
        this.setDocument(new NumericDocument());
    }

    public NumericTextField(int n) {
        super(n);
        this.setDocument(new NumericDocument());
    }

    public void setIntValue(int n) {
        this.setText(Integer.toString(n));
    }

    public int getIntValue() {
        int n;
        String string = this.getText();
        try {
            n = this._allowUnit ? NumericTextField.decodeWithUnit(string) : Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public static int decodeWithUnit(String string) throws NumberFormatException {
        long l = 1L;
        char c = string.charAt(string.length() - 1);
        if (c == 'k' || c == 'K') {
            l = 1024L;
        } else if (c == 'm' || c == 'M') {
            l = 0x100000L;
        } else if (c == 'g' || c == 'G') {
            l = 0x40000000L;
        }
        if (l != 1L) {
            string = string.substring(0, string.length() - 1);
        }
        int n = (int)((long)Integer.decode(string).intValue() * l);
        return n;
    }

    public void setAllowUnit(boolean bl) {
        this._allowUnit = bl;
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getText(0, this.getLength()));
                stringBuilder.insert(n, string);
                int n2 = stringBuilder.length();
                for (int i = 0; i < n2; ++i) {
                    char c = stringBuilder.charAt(i);
                    if (Character.isDigit(c) || NumericTextField.this._allowUnit && i >= n2 - 1 && (c == 'k' || c == 'K' || c == 'm' || c == 'M' || c == 'g' || c == 'G')) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

