/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.LineSplitter;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class OptionPaneUI
extends BasicOptionPaneUI {
    private static Method _getMethod = null;

    OptionPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OptionPaneUI();
    }

    @Override
    protected int getMaxCharactersPerLineCount() {
        Locale locale = null;
        locale = Locale.getDefault();
        String string = locale.getLanguage();
        if (string.equals("ja") || string.equals("ko") || string.equals("zh")) {
            return 52;
        }
        return 72;
    }

    @Override
    protected void burstStringInto(Container container, String string, int n) {
        LineSplitter lineSplitter = new LineSplitter(string, n);
        while (lineSplitter.hasMoreLines()) {
            String string2 = lineSplitter.nextLine();
            JLabel jLabel = new JLabel(string2, 2);
            jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
            container.add(jLabel);
        }
    }

    @Override
    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            for (int i = 0; i < n2; ++i) {
                JButton jButton;
                Component component;
                Object object = objectArray[i];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof ButtonFactory ? ((ButtonFactory)object).createButton() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setName("OptionPane.button");
                    jButton.setMultiClickThreshhold(OptionPaneUI.DefaultLookup_getInt(this.optionPane, this, "OptionPane.buttonClickThreshhold", 0));
                    this.configureButton(jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(i);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[i] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (i != n) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        JButton jButton = (JButton)ancestorEvent.getComponent();
                        JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                        if (jRootPane != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            ((BasicOptionPaneUI.ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
            if (OptionPaneUI.DefaultLookup_getBoolean(this.optionPane, this, "OptionPane.setButtonMargin", true) && bl && bl2) {
                int n4 = n2 <= 2 ? 8 : 4;
                for (int i = 0; i < n2; ++i) {
                    JButton jButton = jButtonArray[i];
                    jButton.setMargin(new Insets(2, n4, 2, n4));
                }
            }
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                String string;
                String string2;
                int n = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (locale.getLanguage().equals("ja")) {
                    string2 = "OK";
                    string = "\u30ad\u30e3\u30f3\u30bb\u30eb";
                } else {
                    string2 = UIManager.getString((Object)"OptionPane.okButtonText", locale);
                    string = UIManager.getString((Object)"OptionPane.cancelButtonText", locale);
                }
                Object[] objectArray2 = n == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.noIcon"))} : (n == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.yesIcon")), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.noIcon")), new ButtonFactory(string, this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.cancelIcon"))} : (n == 2 ? new ButtonFactory[]{new ButtonFactory(string2, this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.okIcon")), new ButtonFactory(string, this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.cancelIcon"))} : new ButtonFactory[]{new ButtonFactory(string2, this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.okIcon"))}));
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIManager.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void configureButton(JButton jButton) {
        Font font = (Font)OptionPaneUI.DefaultLookup_get(this.optionPane, this, "OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    @Override
    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (this.optionPane.getOptionType() == 2 && n == 2) {
                        return 1;
                    }
                    return n;
                }
                return 0;
            }
            if (object != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!objectArray[i].equals(object)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private static int DefaultLookup_getInt(JComponent jComponent, ComponentUI componentUI, String string, int n) {
        Object object = OptionPaneUI.DefaultLookup_get(jComponent, componentUI, string);
        if (object == null || !(object instanceof Number)) {
            return n;
        }
        return ((Number)object).intValue();
    }

    private static boolean DefaultLookup_getBoolean(JComponent jComponent, ComponentUI componentUI, String string, boolean bl) {
        Object object = OptionPaneUI.DefaultLookup_get(jComponent, componentUI, string);
        if (object == null || !(object instanceof Boolean)) {
            return bl;
        }
        return (Boolean)object;
    }

    private static Object DefaultLookup_get(JComponent jComponent, ComponentUI componentUI, String string) {
        Object object;
        block4: {
            object = null;
            try {
                if (_getMethod == null) {
                    Class<?> clazz = Class.forName("sun.swing.DefaultLookup");
                    _getMethod = clazz.getDeclaredMethod("get", JComponent.class, ComponentUI.class, String.class);
                }
                if (_getMethod != null) {
                    object = _getMethod.invoke(null, jComponent, componentUI, string);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof RuntimeException)) break block4;
                throw (RuntimeException)exception;
            }
        }
        return object;
    }

    private class ButtonFactory {
        private String text;
        private int mnemonic;
        private Icon icon;

        ButtonFactory(String string, int n, Icon icon) {
            this.text = string;
            this.mnemonic = n;
            this.icon = icon;
        }

        JButton createButton() {
            JButton jButton = new JButton(this.text);
            if (this.icon != null) {
                jButton.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                jButton.setMnemonic(this.mnemonic);
                final JButton jButton2 = jButton;
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OptionPaneUI.this.optionPane instanceof SybOptionPane && ((SybOptionPane)OptionPaneUI.this.optionPane).areAltKeylessMnemonicsEnabled()) {
                            jButton2.doClick();
                        }
                    }
                };
                jButton.getInputMap(2).put(KeyStroke.getKeyStroke(this.mnemonic, 0), String.valueOf(this.mnemonic));
                jButton.getActionMap().put(String.valueOf(this.mnemonic), abstractAction);
            }
            return jButton;
        }
    }
}

