/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.OEMSupport;
import com.sybase.util.win32.Registry;
import com.sybase.util.win32.Win32Util;
import java.io.File;
import java.util.Vector;

public class Platform {
    private static boolean _installedJREFixes = false;
    private static transient Boolean _isLinux = null;
    private static transient Boolean _isMacOS = null;
    private static transient Boolean _isSunOS = null;
    private static transient Boolean _isWindows = null;
    private static transient Boolean _is64BitWindows = null;
    private static transient Boolean _isWindows9x = null;
    private static transient Boolean _isHP = null;
    private static transient Boolean _isXP = null;
    private static transient Boolean _isVista = null;

    public static void installJREFixes() {
        if (_installedJREFixes) {
            return;
        }
        if (Platform.isWindows()) {
            try {
                String string = System.getenv("userprofile");
                if (string != null && !string.isEmpty()) {
                    System.setProperty("user.home", string);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (Platform.isMacOS()) {
            Platform.setupMac();
        }
        _installedJREFixes = true;
    }

    public static boolean isLinux() {
        if (_isLinux == null) {
            _isLinux = System.getProperty("os.name").indexOf("Linux") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return _isLinux;
    }

    public static boolean isHP() {
        if (_isHP == null) {
            _isHP = System.getProperty("os.name").indexOf("HP") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return _isHP;
    }

    public static boolean isMacOS() {
        if (_isMacOS == null) {
            _isMacOS = System.getProperty("os.name").indexOf("Mac") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return _isMacOS;
    }

    public static boolean isSunOS() {
        if (_isSunOS == null) {
            _isSunOS = System.getProperty("os.name").indexOf("SunOS") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return _isSunOS;
    }

    public static boolean isWindows() {
        if (_isWindows == null) {
            _isWindows = System.getProperty("os.name").indexOf("Windows") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return _isWindows;
    }

    public static boolean isXP() {
        if (_isXP == null) {
            _isXP = System.getProperty("os.name").equals("Windows XP");
        }
        return _isXP;
    }

    public static boolean isVista() {
        if (_isVista == null) {
            boolean bl = false;
            if (Platform.isWindows()) {
                String string = System.getProperty("os.version");
                try {
                    double d = Double.parseDouble(string);
                    bl = d >= 6.0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            _isVista = bl;
        }
        return _isVista;
    }

    public static void setupMac() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.window.position.forceSafeCreation", "true");
        System.setProperty("apple.awt.window.position.forceSafeProgrammaticPositioning", "true");
    }

    public static boolean is64Bit() {
        return System.getProperty("sun.arch.data.model").indexOf("64") != -1;
    }

    public static boolean is64BitWindows() {
        if (Platform.isWindows()) {
            if (_is64BitWindows == null) {
                _is64BitWindows = Platform.is64Bit() ? Boolean.TRUE : Boolean.FALSE;
            }
            return _is64BitWindows;
        }
        return false;
    }

    public static boolean isWindows9x() {
        if (Platform.isWindows() && !Platform.is64BitWindows()) {
            if (_isWindows9x == null) {
                String string = System.getProperty("os.name");
                _isWindows9x = string.indexOf("Windows 95") == -1 && string.indexOf("Windows 98") == -1 && string.indexOf("Windows Me") == -1 ? Boolean.FALSE : Boolean.TRUE;
            }
            return _isWindows9x;
        }
        return false;
    }

    public static boolean isUsingWindowsRemoteDesktop() {
        String string;
        boolean bl = false;
        if (Platform.isWindows() && Registry.isInstalled() && (string = Registry.getValue(1, "Volatile Environment", "SESSIONNAME")) != null && string.length() > 0 && !string.equals("Console")) {
            bl = true;
        }
        return bl;
    }

    static String getSessionID() {
        String string = null;
        if (Platform.isWindows() && Registry.isInstalled()) {
            if (Platform.isVista()) {
                Vector<String> vector = Registry.enumerateKeys(1, "Volatile Environment");
                if (vector.size() > 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        String string2 = vector.get(i);
                        if (string2.length() == 0) continue;
                        try {
                            Integer.decode(string2);
                            string = string2;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            } else {
                Vector<String> vector = Registry.enumerateKeys(1, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\SessionInfo");
                if (vector.size() > 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        String string3 = vector.get(i);
                        if (string3.length() == 0) continue;
                        try {
                            Long.parseLong(string3, 16);
                            string = string3;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (string == null) {
            string = "(default)";
        }
        return string;
    }

    public static boolean allowsWindowsRemoteDesktopConnections() {
        boolean bl = false;
        if (Platform.isWindows() && Registry.isInstalled()) {
            String string;
            String string2 = System.getProperty("os.name");
            if (string2.indexOf("Windows XP") != -1) {
                String string3 = Registry.getValue(0, "SYSTEM\\CurrentControlSet\\Control\\Terminal Server", "fDenyTSConnections");
                if (string3 != null && string3.length() > 0) {
                    bl = string3.equals("0");
                }
            } else if (string2.indexOf("Windows 2000") != -1 && (string = Registry.getValue(0, "SYSTEM\\CurrentControlSet\\Control", "Product Options")) != null && string.length() > 0 && string.indexOf("Enterprise Terminal Server") != -1) {
                bl = true;
            }
        }
        return bl;
    }

    public static File getApplicationConfigurationDirectory(String string) {
        File file;
        if (Platform.isWindows()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.getenv("ALLUSERSPROFILE"));
            stringBuilder.append(File.separator);
            stringBuilder.append(string);
            file = new File(stringBuilder.toString());
            if (!file.exists() || !file.isDirectory()) {
                file.mkdirs();
            }
        } else {
            String string2 = System.getProperty("sybase.native.executable");
            if (string2 != null && !string2.isEmpty()) {
                file = new File(string2);
                file = file.getParentFile();
            } else {
                string2 = System.getProperty("user.home");
                file = new File(string2);
            }
        }
        return file;
    }

    public static String getUserConfigurationDirectory(String string) {
        File file;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        OEMSupport oEMSupport = OEMSupport.getOEMSupport();
        if (oEMSupport != null && (string2 = oEMSupport.getPreferencesFilesDirectory()) != null) {
            stringBuilder.append(string2);
            stringBuilder.append(File.separator);
        }
        if (stringBuilder.length() == 0) {
            string2 = System.getProperty("user.home");
            stringBuilder.append(string2);
            stringBuilder.append(File.separator);
            if (Platform.isWindows()) {
                stringBuilder.append("sybase");
            } else {
                stringBuilder.append(".sybase");
            }
            stringBuilder.append(File.separator);
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(string);
                stringBuilder.append(File.separator);
            }
        }
        if (!(file = new File(string2 = stringBuilder.toString())).exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return string2;
    }

    public static String getUserConfigurationDirectory() {
        File file;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        OEMSupport oEMSupport = OEMSupport.getOEMSupport();
        if (oEMSupport != null && (string = oEMSupport.getPreferencesFilesDirectory()) != null) {
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
        }
        if (stringBuilder.length() == 0) {
            string = System.getProperty("user.home");
            stringBuilder.append(string);
            stringBuilder.append(File.separator);
        }
        if (!(file = new File(string = stringBuilder.toString())).exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return string;
    }

    public static String getUserFilesDirectory() {
        if (Win32Util.isInstalled()) {
            return Win32Util.getPersonalDocumentsFolder();
        }
        return System.getProperty("user.home");
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

