/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DialogUtils;
import com.sybase.util.ImageLoader;
import com.sybase.util.NumericTextField;
import com.sybase.util.PrintDialogResourcesBase;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.event.PrintServiceAttributeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PrintDialog
extends SybModalDialog
implements ActionListener,
ChangeListener,
ItemListener,
ListSelectionListener {
    public static final int DEFAULT = 0;
    public static final int NO_ZOOM = 1;
    public static final int SINGLE_PAGE_ZOOM = 2;
    private static final String ESCAPE_COMMAND = "Escape";
    private boolean _retcode = false;
    private boolean _retcodeScaleToFit = false;
    private int _retcodeSheetsWide = 1;
    private int _retcodeSheetsHigh = 1;
    private int _options = 0;
    private PrinterJob _printerJob = null;
    private PageFormat _pageFormat = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private JList _printers = null;
    private SybButton _printerProperties = null;
    private SybButton _pageSetup = null;
    private JSpinner _copies = null;
    private SybRadioButton _portrait = null;
    private SybRadioButton _landscape = null;
    private SybCheckBox _scaleToFit = null;
    private NumericTextField _sheetsWide = null;
    private SybLabel _sheetsWideLabel = null;
    private NumericTextField _sheetsHigh = null;
    private SybLabel _sheetsHighLabel = null;
    private boolean _noPrintersDefined = false;
    private Object _disabledControlsCookie = null;

    public boolean showDialog(int n, PrinterJob printerJob, PageFormat pageFormat, JComponent jComponent) {
        if (printerJob == null) {
            throw new IllegalArgumentException("printerJob cannot be null");
        }
        if (pageFormat == null) {
            throw new IllegalArgumentException("pageFormat cannot be null");
        }
        this.createUI(n, printerJob, pageFormat, jComponent);
        this.setVisible(true);
        this.destroy();
        return this._retcode;
    }

    public boolean showDialog(int n, PrinterJob printerJob, PageFormat pageFormat) {
        return this.showDialog(n, printerJob, pageFormat, null);
    }

    public boolean getScaleToFit() {
        return this._retcodeScaleToFit;
    }

    public int getSheetsWide() {
        return this._retcodeSheetsWide;
    }

    public int getSheetsHigh() {
        return this._retcodeSheetsHigh;
    }

    public PrintDialog(Dialog dialog) {
        super(dialog);
    }

    public PrintDialog(Frame frame) {
        super(frame);
    }

    private void createUI(int n, PrinterJob printerJob, PageFormat pageFormat, Component component) {
        PrintService[] printServiceArray;
        this._options = n;
        this._printerJob = printerJob;
        this._pageFormat = pageFormat;
        PrintDialogResourcesBase printDialogResourcesBase = PrintDialogResourcesBase.getBundle();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(printDialogResourcesBase.get("3")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        int n2 = -1;
        PrintService printService = printerJob.getPrintService();
        if (printService != null) {
            String string = printerJob.getPrintService().getName();
            printServiceArray = printerJob.lookupPrintServices();
            String[] stringArray = new String[printServiceArray.length];
            for (int i = 0; i < printServiceArray.length; ++i) {
                stringArray[i] = printServiceArray[i].getName();
                if (!stringArray[i].equals(string)) continue;
                n2 = i;
            }
        } else {
            printServiceArray = new PrintService[]{new DummyPrintService()};
            this._noPrintersDefined = true;
        }
        this._printers = new JList<PrintService>(printServiceArray);
        this._printers.setCellRenderer(new PrinterListRenderer());
        this._printers.setVisibleRowCount(4);
        this._printers.setLayoutOrientation(1);
        JScrollPane jScrollPane = new JScrollPane(this._printers);
        if (n2 != -1) {
            this._printers.setSelectedIndex(n2);
        }
        this._printers.addListSelectionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(printDialogResourcesBase.get("10")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        SybLabel sybLabel = new SybLabel(printDialogResourcesBase.get("5"));
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)sybLabel, gridBagConstraints);
        this._copies = new JSpinner(new SpinnerNumberModel(1, 1, 10000, 1));
        this._copies.addChangeListener(this);
        this._copies.setEditor(new JSpinner.NumberEditor(this._copies));
        sybLabel.setLabelFor(this._copies);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this._copies, gridBagConstraints);
        sybLabel = new SybLabel(printDialogResourcesBase.get("6"));
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel3.add((Component)sybLabel, gridBagConstraints);
        this._portrait = new SybRadioButton(printDialogResourcesBase.get("7"));
        this._portrait.addItemListener(this);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel3.add((Component)this._portrait, gridBagConstraints);
        this._landscape = new SybRadioButton(printDialogResourcesBase.get("8"));
        this._landscape.addItemListener(this);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel3.add((Component)this._landscape, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._portrait);
        buttonGroup.add(this._landscape);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(printDialogResourcesBase.get("9")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._scaleToFit = new SybCheckBox(printDialogResourcesBase.get("12"));
        this._scaleToFit.addActionListener(this);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel4.add((Component)this._scaleToFit, gridBagConstraints);
        this._sheetsWide = new NumericTextField();
        this._sheetsWide.setText("1");
        this._sheetsWide.setColumns(10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        jPanel4.add((Component)this._sheetsWide, gridBagConstraints);
        this._sheetsWideLabel = new SybLabel(printDialogResourcesBase.get("13"));
        this._sheetsWideLabel.setLabelFor(this._sheetsWide);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel4.add((Component)this._sheetsWideLabel, gridBagConstraints);
        this._sheetsHigh = new NumericTextField();
        this._sheetsHigh.setText("1");
        this._sheetsHigh.setColumns(10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        jPanel4.add((Component)this._sheetsHigh, gridBagConstraints);
        this._sheetsHighLabel = new SybLabel(printDialogResourcesBase.get("14"));
        this._sheetsHighLabel.setLabelFor(this._sheetsHigh);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel4.add((Component)this._sheetsHighLabel, gridBagConstraints);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel4.add(Box.createGlue(), gridBagConstraints);
        this._printerProperties = new SybButton(printDialogResourcesBase.get("4"));
        this._printerProperties.addActionListener(this);
        this._pageSetup = new SybButton(printDialogResourcesBase.get("11"));
        this._pageSetup.addActionListener(this);
        this._ok = new SybButton(printDialogResourcesBase.get("1"));
        this._ok.addActionListener(this);
        this._cancel = new SybButton(printDialogResourcesBase.get("2"));
        this._cancel.addActionListener(this);
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this._printerProperties);
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(this._pageSetup);
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(this._ok);
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add(this._cancel);
        jPanel.setLayout(new GridBagLayout());
        int n3 = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if ((n & 1) != 0) {
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jPanel3, gridBagConstraints);
        } else {
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        }
        ++n3;
        if (component != null) {
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jPanel.add(component, gridBagConstraints);
        }
        gridBagConstraints.anchor = 24;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel5, gridBagConstraints);
        JRootPane jRootPane = this.getRootPane();
        jRootPane.getContentPane().add(jPanel);
        jRootPane.setDefaultButton(this._ok);
        jRootPane.registerKeyboardAction(this, ESCAPE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        if (this._noPrintersDefined) {
            this._ok.setEnabled(false);
            this._printerProperties.setEnabled(false);
            this._pageSetup.setEnabled(false);
        }
        this.updateControls();
        this.setTitle(printDialogResourcesBase.get("0"));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateControls() {
        int n = this._printerJob.getCopies();
        this._copies.setValue(n);
        if (this._pageFormat.getOrientation() == 0) {
            this._landscape.setSelected(true);
        } else {
            this._portrait.setSelected(true);
        }
        boolean bl = (this._options & 1) == 0 && (this._options & 2) == 0 && this._scaleToFit.isSelected();
        this._sheetsHigh.setEnabled(bl);
        this._sheetsHighLabel.setEnabled(bl);
        this._sheetsWide.setEnabled(bl);
        this._sheetsWideLabel.setEnabled(bl);
    }

    private void destroy() {
        if (this._printers != null) {
            this._printers.removeListSelectionListener(this);
            this._printers = null;
        }
        if (this._copies != null) {
            this._copies.removeChangeListener(this);
            this._copies = null;
        }
        if (this._portrait != null) {
            this._portrait.removeItemListener(this);
            this._portrait = null;
        }
        if (this._landscape != null) {
            this._landscape.removeItemListener(this);
            this._landscape = null;
        }
        if (this._scaleToFit != null) {
            this._scaleToFit.removeActionListener(this);
            this._scaleToFit = null;
        }
        this._sheetsWide = null;
        this._sheetsWideLabel = null;
        this._sheetsHigh = null;
        this._sheetsHighLabel = null;
        if (this._pageSetup != null) {
            this._pageSetup.removeActionListener(this);
            this._pageSetup = null;
        }
        if (this._printerProperties != null) {
            this._printerProperties.removeActionListener(this);
            this._printerProperties = null;
        }
        if (this._ok != null) {
            this._ok.removeActionListener(this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener(this);
            this._cancel = null;
        }
        this.getRootPane().setDefaultButton(null);
        DialogUtils.removeComponents(this);
    }

    private void handlePrinterProperties() {
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                PrintDialog.this._printerJob.printDialog();
                return null;
            }

            @Override
            public void finished() {
                PrintDialog.this.enableDialogControls();
                PrintDialog.this.updateControls();
            }
        };
        this.disableDialogControls();
        swingWorker.start();
    }

    private void handlePageSetup() {
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                PageFormat pageFormat = PrintDialog.this._printerJob.pageDialog(PrintDialog.this._pageFormat);
                if (pageFormat != PrintDialog.this._pageFormat) {
                    PrintDialog.this._pageFormat.setPaper(pageFormat.getPaper());
                    PrintDialog.this._pageFormat.setOrientation(pageFormat.getOrientation());
                }
                return null;
            }

            @Override
            public void finished() {
                PrintDialog.this.enableDialogControls();
                PrintDialog.this.updateControls();
            }
        };
        this.disableDialogControls();
        swingWorker.start();
    }

    private void disableDialogControls() {
        this._disabledControlsCookie = DialogUtils.disableControls(this.getContentPane());
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void enableDialogControls() {
        DialogUtils.enableControls(this._disabledControlsCookie);
        this._disabledControlsCookie = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void handleOK() {
        this._retcode = true;
        if ((this._options & 1) == 0) {
            this._retcodeScaleToFit = this._scaleToFit.isSelected();
            String string = this._sheetsWide.getText();
            try {
                this._retcodeSheetsWide = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this._retcodeSheetsWide = 1;
            }
            string = this._sheetsHigh.getText();
            try {
                this._retcodeSheetsHigh = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this._retcodeSheetsHigh = 1;
            }
        } else {
            this._retcodeScaleToFit = false;
        }
        this.setVisible(false);
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._printerProperties) {
            this.handlePrinterProperties();
        } else if (object == this._pageSetup) {
            this.handlePageSetup();
        } else if (object == this._scaleToFit) {
            this.updateControls();
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals(ESCAPE_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PrintService printService;
        if (!listSelectionEvent.getValueIsAdjusting() && (printService = (PrintService)this._printers.getSelectedValue()) != null) {
            try {
                this._printerJob.setPrintService(printService);
                this.updateControls();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Integer n = (Integer)this._copies.getValue();
        this._printerJob.setCopies(n);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this._landscape || itemEvent.getSource() == this._portrait) {
            if (this._landscape.isSelected()) {
                this._pageFormat.setOrientation(0);
            } else {
                this._pageFormat.setOrientation(1);
            }
        }
    }

    private void __showPrintServiceInfo(PrintService printService) {
    }

    static class PrinterListRenderer
    extends DefaultListCellRenderer {
        private static ImageIcon _printerIcon = null;

        PrinterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof DummyPrintService) {
                bl2 = false;
                bl = false;
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof DummyPrintService) {
                this.setIcon(null);
                this.setEnabled(false);
                this.setText(PrintDialogResourcesBase.getBundle().get("15"));
            } else if (object instanceof PrintService) {
                PrintService printService = (PrintService)object;
                this.setText(printService.getName());
                if (_printerIcon == null) {
                    _printerIcon = ImageLoader.getImageIcon(this.getClass(), "print", 1001);
                }
                this.setIcon(_printerIcon);
            }
            return this;
        }
    }

    static class DummyPrintService
    implements PrintService {
        DummyPrintService() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public DocPrintJob createPrintJob() {
            return null;
        }

        @Override
        public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        }

        @Override
        public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        }

        @Override
        public PrintServiceAttributeSet getAttributes() {
            return null;
        }

        @Override
        public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
            return null;
        }

        @Override
        public DocFlavor[] getSupportedDocFlavors() {
            return null;
        }

        @Override
        public boolean isDocFlavorSupported(DocFlavor docFlavor) {
            return false;
        }

        public Class[] getSupportedAttributeCategories() {
            return null;
        }

        public boolean isAttributeCategorySupported(Class clazz) {
            return false;
        }

        public Object getDefaultAttributeValue(Class clazz) {
            return null;
        }

        public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
            return null;
        }

        @Override
        public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
            return false;
        }

        @Override
        public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
            return null;
        }

        @Override
        public ServiceUIFactory getServiceUIFactory() {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    }
}

