/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.PrintJobListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintJobThread
extends Thread {
    Printable _printable = null;
    String _jobName = null;
    PrintJobListener _printJobListener = null;
    PageFormat _pageFormat = null;
    PrinterJob _printerJob = null;
    boolean _busy = false;

    public PrintJobThread(Printable printable, PrinterJob printerJob, PageFormat pageFormat, PrintJobListener printJobListener) {
        if (printable == null) {
            throw new IllegalArgumentException();
        }
        if (printerJob == null) {
            throw new IllegalArgumentException();
        }
        if (pageFormat == null) {
            throw new IllegalArgumentException();
        }
        this._printable = printable;
        this._printerJob = printerJob;
        this._pageFormat = pageFormat;
        this._printJobListener = printJobListener;
    }

    public PrintJobThread(Printable printable) {
        this(printable, "", null);
    }

    public PrintJobThread(Printable printable, String string) {
        this(printable, string, null);
    }

    public PrintJobThread(Printable printable, String string, PrintJobListener printJobListener) {
        this._printable = printable;
        this._jobName = string;
        this._printJobListener = printJobListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        this._busy = true;
        if (this._printerJob == null) {
            bl = true;
            this._printerJob = PrinterJob.getPrinterJob();
            this._printerJob.setJobName(this._jobName);
        }
        this._printerJob.setPrintable(this._printable, this._pageFormat);
        boolean bl2 = bl ? this._printerJob.printDialog() : true;
        if (bl2) {
            if (this._printJobListener != null) {
                this._printJobListener.printingStarted();
            }
            try {
                this._printerJob.print();
            }
            catch (PrinterException printerException) {
                if (!(printerException instanceof PrinterAbortException) && this._printJobListener != null) {
                    this._printJobListener.printerException(printerException);
                }
            }
            finally {
                if (this._printJobListener != null) {
                    this._printJobListener.printingStopped();
                }
            }
        }
        this._busy = false;
    }

    public boolean isBusy() {
        return this._busy;
    }

    public void cancel() {
        this._busy = false;
        this._printerJob.cancel();
    }
}

