/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.ReflectionProxyException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class ReflectionProxy {
    protected Object _object = null;
    protected Class<?> _class = null;
    protected Hashtable<String, Method> _hashtable = null;

    public ReflectionProxy(String string) throws ReflectionProxyException {
        try {
            this._class = Class.forName(string);
            this._object = this._class.newInstance();
            this._hashtable = new Hashtable();
        }
        catch (Exception exception) {
            throw new ReflectionProxyException(exception);
        }
    }

    public ReflectionProxy(String string, Class[] classArray, Object[] objectArray) throws ReflectionProxyException {
        try {
            this._class = Class.forName(string);
            Constructor<?> constructor = this._class.getConstructor(classArray);
            this._object = constructor.newInstance(objectArray);
            this._hashtable = new Hashtable();
        }
        catch (Exception exception) {
            throw new ReflectionProxyException(exception);
        }
    }

    public ReflectionProxy(String string, Class[] classArray, Object[] objectArray, ClassLoader classLoader) throws ReflectionProxyException {
        try {
            this._class = Class.forName(string, true, classLoader);
            Constructor<?> constructor = this._class.getConstructor(classArray);
            this._object = constructor.newInstance(objectArray);
            this._hashtable = new Hashtable();
        }
        catch (Exception exception) {
            throw new ReflectionProxyException(exception);
        }
    }

    public ReflectionProxy(Object object) {
        this._object = object;
        this._class = object.getClass();
        this._hashtable = new Hashtable();
    }

    public Method findMethod(String string, Class[] classArray) throws ReflectionProxyException {
        Method method = null;
        method = this._hashtable.get(string);
        if (method == null) {
            try {
                method = this._class.getMethod(string, classArray);
                this._hashtable.put(string, method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ReflectionProxyException(noSuchMethodException);
            }
        }
        return method;
    }

    public Object invokeMethod(Method method, Object[] objectArray) throws ReflectionProxyException {
        Object object = null;
        try {
            object = method.invoke(this._object, objectArray);
        }
        catch (Exception exception) {
            throw new ReflectionProxyException(exception);
        }
        return object;
    }

    public String invokeStringMethod(Method method, Object[] objectArray) throws ReflectionProxyException {
        Object object = this.invokeMethod(method, objectArray);
        return object == null ? null : object.toString();
    }

    public Object invokeMethod(String string, Class[] classArray, Object[] objectArray) throws ReflectionProxyException {
        Method method = this.findMethod(string, classArray);
        Object object = this.invokeMethod(method, objectArray);
        return object;
    }

    public String invokeStringMethod(String string, Class[] classArray, Object[] objectArray) throws ReflectionProxyException {
        Object object = this.invokeMethod(string, classArray, objectArray);
        return object == null ? null : object.toString();
    }

    public Object getFieldValue(String string) throws ReflectionProxyException {
        Object object = null;
        try {
            Field field = this._class.getField(string);
            object = field.get(this._object);
        }
        catch (Exception exception) {
            throw new ReflectionProxyException(exception);
        }
        return object;
    }

    public Object getObject() {
        return this._object;
    }
}

