/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SCC;
import com.sybase.util.SCCCommandDialog;
import com.sybase.util.SCCException;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybOptionPane;
import java.io.File;
import javax.swing.JFrame;

public class SCCCheckInDialog
extends SCCCommandDialog {
    public static boolean create(JFrame jFrame, SCC sCC, File file) {
        if (sCC == null) {
            throw new IllegalArgumentException("SCC can't be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        SCCCheckInDialog sCCCheckInDialog = new SCCCheckInDialog(jFrame, sCC, file);
        boolean bl = sCCCheckInDialog.open();
        return bl;
    }

    private SCCCheckInDialog(JFrame jFrame, SCC sCC, File file) {
        super(jFrame, sCC, file);
    }

    @Override
    protected int getCommand() {
        return 2;
    }

    @Override
    protected String getDialogTitle() {
        SCCResourcesBase sCCResourcesBase = SCCResourcesBase.getBundle();
        String string = sCCResourcesBase.get("CI01");
        return string;
    }

    @Override
    protected SwingWorker getWorker() {
        return new MyWorker();
    }

    @Override
    protected String getFileLabel() {
        SCCResourcesBase sCCResourcesBase = SCCResourcesBase.getBundle();
        return sCCResourcesBase.get("CI02");
    }

    @Override
    protected boolean commandSupportsComment() {
        int n = this._scc.getCapabilities();
        boolean bl = (n & 0x1000) != 0;
        return bl;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    private class MyWorker
    extends SwingWorker {
        private MyWorker() {
        }

        @Override
        public Object construct() {
            SCCException sCCException = null;
            String[] stringArray = new String[]{SCCCheckInDialog.this._file.getAbsolutePath()};
            String string = SCCCheckInDialog.this.getComment();
            try {
                SCCCheckInDialog.this._scc.checkin(stringArray, string, 0L, SCCCheckInDialog.this._commandOptions);
            }
            catch (SCCException sCCException2) {
                sCCException = sCCException2;
            }
            return sCCException;
        }

        @Override
        public void finished() {
            SCCException sCCException = (SCCException)this.getValue();
            if (sCCException == null) {
                SCCCheckInDialog.this.setVisible(false);
                SCCCheckInDialog.this._retcode = true;
            } else {
                String string = SCCResourcesBase.getMessage("CI03", SCCCheckInDialog.this._file.getName(), sCCException.getLocalizedMessage());
                SybOptionPane.showMessageDialog(SCCCheckInDialog.this, string, SCCCheckInDialog.this.getTitle(), 0);
                SCCCheckInDialog.this.enableButtons(true);
            }
        }
    }
}

