/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DialogUtils;
import com.sybase.util.SCC;
import com.sybase.util.SCCException;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybTextArea;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

abstract class SCCCommandDialog
extends SybModalDialog
implements ActionListener,
WindowListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    protected boolean _retcode = false;
    protected File _file = null;
    protected SCC _scc = null;
    protected long _commandOptions = 0L;
    private SybTextArea _comment = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _optionsButton = null;

    protected abstract String getDialogTitle();

    protected abstract SwingWorker getWorker();

    protected abstract String getFileLabel();

    protected abstract boolean commandSupportsComment();

    protected abstract int getCommand();

    protected JPanel getCommandOptionPanel() {
        return null;
    }

    protected boolean open() {
        UIUtils.ensureWindowIsVisible(this);
        this.setVisible(true);
        boolean bl = this._retcode;
        this.destroy();
        return bl;
    }

    protected SCCCommandDialog(JFrame jFrame, SCC sCC, File file) {
        super(jFrame);
        this._scc = sCC;
        this._file = file;
        this.createGUI(jFrame);
        this.addWindowListener(this);
    }

    private void createGUI(JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        int n = 0;
        SybLabel sybLabel = new SybLabel(this.getFileLabel());
        JTextField jTextField = new JTextField(this._file.getAbsolutePath(), 40);
        jTextField.setEditable(false);
        sybLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        JPanel jPanel2 = this.getCommandOptionPanel();
        if (jPanel2 != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }
        if (this.commandSupportsComment()) {
            sybLabel = new SybLabel(SCCResourcesBase.getMessage("CD01", new Object[0]));
            this._comment = new SybTextArea(3, 40);
            this._comment.setTabMovesFocus(true);
            JScrollPane jScrollPane = new JScrollPane(this._comment);
            sybLabel.setLabelFor(this._comment);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)sybLabel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jScrollPane, gridBagConstraints);
        }
        this._ok = new SybButton(SCCResourcesBase.getMessage("CD02", new Object[0]));
        this._ok.addActionListener(this);
        this._cancel = new SybButton(SCCResourcesBase.getMessage("CD03", new Object[0]));
        this._cancel.addActionListener(this);
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        if (this.commandSupportsOptions()) {
            this._optionsButton = new SybButton(SCCResourcesBase.getMessage("CD04", new Object[0]));
            this._optionsButton.addActionListener(this);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        if (this._optionsButton != null) {
            jPanel3.add(this._optionsButton);
            jPanel3.add(Box.createHorizontalStrut(5));
        }
        jPanel3.add(this._ok);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(this._cancel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().setDefaultButton(this._ok);
        this.getContentPane().add(jPanel);
        this.setTitle(this.getDialogTitle());
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
    }

    protected String getComment() {
        String string = this._comment != null ? this._comment.getText() : null;
        return string;
    }

    protected void destroy() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener(this);
        this._ok = null;
        this._cancel.removeActionListener(this);
        this._cancel = null;
        if (this._optionsButton != null) {
            this._optionsButton.removeActionListener(this);
            this._optionsButton = null;
        }
        this._file = null;
        this._scc = null;
        this._comment = null;
        DialogUtils.removeComponents(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (this._optionsButton != null && object == this._optionsButton) {
            this.handleOptions();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    protected boolean commandSupportsOptions() {
        boolean bl;
        try {
            bl = this._scc.hasCommandOptions(this.getCommand());
        }
        catch (SCCException sCCException) {
            bl = false;
        }
        return bl;
    }

    private void handleOptions() {
        this.enableButtons(false);
        GCOWorker gCOWorker = new GCOWorker();
        gCOWorker.start();
    }

    private void handleOK() {
        this.enableButtons(false);
        SwingWorker swingWorker = this.getWorker();
        swingWorker.start();
    }

    private void handleCancel() {
        this.enableButtons(false);
        this.setVisible(false);
        this._retcode = false;
    }

    protected void enableButtons(boolean bl) {
        this._ok.setEnabled(bl);
        this._cancel.setEnabled(bl);
        if (this._optionsButton != null) {
            this._optionsButton.setEnabled(bl);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        boolean bl;
        this.removeWindowListener(this);
        boolean bl2 = bl = this.getCommandOptionPanel() != null || this.commandSupportsComment() || this.commandSupportsOptions();
        if (!bl) {
            this._ok.doClick();
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    private class GCOWorker
    extends SwingWorker {
        private GCOWorker() {
        }

        @Override
        public Object construct() {
            try {
                SCCCommandDialog.this._commandOptions = SCCCommandDialog.this._scc.getCommandOptions(SCCCommandDialog.this.getCommand(), SCCCommandDialog.this, null);
            }
            catch (SCCException sCCException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void finished() {
            SCCCommandDialog.this.enableButtons(true);
        }
    }
}

