/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.BatchSCC;
import com.sybase.util.DialogUtils;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SybButton;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

class SCCTemplatesDialog
extends SybModalDialog
implements ActionListener,
MouseListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static SCCResourcesBase _bundle = null;
    private JList _list;
    private SybButton _ok;
    private SybButton _cancel;
    private String _profileFile = null;

    SCCTemplatesDialog(JDialog jDialog) {
        super(jDialog);
        _bundle = SCCResourcesBase.getBundle();
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(_bundle.get("BSCC15"), 80);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)sybMultiLineLabel, "Center");
        this._list = new JList<Object>(this.getTemplates());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(this._list), "Center");
        this._ok = new SybButton(_bundle.get("BSCC07"));
        this._cancel = new SybButton(_bundle.get("BSCC08"));
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this._ok);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(this._cancel);
        jPanel3.add(Box.createHorizontalGlue());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this._ok);
        jRootPane.getContentPane().add(jPanel4);
        this._list.setSelectedIndex(0);
        this._list.requestFocusInWindow();
        this.setTitle(_bundle.get("BSCC14"));
        this.pack();
        this.setLocationRelativeTo(jDialog);
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._list.addMouseListener(this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
    }

    String getProfileFile() {
        return this._profileFile;
    }

    void destroy() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(null);
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._list.removeMouseListener(this);
        this._ok.removeActionListener(this);
        this._cancel.removeActionListener(this);
        DialogUtils.removeComponents(this);
    }

    Object[] getTemplates() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.getClass().getClassLoader();
            Enumeration<URL> enumeration = ClassLoader.getSystemResources("scctemplates");
            if (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> enumeration2 = jarFile.entries();
                while (enumeration2.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration2.nextElement();
                    String string = zipEntry.getName();
                    if (string.length() <= 13 || !string.startsWith("scctemplates/")) continue;
                    arrayList.add(string.substring(13));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void handleOK() {
        Object e = this._list.getSelectedValue();
        if (e != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("scctemplates/" + e.toString()));
            try {
                int n;
                File file = File.createTempFile("sybscc", "cfg");
                file.deleteOnExit();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                while ((n = bufferedInputStream.read()) != -1) {
                    bufferedOutputStream.write(n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
                this._profileFile = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog(BatchSCC.getParentFrame(), SCCResourcesBase.getMessage("M6", iOException.getLocalizedMessage()), SCCResourcesBase.getMessage("M1", new Object[0]), 0);
            }
            this.setVisible(false);
        }
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.handleOK();
        }
    }
}

