/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.STDIOWindow;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.OutputStream;
import java.io.PrintStream;

class STDIORedirector
extends OutputStream
implements WindowListener {
    static STDIORedirector _stdoutRedirector = null;
    static STDIORedirector _stderrRedirector = null;
    static STDIOWindow _window = null;
    PrintStream _oldStream = null;

    static void initialize() {
        if (_stdoutRedirector == null) {
            _stdoutRedirector = new STDIORedirector(System.out);
            System.setOut(new PrintStream(_stdoutRedirector, true));
        }
        if (_stderrRedirector == null) {
            _stderrRedirector = new STDIORedirector(System.err);
            System.setErr(new PrintStream(_stderrRedirector, true));
        }
    }

    STDIORedirector(PrintStream printStream) {
        this._oldStream = printStream;
    }

    @Override
    public void write(int n) {
        if (_window == null) {
            _window = new STDIOWindow("Standard Output/Error", 0);
            _window.addWindowListener(this);
        }
        _window.write(n);
        if (this._oldStream != null) {
            this._oldStream.write(n);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        _window.removeWindowListener(this);
        _window = null;
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

