/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.Platform;
import com.sybase.util.SCCResourcesBase;
import com.sybase.util.SybButton;
import com.sybase.util.SybMenu;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;

class STDIOWindow
extends JFrame
implements ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    static final int OPT_CLOSE_BUTTON = 1;
    static final int OPT_STDIN = 2;
    private static final int INITIAL_WIDTH = 600;
    private static final int INITIAL_HEIGHT = 300;
    private JTextArea _textArea = null;
    private StringBuffer _buffer = null;
    private Timer _timer = null;
    private SybButton _close = null;

    STDIOWindow(String string, int n) {
        super(string);
        JPanel jPanel = new JPanel(new BorderLayout());
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._textArea);
        if ((n & 1) == 0) {
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        jPanel.add((Component)jScrollPane, "Center");
        if (Platform.isMacOS()) {
            JMenuBar jMenuBar = new JMenuBar();
            SybMenu sybMenu = new SybMenu(SCCResourcesBase.getMessage("STDIO02", new Object[0]));
            jMenuBar.add(sybMenu);
            SybMenuItem sybMenuItem = new SybMenuItem(SCCResourcesBase.getMessage("STDIO01", new Object[0]));
            sybMenu.add(sybMenuItem);
            sybMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    STDIOWindow.this._textArea.setText("");
                    STDIOWindow.this.setVisible(false);
                }
            });
            this.setJMenuBar(jMenuBar);
            n &= 0xFFFFFFFE;
        }
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        if ((n & 1) != 0) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this._close = new SybButton(SCCResourcesBase.getMessage("STDIO01", new Object[0]));
            this._close.addActionListener(this);
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add(this._close);
            jPanel2.add(Box.createHorizontalGlue());
            jPanel.add((Component)jPanel2, "South");
            this.getRootPane().setDefaultButton(this._close);
        }
        this.getRootPane().getContentPane().add(jPanel);
        Rectangle rectangle = UIUtils.getWorkArea();
        rectangle.x += (rectangle.width - 600) / 2;
        rectangle.y += (rectangle.height - 300) / 2;
        this.setBounds(rectangle.x, rectangle.y, 600, 300);
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Image image;
            if (frameArray[i] instanceof STDIOWindow || (image = frameArray[i].getIconImage()) == null) continue;
            this.setIconImage(image);
            break;
        }
        this.setVisible(true);
    }

    void write(int n) {
        if (this._buffer == null) {
            this._buffer = new StringBuffer(128);
        }
        this._buffer.append(Character.toString((char)n));
        if (n == 10) {
            this.flushBuffer();
        } else {
            if (this._timer == null) {
                this._timer = new Timer(250, this);
                this._timer.setRepeats(false);
            }
            if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }
    }

    void writeln(String string) {
        if (this._buffer == null) {
            this._buffer = new StringBuffer(128);
        }
        this._buffer.append(string);
        this._buffer.append('\n');
        this.flushBuffer();
    }

    private void flushBuffer() {
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this._buffer != null) {
            this._textArea.append(this._buffer.toString());
            this._buffer = null;
            int n = this._textArea.getDocument().getLength();
            this._textArea.setCaretPosition(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._close || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this._textArea.setText("");
            this.setVisible(false);
        } else {
            this.flushBuffer();
        }
    }
}

