/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SplashScreen
extends JFrame
implements ActionListener,
MouseListener,
WindowListener {
    private static ArrayList<WeakReference<SplashScreen>> _splashScreens = null;
    private Image _splashImage = null;
    private JLabel _messageLabel;
    private Timer _timer = null;
    private boolean _closed = false;

    public static void close() {
        if (_splashScreens != null) {
            for (int i = _splashScreens.size() - 1; i >= 0; --i) {
                WeakReference<SplashScreen> weakReference = _splashScreens.get(i);
                SplashScreen splashScreen = (SplashScreen)weakReference.get();
                if (splashScreen == null) continue;
                splashScreen.releaseResources();
            }
            _splashScreens.clear();
            _splashScreens = null;
        }
    }

    private void releaseResources() {
        this.removeWindowListener(this);
        this.removeMouseListener(this);
        this.setVisible(false);
        if (this._timer != null) {
            this._timer.stop();
            this._timer.removeActionListener(this);
            this._timer = null;
        }
        if (this._splashImage != null) {
            this._splashImage.flush();
            this._splashImage = null;
        }
        this._messageLabel = null;
        this._closed = true;
        this.dispose();
    }

    public SplashScreen(Image image) {
        this(image, null, null);
    }

    public SplashScreen(Image image, String string, String string2) {
        this(image, string, string2, null, null);
    }

    public SplashScreen(Image image, String string, String string2, Image image2, String string3) {
        Object var10_6 = null;
        Object var13_7 = null;
        if (_splashScreens == null) {
            _splashScreens = new ArrayList();
        }
        _splashScreens.add(new WeakReference<SplashScreen>(this));
        Container container = this.getContentPane();
        this.setUndecorated(true);
        this._splashImage = image;
        if (string3 != null) {
            this.setTitle(string3);
        }
        if (image2 != null) {
            this.setIconImage(image2);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this._splashImage, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        container.setForeground(Color.black);
        container.setBackground(Color.black);
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(BorderFactory.createLineBorder(new Color(0, 52, 75), 2));
        }
        int n = 0;
        JLabel jLabel = new JLabel(new ImageIcon(this._splashImage));
        container.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        if (string != null) {
            string = string.replace('\n', ' ').trim();
            int n2 = 500 / jLabel.getFontMetrics(jLabel.getFont()).charWidth('o');
            SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(string, n2, 0.5f);
            sybMultiLineLabel.setForeground(Color.white);
            sybMultiLineLabel.setBackground(Color.black);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridy = n++;
            container.add((Component)sybMultiLineLabel, gridBagConstraints);
        }
        if (string2 != null) {
            this._messageLabel = new JLabel(string2, 0);
            this._messageLabel.setOpaque(true);
            this._messageLabel.setForeground(Color.white);
            this._messageLabel.setBackground(Color.black);
            container.add((Component)this._messageLabel, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 6, 6));
        } else {
            this._messageLabel = null;
        }
        this.pack();
        int n3 = (int)this.getPreferredSize().getWidth();
        int n4 = (int)this.getPreferredSize().getHeight();
        Rectangle rectangle = UIUtils.getWorkArea();
        int n5 = rectangle.x + (rectangle.width - n3) / 2;
        n = rectangle.y + (rectangle.height - n4) / 2;
        this.setBounds(n5, n, n3, n4);
        this.setVisible(true);
        if (container instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((JComponent)container).paintImmediately(0, 0, n3, n4);
            } else {
                final JComponent jComponent = (JComponent)container;
                final int n6 = n3;
                final int n7 = n4;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jComponent.paintImmediately(0, 0, n6, n7);
                    }
                });
            }
        }
        this.addMouseListener(this);
        this.addWindowListener(this);
        this._timer = new Timer(250, this);
        this._timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            boolean bl = false;
            Frame[] frameArray = Frame.getFrames();
            block0: for (int i = 0; i < frameArray.length; ++i) {
                Window[] windowArray;
                if (frameArray[i] == this || !frameArray[i].isVisible() || (windowArray = frameArray[i].getOwnedWindows()) == null) continue;
                for (int j = 0; j < windowArray.length; ++j) {
                    Window window = windowArray[j];
                    if (!window.isVisible() || !(window instanceof Dialog)) continue;
                    bl = true;
                    break block0;
                }
            }
            if (bl) {
                SplashScreen.close();
            }
        }
    }

    public void setStatusMessage(String string) {
        if (this._messageLabel != null) {
            this._messageLabel.setText(string);
            this.repaint();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this._closed) {
            super.setVisible(bl);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        Window window = windowEvent.getOppositeWindow();
        if (window instanceof JDialog) {
            this.setVisible(false);
        } else if (window != null) {
            this.toFront();
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SplashScreen.close();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

