/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private boolean _wasInterrupted = false;
    private boolean _runFinishIfInterrupted = true;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
        this._wasInterrupted = true;
    }

    public void join() {
        try {
            Thread thread = this.threadVar.get();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isAlive() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            return thread.isAlive();
        }
        return false;
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread);
    }

    public SwingWorker(int n, boolean bl) {
        this._runFinishIfInterrupted = bl;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                if (!SwingWorker.this._wasInterrupted || SwingWorker.this._runFinishIfInterrupted) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        Thread thread = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread);
        this.threadVar.get().setPriority(n);
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

