/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EmbeddedMnemonic;
import com.sybase.util.EmbeddedMnemonicComponent;
import com.sybase.util.Platform;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class SybCheckBoxMenuItem
extends JCheckBoxMenuItem
implements EmbeddedMnemonicComponent {
    private EmbeddedMnemonic _em = null;

    public SybCheckBoxMenuItem() {
    }

    public SybCheckBoxMenuItem(Action action) {
        super(action);
        this.setTextWithEmbeddedMnemonicFromAction(action);
    }

    public SybCheckBoxMenuItem(Icon icon) {
        super(icon);
    }

    public SybCheckBoxMenuItem(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybCheckBoxMenuItem(String string, boolean bl) {
        super(null, bl);
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybCheckBoxMenuItem(String string, Icon icon) {
        super(icon);
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybCheckBoxMenuItem(String string, Icon icon, boolean bl) {
        super(null, icon, bl);
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public EmbeddedMnemonic getEmbeddedMnemonic() {
        return this._em;
    }

    @Override
    public void setText(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public void setMnemonic(int n) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(n);
        }
        if (!Platform.isMacOS()) {
            super.setMnemonic(n);
        }
    }

    @Override
    public void setMnemonic(char c) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(c);
        }
        if (!Platform.isMacOS()) {
            super.setMnemonic(c);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        if (!Platform.isMacOS()) {
            super.setIcon(icon);
        }
    }

    public void setTextWithEmbeddedMnemonic(String string) {
        int n = this.getMnemonic();
        EmbeddedMnemonic embeddedMnemonic = EmbeddedMnemonic.getEmbeddedMnemonic(string);
        if (embeddedMnemonic.getMnemonic() == '\u0000' && n != 0) {
            embeddedMnemonic.setMnemonic(n);
        }
        this._em = null;
        super.setText(embeddedMnemonic.textWithoutMnemonic);
        if (!Platform.isMacOS()) {
            super.setMnemonic(embeddedMnemonic.c);
            super.setDisplayedMnemonicIndex(embeddedMnemonic.index);
        }
        this._em = embeddedMnemonic;
    }

    @Override
    public void setAction(Action action) {
        super.setAction(action);
        this.setTextWithEmbeddedMnemonicFromAction(action);
    }

    private void setTextWithEmbeddedMnemonicFromAction(Action action) {
        String string;
        Integer n = (Integer)action.getValue("MnemonicKey");
        if (n == null && (string = (String)action.getValue("Name")) != null && string.length() != 0) {
            this.setTextWithEmbeddedMnemonic(string);
        }
    }
}

