/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybClasspathPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SybClassLoader
extends SecureClassLoader {
    static final String BLANK_STRING = "";
    static final String JAR_STRING = "jar";
    static final String JAR_SYNTAX_STRING = "!/";
    static final String JAR_EXT_STRING = ".jar";
    static final String CLASS_EXT_STRING = ".class";
    static final String JAR_TAG = "jar:";
    static final String FILE_TAG = "file:";
    static final int DIRECTORY = 1;
    static final int JAR = 2;
    private String _fullClasspath = "";
    private Vector<SybClasspathPart> _classpathParts = new Vector(15);

    public SybClassLoader(String string) {
        this.addToClasspath(string);
    }

    public SybClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.addToClasspath(null);
    }

    public void addToClasspath(String string) {
        if (string != null) {
            this._fullClasspath = this._fullClasspath.equals(BLANK_STRING) ? string : this._fullClasspath + File.pathSeparator + string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                SybClasspathPart sybClasspathPart = new SybClasspathPart(string2);
                this._classpathParts.add(sybClasspathPart);
            }
        }
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        Enumeration<SybClasspathPart> enumeration = this._classpathParts.elements();
        while (enumeration.hasMoreElements()) {
            SybClasspathPart sybClasspathPart = enumeration.nextElement();
            inputStream = sybClasspathPart.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return super.getResourceAsStream(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        SybClasspathPart sybClasspathPart = null;
        byte[] byArray = null;
        File file = null;
        CodeSource codeSource = null;
        try {
            Enumeration<SybClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements() && (byArray = (sybClasspathPart = enumeration.nextElement()).getClassBytes(string)) == null) {
            }
            if (byArray != null) {
                this.definePackage(string, sybClasspathPart);
                file = new File(sybClasspathPart.getClasspath());
                codeSource = new CodeSource(file.toURI().toURL(), (Certificate[])null);
                return this.defineClass(string, byArray, 0, byArray.length, codeSource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    protected URL findResource(String string) {
        SybClasspathPart sybClasspathPart = null;
        URL uRL = null;
        File file = null;
        try {
            Enumeration<SybClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements() && ((uRL = (sybClasspathPart = enumeration.nextElement()).getResource(string)) == null || uRL.getProtocol().equals("file") && !(file = new File(uRL.getFile())).exists())) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        Vector<URL> vector = new Vector<URL>(20);
        SybClasspathPart sybClasspathPart = null;
        URL uRL = null;
        try {
            Enumeration<SybClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements()) {
                sybClasspathPart = enumeration.nextElement();
                uRL = sybClasspathPart.getResource(string);
                if (uRL == null) continue;
                vector.add(uRL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector.elements();
    }

    private void definePackage(String string, SybClasspathPart sybClasspathPart) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        try {
            if (sybClasspathPart.type == 2) {
                this.definePackage(string2, sybClasspathPart.specTitle, sybClasspathPart.specVersion, sybClasspathPart.specVendor, sybClasspathPart.implTitle, sybClasspathPart.implVersion, sybClasspathPart.implVendor, new URL(JAR_STRING, BLANK_STRING, sybClasspathPart.classpath + JAR_SYNTAX_STRING));
            } else {
                this.definePackage(string2, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, BLANK_STRING, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void releaseResources() {
        SybClasspathPart sybClasspathPart = null;
        if (this._classpathParts != null) {
            Enumeration<SybClasspathPart> enumeration = this._classpathParts.elements();
            while (enumeration.hasMoreElements()) {
                sybClasspathPart = enumeration.nextElement();
                sybClasspathPart.releaseResources();
            }
            this._classpathParts.clear();
            this._classpathParts = null;
        }
        this._fullClasspath = null;
    }
}

