/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SybClasspathPart {
    private ZipFile _zipFile = null;
    Manifest manifest = null;
    int type;
    String classpath = "";
    String specTitle = "";
    String specVersion = "";
    String specVendor = "";
    String implTitle = "";
    String implVersion = "";
    String implVendor = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SybClasspathPart(String string) {
        FileInputStream fileInputStream = null;
        Attributes attributes = null;
        this.classpath = string;
        if (string.toLowerCase().endsWith(".jar")) {
            this.type = 2;
            try {
                fileInputStream = new FileInputStream(this.classpath);
                this.manifest = new Manifest(fileInputStream);
                attributes = this.manifest.getMainAttributes();
                if (attributes == null) return;
                this.specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                this.specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                this.specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                this.implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                this.implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                this.implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.type = 1;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public byte[] getClassBytes(String string) {
        if (this.type == 1) {
            return this.loadFromDirectory(string.replace('.', File.separatorChar) + ".class");
        }
        return this.loadFromArchive(string.replace('.', '/') + ".class");
    }

    public URL getResource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ZipEntry zipEntry = null;
        URL uRL = null;
        try {
            if (this.type == 1) {
                stringBuffer.append("file:").append(this.classpath).append(File.separator).append(string);
            } else if (this.type == 2) {
                try {
                    if (this._zipFile == null) {
                        this._zipFile = new ZipFile(this.classpath);
                    }
                    if ((zipEntry = this._zipFile.getEntry(string)) == null) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    return null;
                }
                stringBuffer.append("jar:").append("file:").append(this.classpath).append("!/").append(string);
            }
            uRL = new URL(stringBuffer.toString().replace('\\', '/'));
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        if (this.type == 1) {
            return this.getResourceStreamFromDirectory(string);
        }
        return this.getResourceStreamFromArchive(string);
    }

    private byte[] loadFromDirectory(String string) {
        int n = this.classpath.length();
        StringBuffer stringBuffer = new StringBuffer(string.length() + n + 20);
        File file = null;
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        if (n > 0) {
            stringBuffer.append(this.classpath);
            if (stringBuffer.charAt(n - 1) != File.separatorChar) {
                stringBuffer.append(File.separatorChar);
            }
        }
        stringBuffer.append(string);
        file = new File(stringBuffer.toString());
        if (file.exists() && file.isFile()) {
            try {
                fileInputStream = new FileInputStream(file);
                int n2 = (int)file.length();
                byArray = new byte[n2];
                ((InputStream)fileInputStream).read(byArray, 0, n2);
                ((InputStream)fileInputStream).close();
                return byArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private byte[] loadFromArchive(String string) {
        ZipEntry zipEntry = null;
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            if (this._zipFile == null) {
                this._zipFile = new ZipFile(this.classpath);
            }
            if ((zipEntry = this._zipFile.getEntry(string)) != null) {
                byArray = new byte[(int)zipEntry.getSize()];
                inputStream = this._zipFile.getInputStream(zipEntry);
                int n = 0;
                for (int i = 0; i < byArray.length && (n = inputStream.read(byArray, i, byArray.length - i)) >= 0; i += n) {
                }
                inputStream.close();
                return byArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private InputStream getResourceStreamFromDirectory(String string) {
        int n = this.classpath.length();
        StringBuffer stringBuffer = new StringBuffer(string.length() + n + 20);
        File file = null;
        FileInputStream fileInputStream = null;
        if (n > 0) {
            stringBuffer.append(this.classpath);
            if (stringBuffer.charAt(n - 1) != File.separatorChar) {
                stringBuffer.append(File.separatorChar);
            }
        }
        stringBuffer.append(string);
        file = new File(stringBuffer.toString());
        if (file.exists() && file.isFile()) {
            try {
                fileInputStream = new FileInputStream(file);
                return fileInputStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream getResourceStreamFromArchive(String string) {
        ZipEntry zipEntry = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            if (this._zipFile == null) {
                this._zipFile = new ZipFile(this.classpath);
            }
            if ((zipEntry = this._zipFile.getEntry(string)) != null) {
                byArray = new byte[(int)zipEntry.getSize()];
                inputStream = this._zipFile.getInputStream(zipEntry);
                return inputStream;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void releaseResources() {
        if (this._zipFile != null) {
            try {
                this._zipFile.close();
                this._zipFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.manifest = null;
    }
}

