/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import com.sybase.util.SybWindowsComboBoxUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class SybComboBox
extends JComboBox {
    private boolean _isPopupExpandable;
    private ComboBoxUI _originalComboBoxUI;

    public SybComboBox() {
    }

    public SybComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
    }

    public SybComboBox(Object[] objectArray) {
        super(objectArray);
    }

    public SybComboBox(Vector vector) {
        super(vector);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 5;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setPopupVisible(boolean bl) {
        if (bl && this.isEditable()) {
            String string = null;
            int n = -1;
            String string2 = null;
            Component component = this.getEditor().getEditorComponent();
            if (component instanceof JTextComponent && (string = ((JTextComponent)component).getText()) != null && string.length() != 0) {
                for (int i = 0; i < this.getItemCount(); ++i) {
                    string2 = this.getItemAt(i).toString();
                    if (!string2.equals(string)) continue;
                    n = i;
                    break;
                }
            }
            this.setSelectedIndex(n);
            if (n == -1 && string != null) {
                this.setSelectedItem(string);
            }
        }
        super.setPopupVisible(bl);
    }

    public boolean isPopupExpandable() {
        return this._isPopupExpandable;
    }

    public void setPopupExpandable(boolean bl) {
        this._setUI(this._isPopupExpandable, bl);
        this._isPopupExpandable = bl;
    }

    private void _setUI(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        if (bl2) {
            this._originalComboBoxUI = this.getUI();
            if (this._originalComboBoxUI instanceof WindowsComboBoxUI) {
                this.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
            } else {
                this.setUI(new CustomBasicComboBoxUI());
            }
        } else {
            this.setUI(this._originalComboBoxUI);
        }
    }

    private static class CustomBasicComboPopup
    extends BasicComboPopup {
        public CustomBasicComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            int n5 = this.comboBox.getItemCount();
            if (n5 == 0) {
                return super.computePopupBounds(n, n2, n3, n4);
            }
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            Insets insets = this.list.getInsets();
            JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                Object e = this.comboBox.getItemAt(i);
                Component component = listCellRenderer.getListCellRendererComponent(this.list, e, i, false, false);
                int n7 = component.getPreferredSize().width;
                n6 = Math.max(n7, n6);
            }
            if (insets != null) {
                n6 += insets.left + insets.right;
            }
            if (jScrollBar != null && n5 > this.comboBox.getMaximumRowCount()) {
                n6 += jScrollBar.getPreferredSize().width;
            }
            return super.computePopupBounds(n, n2, Math.max(n3, n6), n4);
        }
    }

    private static class CustomBasicComboBoxUI
    extends BasicComboBoxUI {
        private CustomBasicComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new CustomBasicComboPopup(this.comboBox);
        }
    }

    private static class CustomWindowsComboBoxUI
    extends SybWindowsComboBoxUI {
        private CustomWindowsComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new CustomBasicComboPopup(this.comboBox);
        }
    }
}

