/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DDBUI;
import com.sybase.util.DropDownButtonEvent;
import com.sybase.util.DropDownButtonListener;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybDropDownButtonModel;
import com.sybase.util.SybMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ButtonUI;

public class SybDropDownButton
extends SybButton {
    private EventListenerList _dropDownButtonListeners = new EventListenerList();

    public SybDropDownButton(Icon icon, Object[] objectArray) {
        this(icon, objectArray, null);
    }

    public SybDropDownButton(Icon icon, Object[] objectArray, Icon[] iconArray) {
        super(icon);
        this.init(objectArray, iconArray);
    }

    public SybDropDownButton(String string, Object[] objectArray) {
        this(string, objectArray, null);
    }

    public SybDropDownButton(String string, Object[] objectArray, Icon[] iconArray) {
        super(string);
        this.init(objectArray, iconArray);
    }

    public SybDropDownButton(String string, Icon icon, Object[] objectArray) {
        this(string, icon, objectArray, null);
    }

    public SybDropDownButton(String string, Icon icon, Object[] objectArray, Icon[] iconArray) {
        super(string, icon);
        this.init(objectArray, iconArray);
    }

    private void init(Object[] objectArray, Icon[] iconArray) {
        ButtonModel buttonModel = this.getModel();
        super.setModel(new SybDropDownButtonModel(buttonModel, objectArray, iconArray));
        new EventHelper();
        if (!Platform.isMacOS()) {
            ButtonUI buttonUI = this.getUI();
            super.setUI(new DDBUI(buttonUI, this));
        }
    }

    public void setListData(Object[] objectArray) {
        this.setListData(objectArray, null);
    }

    public void setListData(Object[] objectArray, Icon[] iconArray) {
        SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)this.getModel();
        sybDropDownButtonModel.setListData(objectArray, iconArray);
    }

    public Object getItem(int n) {
        SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)this.getModel();
        Object[] objectArray = sybDropDownButtonModel.getListData();
        if (n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException("index " + n + " is not in range (0," + objectArray.length + ")");
        }
        return objectArray[n];
    }

    public void addDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.add(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void removeDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.remove(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void showDropDown() {
        ((SybDropDownButtonModel)this.getModel()).fireDropDownEvent();
    }

    void fireDropDownItemClickedEvent(int n) {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent(this, n);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownItemClicked(dropDownButtonEvent);
        }
    }

    void fireDropDownOpeningEvent() {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent(this);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownOpening(dropDownButtonEvent);
        }
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() instanceof EmptyBorder) {
            return;
        }
        super.setBorder(border);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (Platform.isMacOS()) {
            dimension.width += 28;
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        if (Platform.isMacOS()) {
            return this.getPreferredSize();
        }
        return super.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (Platform.isMacOS()) {
            return this.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (Platform.isMacOS()) {
            super.paintComponent(graphics);
            DDBUI.static_paint(graphics, this);
        } else {
            super.paintComponent(graphics);
        }
    }

    class EventHelper
    implements ActionListener,
    MouseListener {
        private JPopupMenu _popup = null;
        private boolean _isMotifLAF;

        EventHelper() {
            String string = System.getProperty("swing.defaultlaf");
            if (string == null) {
                string = UIManager.getSystemLookAndFeelClassName();
            }
            this._isMotifLAF = string.indexOf("MotifLookAndFeel") != -1;
            this.installListeners();
        }

        void installListeners() {
            SybDropDownButton.this.addMouseListener(this);
            ((SybDropDownButtonModel)SybDropDownButton.this.getModel()).addDropDownListener(this);
            InputMap inputMap = SybDropDownButton.this.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(115, 0);
            inputMap.put(keyStroke, "togglePopup");
            keyStroke = KeyStroke.getKeyStroke(40, 0);
            inputMap.put(keyStroke, "openPopup");
            keyStroke = KeyStroke.getKeyStroke(225, 0);
            inputMap.put(keyStroke, "openPopup");
            ActionMap actionMap = SybDropDownButton.this.getActionMap();
            actionMap.put("togglePopup", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EventHelper.this.togglePopupMenu();
                }
            });
            actionMap.put("openPopup", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EventHelper.this.showPopupMenu((SybDropDownButtonModel)SybDropDownButton.this.getModel());
                }
            });
        }

        void uninstallListeners() {
            ((SybDropDownButtonModel)SybDropDownButton.this.getModel()).removeDropDownListener(this);
            SybDropDownButton.this.removeMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof SybDropDownButtonModel && ((SybDropDownButtonModel)object).isEnabled() && (actionEvent.getModifiers() & 0x100) != 0) {
                this.showPopupMenu((SybDropDownButtonModel)object);
            } else if (object instanceof SybMenuItem) {
                JPopupMenu jPopupMenu = (JPopupMenu)((SybMenuItem)object).getParent();
                Component[] componentArray = jPopupMenu.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] != object) continue;
                    SybDropDownButton.this.fireDropDownItemClickedEvent(i);
                    break;
                }
            }
        }

        private void togglePopupMenu() {
            if (this._popup == null) {
                this.showPopupMenu((SybDropDownButtonModel)SybDropDownButton.this.getModel());
            } else {
                this._popup.setVisible(false);
            }
        }

        private void showPopupMenu(SybDropDownButtonModel sybDropDownButtonModel) {
            if (this._popup != null) {
                return;
            }
            SybDropDownButton.this.fireDropDownOpeningEvent();
            Object[] objectArray = sybDropDownButtonModel.getListData();
            Icon[] iconArray = sybDropDownButtonModel.getIcons();
            boolean[] blArray = sybDropDownButtonModel.getEnabledStates();
            if (objectArray != null && objectArray.length != 0) {
                this._popup = new JPopupMenu();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = objectArray[i] != null ? objectArray[i].toString() : null;
                    if (string == null || string.length() == 0) {
                        this._popup.add(new JSeparator());
                        continue;
                    }
                    SybMenuItem sybMenuItem = new SybMenuItem(string);
                    if (iconArray != null && i < iconArray.length) {
                        ((AbstractButton)sybMenuItem).setIcon(iconArray[i]);
                    }
                    if (blArray != null && i < blArray.length) {
                        sybMenuItem.setEnabled(blArray[i]);
                    }
                    sybMenuItem.addActionListener(this);
                    this._popup.add(sybMenuItem);
                }
                this._popup.show(SybDropDownButton.this, 0, SybDropDownButton.this.getHeight());
                this._popup = null;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent, true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleMouseEvent(mouseEvent, false);
        }

        public void handleMouseEvent(MouseEvent mouseEvent, boolean bl) {
            SybDropDownButton sybDropDownButton;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.mousedOnDropDown(sybDropDownButton = (SybDropDownButton)mouseEvent.getSource(), mouseEvent)) {
                SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)sybDropDownButton.getModel();
                sybDropDownButtonModel.setDropDownPressed(bl);
            }
        }

        private boolean mousedOnDropDown(SybDropDownButton sybDropDownButton, MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            Insets insets = sybDropDownButton.getMargin();
            int n2 = sybDropDownButton.getInsets().right - insets.right;
            int n3 = this._isMotifLAF ? sybDropDownButton.getWidth() + 1 - n2 - 14 : sybDropDownButton.getWidth() - n2 - 14;
            return n > n3;
        }
    }
}

