/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class SybDropDownButtonModel
implements ButtonModel {
    static final int DROP_DOWN_MASK = 256;
    private ButtonModel _model;
    private boolean _dropDownPressed = false;
    private EventListenerList _dropDownListenerList = new EventListenerList();
    private Object[] _items = null;
    private Icon[] _icons = null;
    private boolean[] _enabledStates;

    SybDropDownButtonModel(ButtonModel buttonModel, Object[] objectArray) {
        this(buttonModel, objectArray, null);
    }

    SybDropDownButtonModel(ButtonModel buttonModel, Object[] objectArray, Icon[] iconArray) {
        this._model = buttonModel;
        if (objectArray != null) {
            this.setListData(objectArray, iconArray);
        }
    }

    void setListData(Object[] objectArray) {
        this.setListData(objectArray, null);
    }

    void setListData(Object[] objectArray, Icon[] iconArray) {
        if (objectArray != null) {
            this._items = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this._items, 0, objectArray.length);
        } else {
            this._items = null;
        }
        this._icons = iconArray;
    }

    Object[] getListData() {
        return this._items;
    }

    Icon[] getIcons() {
        return this._icons;
    }

    boolean[] getEnabledStates() {
        return this._enabledStates;
    }

    void setEnabledStates(boolean[] blArray) {
        if (blArray != null) {
            this._enabledStates = new boolean[blArray.length];
            System.arraycopy(blArray, 0, this._enabledStates, 0, blArray.length);
        } else {
            this._enabledStates = null;
        }
    }

    void addDropDownListener(ActionListener actionListener) {
        this._dropDownListenerList.add(ActionListener.class, actionListener);
    }

    void removeDropDownListener(ActionListener actionListener) {
        this._dropDownListenerList.remove(ActionListener.class, actionListener);
    }

    void fireDropDownEvent() {
        ActionEvent actionEvent = null;
        Object[] objectArray = this._dropDownListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._model.getActionCommand(), EventQueue.getMostRecentEventTime(), 256);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    void setDropDownPressed(boolean bl) {
        if (bl != this._dropDownPressed) {
            this._dropDownPressed = bl;
            if (!bl) {
                this.setArmed(false);
                this.fireDropDownEvent();
            }
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this._model.addActionListener(actionListener);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this._model.addChangeListener(changeListener);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this._model.addItemListener(itemListener);
    }

    @Override
    public String getActionCommand() {
        return this._model.getActionCommand();
    }

    @Override
    public int getMnemonic() {
        return this._model.getMnemonic();
    }

    @Override
    public boolean isArmed() {
        return this._model.isArmed();
    }

    @Override
    public boolean isEnabled() {
        return this._model.isEnabled();
    }

    @Override
    public boolean isPressed() {
        return this._model.isPressed();
    }

    @Override
    public boolean isRollover() {
        return this._model.isRollover();
    }

    @Override
    public boolean isSelected() {
        return this._model.isSelected();
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this._model.removeActionListener(actionListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this._model.removeChangeListener(changeListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this._model.removeItemListener(itemListener);
    }

    @Override
    public void setActionCommand(String string) {
        this._model.setActionCommand(string);
    }

    @Override
    public void setArmed(boolean bl) {
        this._model.setArmed(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._model.setEnabled(bl);
    }

    @Override
    public void setGroup(ButtonGroup buttonGroup) {
        this._model.setGroup(buttonGroup);
    }

    @Override
    public void setMnemonic(int n) {
        this._model.setMnemonic(n);
    }

    @Override
    public void setPressed(boolean bl) {
        this._model.setPressed(bl);
    }

    @Override
    public void setRollover(boolean bl) {
        this._model.setRollover(bl);
    }

    @Override
    public void setSelected(boolean bl) {
        this._model.setSelected(bl);
    }

    @Override
    public Object[] getSelectedObjects() {
        return this._model.getSelectedObjects();
    }
}

