/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DLLLoader;
import com.sybase.util.Platform;
import com.sybase.util.SwingFileFilter;
import com.sybase.util.SybFileChooserResources;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybFolderChooser;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybOptionPane;
import com.sybase.util.win32.FileDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class SybFileChooser {
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    private static final int OPEN_SAVE_MASK = 3;
    public static final int FILES = 16;
    public static final int FOLDERS = 32;
    public static final int FILES_AND_FOLDERS = 48;
    private static final int FILES_AND_FOLDERS_MASK = 48;
    public static final int NO_OVERWRITE_PROMPT = 256;
    public static final int MULTIPLE_SELECTION = 512;
    protected static final int AWT_TYPE = 0;
    protected static final int SWING_TYPE = 1;
    protected static final int WINDOWS_FILE_TYPE = 2;
    protected int _type = 1;
    protected int _flags;
    protected SybFileFilter[] _filters = null;
    protected SybFileFilter _initialFilter = null;
    protected int _initialFilterIndex = -1;
    protected SybFileFilter _selectedFilter = null;
    protected File[] _selectedFiles = null;
    protected String _title = null;
    protected String _approveButtonText = null;
    protected int _approveButtonMnemonic = -1;
    protected String _approveButtonToolTipText = null;
    protected ArrayList _listenerList = new ArrayList();
    protected boolean _done;
    protected String _defaultExtension = null;
    protected String _directoryBrowserText = null;

    public SybFileChooser(int n) {
        this._flags = n;
        this._type = Platform.isMacOS() ? 0 : (Platform.isWindows() ? (DLLLoader.isInstalled() && (n & 0x30) != 48 ? 2 : 1) : 1);
    }

    public void setApproveButtonText(String string) {
        this._approveButtonText = string;
    }

    public String getApproveButtonText() {
        return this._approveButtonText;
    }

    public void setApproveButtonMnemonic(int n) {
        this._approveButtonMnemonic = n;
    }

    public int getApproveButtonMnemonic() {
        return this._approveButtonMnemonic;
    }

    public void setApproveButtonToolTipText(String string) {
        this._approveButtonToolTipText = string;
    }

    public String getApproveButtonToolTipText() {
        return this._approveButtonToolTipText;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public void setDefaultExtension(String string) {
        this._defaultExtension = string.length() <= 3 ? string : string.substring(0, 3);
    }

    public String getDefaultExtension() {
        return this._defaultExtension;
    }

    public void setDirectoryBrowserText(String string) {
        this._directoryBrowserText = string;
    }

    public String getDirectoryBrowserText() {
        return this._directoryBrowserText;
    }

    public void setFilters(SybFileFilter[] sybFileFilterArray, int n) {
        if (n < 0 || n >= sybFileFilterArray.length) {
            throw new IllegalArgumentException("Initial filter must be betwen 0 and " + (sybFileFilterArray.length - 1));
        }
        this._filters = sybFileFilterArray;
        this._initialFilter = sybFileFilterArray[n];
        this._initialFilterIndex = n;
    }

    public SybFileFilter[] getFilters() {
        return this._filters;
    }

    public File[] getSelectedFiles() {
        return this._selectedFiles;
    }

    public File getSelectedFile() {
        File file = this._selectedFiles == null ? null : this._selectedFiles[0];
        return file;
    }

    public boolean showDialog(Window window, File file, File file2) {
        boolean bl = false;
        this._selectedFiles = null;
        if (file2 != null) {
            if (file2.isDirectory()) {
                file = file2;
                file2 = null;
            } else {
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    file = file3;
                    file2 = new File(file2.getName());
                }
            }
        }
        if (this._filters == null) {
            this.setFilters(new SybFileFilter[]{SybFileFilter.getAllFilesFilter()}, 0);
            if (this._defaultExtension == null) {
                this._defaultExtension = "";
            }
            bl = true;
        }
        switch (this._type) {
            case 0: {
                if ((this._flags & 0x30) == 16) {
                    this.showAWTDialog(window, file, file2);
                    break;
                }
                if ((this._flags & 0x30) == 32) {
                    this.showFolderDialog(window, file);
                    break;
                }
                this.showSwingDialog(window, file, file2);
                break;
            }
            case 1: {
                if ((this._flags & 0x30) == 32) {
                    this.showFolderDialog(window, file);
                    break;
                }
                this.showSwingDialog(window, file, file2);
                break;
            }
            case 2: {
                if ((this._flags & 0x30) == 48) {
                    this.showSwingDialog(window, file, file2);
                    break;
                }
                this.showNativeDialog(window, file, file2);
            }
        }
        if (bl) {
            this._filters = null;
            this._initialFilter = null;
            this._initialFilterIndex = -1;
        }
        return this._selectedFiles != null;
    }

    private void showNativeDialog(Window window, File file, File file2) {
        SybFileFilter sybFileFilter;
        int n;
        FileDlg.PB pB = new FileDlg.PB();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this._filters.length; ++n) {
            stringBuffer.append(this._filters[n].getDisplayText());
            stringBuffer.append('\u0000');
            String[] stringArray = this._filters[n].getExtensions();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append("*.");
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append('\u0000');
        }
        stringBuffer.append('\u0000');
        String string = file2 == null ? null : file2.toString();
        if (file == null || !file.exists()) {
            file = new File(System.getProperty("user.dir"));
        }
        String string2 = file == null ? null : file.toString();
        int n2 = 4;
        if ((this._flags & 3) == 1) {
            n2 |= 0x1800;
            if ((this._flags & 0x200) != 0) {
                n2 |= 0x200;
            }
        }
        if ((this._flags & 3) == 2 && (this._flags & 0x100) == 0) {
            n2 |= 2;
        }
        pB.title = this._title;
        pB.filter = stringBuffer.toString();
        pB.initialFilterIndex = this._initialFilterIndex + 1;
        pB.initialFileName = string;
        pB.initialDirectory = string2;
        pB.options = n2;
        pB.fileNames = null;
        pB.directoryBrowserText = this._directoryBrowserText;
        if (this._defaultExtension != null) {
            pB.defaultExtension = this._defaultExtension;
        } else if (this._filters.length > 0 && this._filters[this._initialFilterIndex] != (sybFileFilter = SybFileFilter.getAllFilesFilter())) {
            pB.defaultExtension = this._filters[this._initialFilterIndex].getExtensions()[0];
        }
        String string3 = this._approveButtonText;
        if (string3 != null && string3.length() != 0) {
            int n3;
            if (this._approveButtonMnemonic != -1 && (n3 = string3.indexOf(this._approveButtonMnemonic)) != -1) {
                string3 = string3.substring(0, n3) + "&" + string3.substring(n3);
            }
            pB.buttonText = string3;
            if ((this._flags & 3) == 2) {
                this._flags = this._flags & 0xFFFFFFFD | 1;
                if (pB.title == null) {
                    pB.title = SybFileChooserResources.getBundle().get("SaveTitle");
                }
                pB.options |= 2;
            }
        }
        this._done = false;
        UnpaintedDialog unpaintedDialog = new UnpaintedDialog(window, pB);
        unpaintedDialog.setVisible(true);
        if (pB.fileNames != null && pB.fileNames.length > 0) {
            this._selectedFiles = new File[pB.fileNames.length];
            for (n = 0; n < pB.fileNames.length; ++n) {
                this._selectedFiles[n] = new File(pB.fileNames[n]);
            }
            this._selectedFilter = pB.filterIndex >= 1 && pB.filterIndex <= this._filters.length ? this._filters[pB.filterIndex - 1] : null;
        }
    }

    private void showSwingDialog(Window window, File file, File file2) {
        int n;
        int n2;
        MyJFileChooser myJFileChooser = new MyJFileChooser();
        if (file == null || !file.exists()) {
            String string = System.getProperty("user.dir");
            file = string != null ? new File(string) : null;
        }
        if (file != null) {
            myJFileChooser.setCurrentDirectory(file);
        }
        if (file2 != null) {
            myJFileChooser.setSelectedFile(file2);
            myJFileChooser.ensureFileIsVisible(file2);
        }
        if (this._title != null) {
            myJFileChooser.setDialogTitle(this._title);
        }
        if ((this._flags & 0x30) == 16) {
            myJFileChooser.setFileSelectionMode(0);
        } else if ((this._flags & 0x30) == 32) {
            myJFileChooser.setFileSelectionMode(1);
        } else if ((this._flags & 0x30) == 48) {
            myJFileChooser.setFileSelectionMode(2);
        }
        if ((this._flags & 0x100) == 0) {
            myJFileChooser.setMultiSelectionEnabled(true);
        }
        if (this._approveButtonText != null) {
            myJFileChooser.setApproveButtonText(this._approveButtonText);
            myJFileChooser.setApproveButtonMnemonic(this._approveButtonMnemonic);
            myJFileChooser.setApproveButtonToolTipText(this._approveButtonToolTipText);
        }
        myJFileChooser.resetChoosableFileFilters();
        myJFileChooser.setAcceptAllFileFilterUsed(false);
        SwingFileFilter[] swingFileFilterArray = new SwingFileFilter[this._filters.length];
        int n3 = -1;
        for (n2 = 0; n2 < this._filters.length; ++n2) {
            swingFileFilterArray[n2] = new SwingFileFilter(this._filters[n2]);
            myJFileChooser.addChoosableFileFilter(swingFileFilterArray[n2]);
            if (this._initialFilter != this._filters[n2]) continue;
            n3 = n2;
        }
        if (n3 != -1) {
            myJFileChooser.setFileFilter(swingFileFilterArray[n3]);
        }
        if ((n = (this._flags & 2) == 2 ? myJFileChooser.showSaveDialog(window) : myJFileChooser.showOpenDialog(window)) == 0) {
            this._selectedFiles = myJFileChooser.sybGetSelectedFilesArray();
            FileFilter fileFilter = myJFileChooser.getFileFilter();
            this._selectedFilter = fileFilter == null ? null : (fileFilter instanceof SwingFileFilter ? ((SwingFileFilter)fileFilter).getSybFileFilter() : null);
            if (this._selectedFilter != null) {
                String[] stringArray = this._selectedFilter.getExtensions();
                String string = null;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2].indexOf(63) != -1 || stringArray[n2].indexOf(42) != -1) continue;
                    string = stringArray[n2];
                    break;
                }
                if (string != null) {
                    for (n2 = 0; n2 < this._selectedFiles.length; ++n2) {
                        if (this._selectedFiles[n2].getName().indexOf(".") >= 0 || this._selectedFilter.accept(this._selectedFiles[n2])) continue;
                        this._selectedFiles[n2] = new File(this._selectedFiles[n2].toString() + "." + string);
                    }
                } else if (this._defaultExtension != null && this._defaultExtension.length() != 0) {
                    string = "." + this._defaultExtension;
                    for (n2 = 0; n2 < this._selectedFiles.length; ++n2) {
                        String string2 = this._selectedFiles[n2].getName();
                        if (string2.endsWith(".")) continue;
                        boolean bl = true;
                        if (string2.length() > string.length()) {
                            boolean bl2 = bl = !string2.regionMatches(true, string2.length() - string.length(), string, 0, string.length());
                        }
                        if (!bl) continue;
                        this._selectedFiles[n2] = new File(this._selectedFiles[n2].toString() + string);
                    }
                }
            }
        } else {
            this._selectedFiles = null;
            this._selectedFilter = null;
        }
    }

    private void showAWTDialog(Window window, File file, File file2) {
        String string;
        Frame frame = window instanceof Frame ? (Frame)window : new Frame();
        String string2 = this._title;
        if (this._title == null) {
            string2 = (this._flags & 3) == 1 ? SybFileChooserResources.getBundle().get("OpenTitle") : SybFileChooserResources.getBundle().get("SaveTitle");
        }
        FileDialog fileDialog = new FileDialog(frame, string2);
        if ((this._flags & 2) == 2) {
            fileDialog.setMode(1);
        } else {
            fileDialog.setMode(0);
        }
        if (file == null && (string = System.getProperty("user.dir")) != null) {
            file = new File(string);
        }
        if (file != null) {
            fileDialog.setDirectory(file.toString());
        }
        if (file2 != null) {
            fileDialog.setFile(file2.toString());
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                boolean bl = false;
                File file2 = new File(file, string);
                for (int i = 0; i < SybFileChooser.this._filters.length; ++i) {
                    if (!SybFileChooser.this._filters[i].accept(file2)) continue;
                    bl = true;
                    break;
                }
                return bl;
            }
        };
        fileDialog.setFilenameFilter(filenameFilter);
        this._selectedFilter = null;
        boolean bl = false;
        while (!bl) {
            fileDialog.setVisible(true);
            string = fileDialog.getFile();
            if (string != null) {
                int n;
                String string3;
                if (string.indexOf(File.separatorChar) >= 0 || string.indexOf(File.pathSeparatorChar) >= 0) {
                    string3 = SybFileChooserResources.getBundle().getFormatted("IllegalCharacterInFileName", File.separator, File.pathSeparator);
                    SybOptionPane.showMessageDialog(frame, string3, string2, 0);
                    continue;
                }
                if ((this._flags & 3) == 2 && this._defaultExtension != null && string.indexOf(".") == -1) {
                    string = string + "." + this._defaultExtension;
                }
                File file3 = new File(fileDialog.getDirectory(), string);
                if ((this._flags & 3) == 1) {
                    if (!file3.exists()) {
                        string3 = SybFileChooserResources.getBundle().getFormatted("FileNotFound", file3.getName());
                        SybOptionPane.showMessageDialog(frame, string3, string2, 0);
                        continue;
                    }
                } else if (!Platform.isWindows() && file3.exists() && (this._flags & 0x100) == 0 && (n = SybOptionPane.showConfirmDialog(frame, string3 = SybFileChooserResources.getBundle().getFormatted("OverwritePrompt", file3.getName()), string2, 0)) == 1) continue;
                this._selectedFiles = new File[]{file3};
                for (int i = 0; i < this._filters.length; ++i) {
                    if (!this._filters[i].accept(file3)) continue;
                    this._selectedFilter = this._filters[i];
                    break;
                }
            }
            bl = true;
        }
    }

    public SybFileFilter getSelectedFilter() {
        return this._selectedFilter;
    }

    private void showFolderDialog(Window window, File file) {
        SybFolderChooser sybFolderChooser = window instanceof Dialog ? new SybFolderChooser((Dialog)window) : new SybFolderChooser((Frame)window);
        File file2 = sybFolderChooser.open(this._title, null, file);
        if (file2 != null) {
            this._selectedFiles = new File[]{file2};
        }
        sybFolderChooser.destroy();
    }

    class MyJFileChooser
    extends JFileChooser {
        MyJFileChooser() {
        }

        File[] sybGetSelectedFilesArray() {
            File[] fileArray = this.isMultiSelectionEnabled() ? super.getSelectedFiles() : new File[]{super.getSelectedFile()};
            return fileArray;
        }

        @Override
        public void approveSelection() {
            File file;
            int n;
            File[] fileArray = this.sybGetSelectedFilesArray();
            if ((SybFileChooser.this._flags & 3) == 1) {
                for (n = 0; n < fileArray.length; ++n) {
                    file = fileArray[n];
                    if (file.exists()) continue;
                    String string = this.getDialogTitle();
                    if (string == null) {
                        string = this.getUI().getDialogTitle(this);
                    }
                    String string2 = SybFileChooserResources.getBundle().getFormatted("FileNotFound", file.getName());
                    SybOptionPane.showMessageDialog(this, string2, string, 0);
                    return;
                }
            }
            if ((SybFileChooser.this._flags & 3) == 2 && (SybFileChooser.this._flags & 0x100) == 0) {
                for (n = 0; n < fileArray.length; ++n) {
                    String string;
                    int n2;
                    file = fileArray[n];
                    if (!file.exists()) continue;
                    String string3 = this.getDialogTitle();
                    if (string3 == null) {
                        string3 = this.getUI().getDialogTitle(this);
                    }
                    if ((n2 = SybOptionPane.showConfirmDialog(this, string = SybFileChooserResources.getBundle().getFormatted("OverwritePrompt", file.getName()), string3, 0)) != 1) continue;
                    return;
                }
            }
            super.approveSelection();
        }

        @Override
        public String getApproveButtonText() {
            String string = SybFileChooser.this != null && SybFileChooser.this.getApproveButtonText() != null ? SybFileChooser.this.getApproveButtonText() : super.getApproveButtonText();
            return string;
        }

        @Override
        public int getApproveButtonMnemonic() {
            int n = SybFileChooser.this != null ? SybFileChooser.this.getApproveButtonMnemonic() : super.getApproveButtonMnemonic();
            return n;
        }

        @Override
        protected JDialog createDialog(Component component) throws HeadlessException {
            boolean bl;
            String string = this.getUI().getDialogTitle(this);
            this.getAccessibleContext().setAccessibleDescription(string);
            Window window = SybOptionPane.getWindowForComponent(component);
            SybModalDialog sybModalDialog = window instanceof Frame ? new SybModalDialog((Frame)window, string) : new SybModalDialog((Dialog)window, string);
            sybModalDialog.setComponentOrientation(this.getComponentOrientation());
            Container container = sybModalDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                sybModalDialog.getRootPane().setWindowDecorationStyle(6);
            }
            sybModalDialog.pack();
            sybModalDialog.setLocationRelativeTo(component);
            return sybModalDialog;
        }
    }

    private class UnpaintedDialog
    extends JDialog
    implements WindowListener {
        private FileDlg.PB _pb;

        UnpaintedDialog(Window window, FileDlg.PB pB) {
            super(window, Dialog.ModalityType.DOCUMENT_MODAL);
            this._pb = pB;
            this.setUndecorated(true);
            this.addWindowListener(this);
            try {
                Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                Method method = clazz.getDeclaredMethod("setWindowOpaque", Window.class, Boolean.TYPE);
                method.invoke(null, this, false);
                if (window != null) {
                    this.setBounds(window.getBounds());
                }
            }
            catch (Exception exception) {
                if (window != null) {
                    Rectangle rectangle = window.getBounds();
                    rectangle.height = 0;
                    this.setBounds(rectangle);
                }
                this.setBounds(0, 0, 0, 0);
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            this.removeWindowListener(this);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if ((SybFileChooser.this._flags & 0x30) == 32) {
                        FileDlg.browseForDirectory(UnpaintedDialog.this._pb);
                    } else if ((SybFileChooser.this._flags & 3) == 2) {
                        FileDlg.getSaveFileName(UnpaintedDialog.this._pb);
                    } else {
                        FileDlg.getOpenFileName(UnpaintedDialog.this._pb);
                    }
                    UnpaintedDialog.this._pb = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UnpaintedDialog.this.setVisible(false);
                        }
                    });
                }
            });
            thread.start();
        }
    }
}

