/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SwingToSybFilterAdapter;
import java.io.File;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class SybFileFilter {
    private static SybFileFilter _allFilesFilter = null;
    private Object _userData;
    private String[] _extensions;
    private String _description;
    private String _displayText;

    public SybFileFilter(String string, String string2) {
        this(new String[]{string}, string2, null);
    }

    public SybFileFilter(String string, String string2, Object object) {
        this(new String[]{string}, string2, object);
    }

    public SybFileFilter(String[] stringArray, String string) {
        this(stringArray, string, null);
    }

    public SybFileFilter(String[] stringArray, String string, Object object) {
        this._extensions = stringArray;
        this._userData = object;
        this._description = string;
        StringBuffer stringBuffer = new StringBuffer(64);
        if (string != null) {
            stringBuffer.append(string);
            if (stringArray != null) {
                stringBuffer.append(" (");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(File.pathSeparator);
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("*.");
                    stringBuffer.append(stringArray[i]);
                }
                stringBuffer.append(")");
            }
        }
        this._displayText = stringBuffer.toString();
    }

    public static SybFileFilter createSybFilterFromSwingFilter(FileFilter fileFilter) {
        if (fileFilter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        return new SwingToSybFilterAdapter(fileFilter);
    }

    public static SybFileFilter getAllFilesFilter() {
        if (_allFilesFilter == null) {
            _allFilesFilter = new SybFileFilter("*", UIManager.getString("FileChooser.acceptAllFileFilterText"), null);
        }
        return _allFilesFilter;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public String[] getExtensions() {
        return this._extensions;
    }

    public boolean accept(File file) {
        String string = file.toString();
        boolean bl = false;
        for (int i = 0; i < this._extensions.length; ++i) {
            String string2 = this._extensions[i];
            if (string2.equals("*")) {
                bl = true;
                break;
            }
            if (string.length() <= string2.length() + 1 || !string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length()) || string.charAt(string.length() - string2.length() - 1) != '.') continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Object getUserData() {
        return this._userData;
    }

    public void setUserData(Object object) {
        this._userData = object;
    }
}

