/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EventMonitor;
import com.sybase.util.Platform;
import com.sybase.util.SybFocusTraversalPolicy;
import com.sybase.util.UITraceDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

class SybFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    private static boolean _installed = false;
    private static KeyEventDispatcher _keyEventDispatcher = null;

    static void install() {
        if (!_installed) {
            _installed = true;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (Platform.isWindows()) {
                FocusTraversalPolicy focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
                SybFocusTraversalPolicy sybFocusTraversalPolicy = new SybFocusTraversalPolicy(focusTraversalPolicy);
                keyboardFocusManager.setDefaultFocusTraversalPolicy(sybFocusTraversalPolicy);
            }
            _keyEventDispatcher = new SybFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(_keyEventDispatcher);
            keyboardFocusManager.addKeyEventPostProcessor((KeyEventPostProcessor)((Object)_keyEventDispatcher));
        }
    }

    static void uninstall() {
        if (_installed) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removeKeyEventPostProcessor((KeyEventPostProcessor)((Object)_keyEventDispatcher));
            keyboardFocusManager.removeKeyEventDispatcher(_keyEventDispatcher);
            _keyEventDispatcher = null;
            _installed = false;
        }
    }

    private SybFocusManager() {
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        int n = keyEvent.getKeyCode();
        if (Platform.isWindows() && n == 18 && keyEvent.getID() == 402) {
            keyEvent.consume();
            return true;
        }
        if (n != 18 && n != 65535 && keyEvent.getModifiers() == 8 && keyEvent.getID() == 401 && this.handleMnemonic(keyEvent)) {
            keyEvent.consume();
            return true;
        }
        if (n == 192 && keyEvent.isShiftDown() && keyEvent.isControlDown() && keyEvent.getID() == 401) {
            EventMonitor.pause();
            UITraceDialog.showDialog();
            EventMonitor.resume();
        }
        if (!(n != 9 && keyEvent.getKeyChar() != '\t' || keyEvent.isControlDown() || keyEvent.isAltDown() || SwingUtilities.getAncestorOfClass(JTabbedPane.class, component) == null)) {
            Dialog dialog;
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return true;
            }
            JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component);
            if (jTable != null && jTable.isEditing()) {
                return false;
            }
            if (component instanceof JEditorPane && (dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component)) == null) {
                return false;
            }
            this.moveFocus(component, keyEvent);
            keyEvent.consume();
            return true;
        }
        if (keyEvent.isControlDown() && (n == 9 || keyEvent.getKeyChar() == '\t' || n == 33 || n == 34)) {
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return true;
            }
            Container container = component instanceof JTabbedPane ? (Container)component : SwingUtilities.getAncestorOfClass(JTabbedPane.class, component);
            if (container != null) {
                if (this.selectTab(component, keyEvent.isShiftDown() || n == 33)) {
                    keyEvent.consume();
                    return true;
                }
            } else {
                this.moveFocus(component, keyEvent);
                keyEvent.consume();
                return true;
            }
        }
        if (keyEvent.isShiftDown() && !keyEvent.isControlDown() && !keyEvent.isAltDown() && keyEvent.getKeyCode() == 121 && !(component instanceof JRootPane) && component.isShowing() && this.openContextMenu(component, keyEvent)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    private boolean handleMnemonic(KeyEvent keyEvent) {
        Component component = null;
        JRootPane jRootPane = null;
        boolean bl = false;
        ArrayList<Component> arrayList = new ArrayList<Component>(5);
        Object var7_6 = null;
        char c = keyEvent.getKeyChar();
        component = keyEvent.getComponent();
        jRootPane = SwingUtilities.getRootPane(component);
        if (jRootPane != null) {
            bl = this.getListOfComponentsWithMnemonic(arrayList, jRootPane, c);
            if (arrayList.size() > 1) {
                if (bl) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (arrayList.get(i) != component) continue;
                        if (i == arrayList.size() - 1) {
                            arrayList.get(0).requestFocusInWindow();
                            continue;
                        }
                        arrayList.get(i + 1).requestFocusInWindow();
                    }
                } else {
                    arrayList.get(0).requestFocusInWindow();
                }
                return true;
            }
        }
        return false;
    }

    private boolean getListOfComponentsWithMnemonic(ArrayList<Component> arrayList, Container container, char c) {
        boolean bl = false;
        Component[] componentArray = null;
        AbstractButton abstractButton = null;
        JLabel jLabel = null;
        Object var8_8 = null;
        componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isShowing() || !componentArray[i].isEnabled() || componentArray[i] instanceof JMenu) continue;
            if (componentArray[i] instanceof AbstractButton) {
                abstractButton = (AbstractButton)componentArray[i];
                if (Character.toUpperCase(abstractButton.getMnemonic()) != Character.toUpperCase((int)c)) continue;
                arrayList.add(abstractButton);
                if (bl) continue;
                bl = abstractButton.isFocusOwner();
                continue;
            }
            if (componentArray[i] instanceof JLabel) {
                jLabel = (JLabel)componentArray[i];
                if (Character.toUpperCase(jLabel.getDisplayedMnemonic()) != Character.toUpperCase((int)c) || jLabel.getLabelFor() == null) continue;
                arrayList.add(jLabel.getLabelFor());
                if (bl) continue;
                bl = jLabel.getLabelFor().isFocusOwner();
                continue;
            }
            if (!(componentArray[i] instanceof Container)) continue;
            if (!bl) {
                bl = this.getListOfComponentsWithMnemonic(arrayList, (Container)componentArray[i], c);
                continue;
            }
            this.getListOfComponentsWithMnemonic(arrayList, (Container)componentArray[i], c);
        }
        return bl;
    }

    private boolean selectTab(Component component, boolean bl) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                component = container.getComponent(i);
                if (!(component instanceof JTabbedPane)) continue;
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                i = jTabbedPane.getSelectedIndex();
                n = jTabbedPane.getTabCount();
                if (bl) {
                    if ((i = (i - 1) % n) < 0) {
                        i += n;
                    }
                } else {
                    i = (i + 1) % n;
                }
                jTabbedPane.setSelectedIndex(i);
                final Component component2 = jTabbedPane.getComponentAt(i);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SybFocusManager.this.setFocusToFirstChild(component2);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private void setFocusToFirstChild(Component component) {
        FocusTraversalPolicy focusTraversalPolicy;
        Component component2;
        Component component3 = null;
        Container container = component.getFocusCycleRootAncestor();
        if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, component)) != null) {
            Component component4 = focusTraversalPolicy.getComponentBefore(container, component2);
            component3 = component4 == component ? component : component2;
        }
        if (component3 != null) {
            component3.requestFocus();
        }
    }

    private boolean openContextMenu(Component component, KeyEvent keyEvent) {
        boolean bl = false;
        MouseListener[] mouseListenerArray = (MouseListener[])component.getListeners(MouseListener.class);
        if (mouseListenerArray != null) {
            InputEvent inputEvent = null;
            int n = mouseListenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (inputEvent == null) {
                    Point point = this.getMousePoint(component);
                    inputEvent = new MouseEvent(component, 502, keyEvent.getWhen(), 4, point.x, point.y, 1, true);
                }
                mouseListenerArray[i].mouseReleased((MouseEvent)inputEvent);
                if (!inputEvent.isConsumed()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Point getMousePoint(Component component) {
        int n;
        int n2;
        if (component instanceof JTable) {
            int n3;
            int n4 = ((JTable)component).getSelectedRow();
            if (n4 == -1) {
                n4 = 0;
            }
            if ((n3 = ((JTable)component).getSelectedColumn()) == -1) {
                n3 = 0;
            }
            Rectangle rectangle = ((JTable)component).getCellRect(n4, n3, true);
            n2 = rectangle.x;
            n = rectangle.y;
        } else if (component instanceof JTree) {
            TreePath treePath = ((JTree)component).getSelectionPath();
            if (treePath != null) {
                Rectangle rectangle = ((JTree)component).getPathBounds(treePath);
                n2 = rectangle.x;
                n = rectangle.y;
            } else {
                n2 = 0;
                n = 0;
            }
        } else if (component instanceof JList) {
            int n5 = ((JList)component).getSelectedIndex();
            if (n5 != -1) {
                Rectangle rectangle = ((JList)component).getCellBounds(n5, n5);
                n2 = rectangle.x;
                n = rectangle.y;
            } else {
                n2 = 0;
                n = 0;
            }
        } else if (component instanceof JTextComponent) {
            int n6 = ((JTextComponent)component).getCaretPosition();
            try {
                Rectangle rectangle = ((JTextComponent)component).modelToView(n6);
                n2 = rectangle.x;
                n = rectangle.y;
            }
            catch (BadLocationException badLocationException) {
                n2 = 0;
                n = 0;
            }
        } else {
            if (component.getParent() instanceof JViewport) {
                return ((JViewport)component.getParent()).getViewPosition();
            }
            n2 = 0;
            n = 0;
        }
        return new Point(n2, n);
    }

    private void moveFocus(Component component, KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            component.transferFocusBackward();
        } else {
            component.transferFocus();
        }
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        int n = keyEvent.getKeyLocation();
        if (n != 4) {
            Component component;
            int n2 = keyEvent.getKeyCode();
            int n3 = keyEvent.getModifiers();
            int n4 = 512;
            int n5 = 8384;
            if ((n2 == 9 || (n3 & (n4 | n5)) == n4) && (component = keyEvent.getComponent()) instanceof JTextComponent && !(component instanceof JEditorPane)) {
                ((JTextComponent)component).selectAll();
            }
        }
        return bl;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

