/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DialogUtils;
import com.sybase.util.FolderCellRenderer;
import com.sybase.util.FoldersTreeModel;
import com.sybase.util.MyNode;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooserResources;
import com.sybase.util.SybFileChooserResourcesBase;
import com.sybase.util.SybModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

class SybFolderChooser
extends SybModalDialog
implements ActionListener,
ComponentListener {
    private static Dimension _initialDialogSize = null;
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private JLabel _text = null;
    private JTree _tree = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private File _selectedFile = null;
    private SybFileChooserResourcesBase _res = null;
    private Dimension _minimumSize = null;

    public SybFolderChooser(Dialog dialog) {
        super(dialog);
        this.init(dialog);
    }

    public SybFolderChooser(Frame frame) {
        super(frame);
        this.init(frame);
    }

    private void init(Window window) {
        this._res = SybFileChooserResources.getBundle();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        this._text = new JLabel("");
        jPanel.add((Component)this._text, "North");
        this._tree = new JTree(new FoldersTreeModel());
        this._tree.setVisibleRowCount(12);
        this._tree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._tree.setCellRenderer(new FolderCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._tree);
        jPanel.add((Component)jScrollPane, "Center");
        this._ok = new SybButton(this._res.get("OK"));
        this._cancel = new SybButton(this._res.get("Cancel"));
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._cancel);
        jPanel.add((Component)jPanel2, "South");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(window);
        this.addComponentListener(this);
        if (_initialDialogSize != null) {
            this.setSize(_initialDialogSize);
        }
        this.getRootPane().setDefaultButton(this._ok);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
    }

    public File open(String string, String string2, File file) {
        if (string == null) {
            string = this._res.get("DefaultFolderChooserTitle");
        }
        this.setTitle(string);
        if (string2 != null) {
            this._text.setText(string2);
        }
        if (file != null && file.exists() && file.isDirectory()) {
            this.selectInitialFolder(file);
        } else {
            this.selectRootNode();
        }
        this._selectedFile = null;
        this.setVisible(true);
        return this._selectedFile;
    }

    private void selectRootNode() {
        FoldersTreeModel foldersTreeModel = (FoldersTreeModel)this._tree.getModel();
        MyNode myNode = (MyNode)foldersTreeModel.getRoot();
        if (myNode != null) {
            this.selectNode(myNode);
        }
    }

    private void selectInitialFolder(File file) {
        FoldersTreeModel foldersTreeModel = (FoldersTreeModel)this._tree.getModel();
        MyNode myNode = foldersTreeModel.findNode(file);
        if (myNode != null) {
            this.selectNode(myNode);
        }
    }

    private void selectNode(MyNode myNode) {
        Object[] objectArray = myNode.getPath();
        TreePath treePath = new TreePath(objectArray);
        this._tree.scrollPathToVisible(treePath);
        this._tree.setSelectionPath(treePath);
    }

    public void destroy() {
        this._text = null;
        this._tree = null;
        if (this._ok != null) {
            this._ok.removeActionListener(this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener(this);
            this._cancel = null;
        }
        this._selectedFile = null;
        this._res = null;
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        DialogUtils.removeComponents(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.handleCancel();
            }
        }
    }

    private void handleOK() {
        Object object;
        Object var3_1 = null;
        _initialDialogSize = this.getSize();
        this.setVisible(false);
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof MyNode) {
            this._selectedFile = ((MyNode)object).getFile();
        }
    }

    private void handleCancel() {
        this.setVisible(false);
        this._selectedFile = null;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this._minimumSize == null) {
            this._minimumSize = this.getSize();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this._minimumSize != null) {
            Dimension dimension = this.getSize();
            boolean bl = false;
            if (dimension.width < this._minimumSize.width) {
                bl = true;
                dimension.width = this._minimumSize.width;
            }
            if (dimension.height < this._minimumSize.height) {
                bl = true;
                dimension.height = this._minimumSize.height;
            }
            if (bl) {
                this.setSize(dimension);
            }
        }
    }
}

