/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybFontChooserResourcesBase;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SybFontChooser
extends SybModalDialog
implements ActionListener,
ListSelectionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String FONT_LIST_UP_KEY_COMMAND = "PrevFontName";
    private static final String FONT_LIST_DOWN_KEY_COMMAND = "NextFontName";
    private static final String FONT_LIST_PAGE_UP_KEY_COMMAND = "FontNamePageUp";
    private static final String FONT_LIST_PAGE_DOWN_KEY_COMMAND = "FontNamePageDown";
    private static final String FONT_STYLE_UP_KEY_COMMAND = "PrevFontStyle";
    private static final String FONT_STYLE_DOWN_KEY_COMMAND = "NextFontStyle";
    private static final String FONT_STYLE_PAGE_UP_KEY_COMMAND = "FontStylePageUp";
    private static final String FONT_STYLE_PAGE_DOWN_KEY_COMMAND = "FontStylePageDown";
    private static final String FONT_SIZE_UP_KEY_COMMAND = "PrevFontSize";
    private static final String FONT_SIZE_DOWN_KEY_COMMAND = "NextFontSize";
    private static final String FONT_SIZE_PAGE_UP_KEY_COMMAND = "FontSizePageUp";
    private static final String FONT_SIZE_PAGE_DOWN_KEY_COMMAND = "FontSizePageDown";
    private static Font _selectedFont = null;
    private JTextField _fontName = null;
    private JList _fontNameList = null;
    private JTextField _fontStyle = null;
    private JList _fontStyleList = null;
    private JTextField _fontSize = null;
    private JList _fontSizeList = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private JTextField _sampleText = null;

    public static Font create(Dialog dialog, Font font) {
        return SybFontChooser.create(dialog, font, false);
    }

    public static Font create(Dialog dialog, Font font, boolean bl) {
        _selectedFont = null;
        SybFontChooser sybFontChooser = new SybFontChooser(dialog, font, bl);
        sybFontChooser.setVisible(true);
        sybFontChooser.destroy();
        sybFontChooser = null;
        return _selectedFont;
    }

    private SybFontChooser(Dialog dialog, Font font, boolean bl) {
        super(dialog);
        this.setTitle(SybFontChooserResourcesBase.getBundle().get("FontChooserCaption"));
        this.createUI(font, bl);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(dialog);
    }

    private void destroy() {
        if (this._ok != null) {
            this._ok.removeActionListener(this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener(this);
            this._cancel = null;
        }
        DialogUtils.removeComponents(this);
    }

    private void createUI(Font font, boolean bl) {
        SybFontChooserResourcesBase sybFontChooserResourcesBase = SybFontChooserResourcesBase.getBundle();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 3;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        SybLabel sybLabel = new SybLabel(sybFontChooserResourcesBase.get("FontChooserFont"));
        jPanel2.add(sybLabel);
        this._fontName = new JTextField(20);
        this._fontName.setAlignmentX(0.0f);
        Dimension dimension = this._fontName.getPreferredSize();
        Dimension dimension2 = this._fontName.getMaximumSize();
        dimension2.height = dimension.height;
        this._fontName.setMaximumSize(dimension2);
        jPanel2.add(this._fontName);
        sybLabel.setLabelFor(this._fontName);
        this._fontNameList = new JList<String>(this.getFontNameList(bl));
        this._fontNameList.setFocusable(false);
        this._fontNameList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._fontNameList);
        jScrollPane.setAlignmentX(0.0f);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        sybLabel = new SybLabel(sybFontChooserResourcesBase.get("FontChooserFontStyle"));
        jPanel2.add(sybLabel);
        this._fontStyle = new JTextField(15);
        this._fontStyle.setAlignmentX(0.0f);
        dimension = this._fontStyle.getPreferredSize();
        dimension2 = this._fontStyle.getMaximumSize();
        dimension2.height = dimension.height;
        this._fontStyle.setMaximumSize(dimension2);
        jPanel2.add(this._fontStyle);
        sybLabel.setLabelFor(this._fontStyle);
        this._fontStyleList = new JList(new StyleListModel());
        this._fontStyleList.setFocusable(false);
        this._fontStyleList.addListSelectionListener(this);
        jScrollPane = new JScrollPane(this._fontStyleList);
        jScrollPane.setAlignmentX(0.0f);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        sybLabel = new SybLabel(sybFontChooserResourcesBase.get("FontChooserFontSize"));
        jPanel2.add(sybLabel);
        this._fontSize = new JTextField(6);
        this._fontSize.setAlignmentX(0.0f);
        dimension = this._fontSize.getPreferredSize();
        dimension2 = this._fontSize.getMaximumSize();
        dimension2.height = dimension.height;
        this._fontSize.setMaximumSize(dimension2);
        jPanel2.add(this._fontSize);
        sybLabel.setLabelFor(this._fontSize);
        this._fontSizeList = new JList<Object>(new Object[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this._fontSizeList.setFocusable(false);
        this._fontSizeList.addListSelectionListener(this);
        jScrollPane = new JScrollPane(this._fontSizeList);
        jScrollPane.setAlignmentX(0.0f);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(Box.createVerticalStrut(sybLabel.getHeight() + 4));
        this._ok = new SybButton(sybFontChooserResourcesBase.get("FontChooserOK"));
        this._ok.addActionListener(this);
        jPanel2.add(this._ok);
        jPanel2.add(Box.createVerticalStrut(4));
        this._cancel = new SybButton(sybFontChooserResourcesBase.get("FontChooserCancel"));
        this._cancel.addActionListener(this);
        jPanel2.add(this._cancel);
        DialogUtils.makeComponentsSameWidth(this._ok, this._cancel);
        jPanel2.add(Box.createVerticalGlue());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(sybFontChooserResourcesBase.get("FontChooserSample")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this._sampleText = new JTextField("AaBbYyZz", 8);
        this._sampleText.setEditable(false);
        this._sampleText.setFocusable(false);
        jPanel2.add(this._sampleText);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (font != null) {
            String string = font.getFamily();
            this._fontNameList.setSelectedValue(string, true);
            int n = (font.getSize() * 3 + 2) / 4;
            this._fontSizeList.setSelectedValue(Integer.toString(n), true);
            this._fontSize.setText(Integer.toString(n));
            int n2 = font.getStyle();
            StyleListModel styleListModel = (StyleListModel)this._fontStyleList.getModel();
            int n3 = styleListModel.getIndexOfStyle(n2);
            this._fontStyleList.setSelectedIndex(n3);
            this._fontStyleList.ensureIndexIsVisible(n3);
        }
        dimension = this._sampleText.getPreferredSize();
        Dimension dimension3 = this._sampleText.getMinimumSize();
        dimension3.height = dimension.height = (dimension.height * 3 + 1) / 2;
        this._sampleText.setMinimumSize(dimension3);
        this._sampleText.setPreferredSize(dimension);
        this.refreshSample();
        this.registerSpecialKey(this._fontName, 38, FONT_LIST_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontName, 33, FONT_LIST_PAGE_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontName, 40, FONT_LIST_DOWN_KEY_COMMAND);
        this.registerSpecialKey(this._fontName, 34, FONT_LIST_PAGE_DOWN_KEY_COMMAND);
        this.registerSpecialKey(this._fontStyle, 38, FONT_STYLE_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontStyle, 33, FONT_STYLE_PAGE_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontStyle, 40, FONT_STYLE_DOWN_KEY_COMMAND);
        this.registerSpecialKey(this._fontStyle, 34, FONT_STYLE_PAGE_DOWN_KEY_COMMAND);
        this.registerSpecialKey(this._fontSize, 38, FONT_SIZE_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontSize, 33, FONT_SIZE_PAGE_UP_KEY_COMMAND);
        this.registerSpecialKey(this._fontSize, 40, FONT_SIZE_DOWN_KEY_COMMAND);
        this.registerSpecialKey(this._fontSize, 34, FONT_SIZE_PAGE_DOWN_KEY_COMMAND);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().setDefaultButton(this._ok);
        this.getContentPane().add(jPanel);
    }

    private void registerSpecialKey(JComponent jComponent, int n, String string) {
        jComponent.registerKeyboardAction(this, string, KeyStroke.getKeyStroke(n, 0, false), 0);
    }

    Vector<String> getFontNameList(boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>(stringArray.length);
        if (bl) {
            JEditorPane jEditorPane = new JEditorPane();
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().add(jEditorPane);
            jFrame.pack();
            Graphics2D graphics2D = (Graphics2D)jEditorPane.getGraphics();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                FontMetrics fontMetrics;
                Font font = new Font(stringArray[i], 0, 20);
                if (!font.canDisplay('S') || (fontMetrics = graphics2D.getFontMetrics(font)).charWidth('l') != fontMetrics.charWidth('W')) continue;
                treeSet.add(font.getFamily());
            }
            vector.addAll(treeSet);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals(ESCAPE_KEY_COMMAND)) {
                    this.handleCancel();
                } else if (string.equals(FONT_LIST_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontNameList, -1);
                } else if (string.equals(FONT_LIST_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontNameList, 1);
                } else if (string.equals(FONT_LIST_PAGE_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontNameList, -this._fontNameList.getVisibleRowCount());
                } else if (string.equals(FONT_LIST_PAGE_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontNameList, this._fontNameList.getVisibleRowCount());
                } else if (string.equals(FONT_STYLE_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontStyleList, -1);
                } else if (string.equals(FONT_STYLE_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontStyleList, 1);
                } else if (string.equals(FONT_STYLE_PAGE_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontStyleList, -this._fontStyleList.getVisibleRowCount());
                } else if (string.equals(FONT_STYLE_PAGE_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontStyleList, this._fontStyleList.getVisibleRowCount());
                } else if (string.equals(FONT_SIZE_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontSizeList, -1);
                } else if (string.equals(FONT_SIZE_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontSizeList, 1);
                } else if (string.equals(FONT_SIZE_PAGE_UP_KEY_COMMAND)) {
                    this.selectListItem(this._fontSizeList, -this._fontSizeList.getVisibleRowCount());
                } else if (string.equals(FONT_SIZE_PAGE_DOWN_KEY_COMMAND)) {
                    this.selectListItem(this._fontSizeList, this._fontSizeList.getVisibleRowCount());
                }
            }
        }
    }

    private void selectListItem(JList jList, int n) {
        int n2;
        int n3 = jList.getSelectedIndex();
        if (n3 == -1) {
            n2 = 0;
        } else {
            int n4;
            n2 = n3 + n;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= (n4 = jList.getModel().getSize())) {
                n2 = n4 - 1;
            }
        }
        if (n3 != n2) {
            jList.ensureIndexIsVisible(n2);
            jList.setSelectedIndex(n2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JTextField jTextField;
        JList jList;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this._fontNameList) {
            jList = this._fontNameList;
            jTextField = this._fontName;
        } else if (listSelectionEvent.getSource() == this._fontStyleList) {
            jList = this._fontStyleList;
            jTextField = this._fontStyle;
        } else if (listSelectionEvent.getSource() == this._fontSizeList) {
            jList = this._fontSizeList;
            jTextField = this._fontSize;
        } else {
            return;
        }
        Object e = jList.getSelectedValue();
        if (e != null) {
            jTextField.setText(e.toString());
            this.refreshSample();
            jTextField.requestFocusInWindow();
        }
    }

    private void refreshSample() {
        Font font = this.createFont();
        if (font != null) {
            this._sampleText.setFont(font);
        }
    }

    private Font createFont() {
        Font font = null;
        String string = this._fontName.getText();
        if (string != null && string.length() != 0) {
            int n;
            try {
                n = Integer.decode(this._fontSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 10;
            }
            n = n * 4 / 3;
            int n2 = 0;
            int n3 = this._fontStyleList.getSelectedIndex();
            if (n3 != -1) {
                StyleListModel styleListModel = (StyleListModel)this._fontStyleList.getModel();
                n2 = styleListModel.getStyleAt(n3);
            }
            font = new Font(string, n2, n);
        }
        return font;
    }

    private void handleOK() {
        _selectedFont = this.createFont();
        this.setVisible(false);
    }

    private void handleCancel() {
        _selectedFont = null;
        this.setVisible(false);
    }

    static class StyleListModel
    extends AbstractListModel {
        private String[] _displayNames;
        private Integer[] _styles;

        StyleListModel() {
            SybFontChooserResourcesBase sybFontChooserResourcesBase = SybFontChooserResourcesBase.getBundle();
            this._displayNames = new String[]{sybFontChooserResourcesBase.get("FontChooserRegular"), sybFontChooserResourcesBase.get("FontChooserItalic"), sybFontChooserResourcesBase.get("FontChooserBold"), sybFontChooserResourcesBase.get("FontChooserBoldItalic")};
            this._styles = new Integer[]{0, 2, 1, 3};
        }

        @Override
        public Object getElementAt(int n) {
            return this._displayNames[n];
        }

        @Override
        public int getSize() {
            return this._displayNames.length;
        }

        int getStyleAt(int n) {
            return this._styles[n];
        }

        int getIndexOfStyle(int n) {
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this._styles.length; ++i) {
                if (this._styles[i] == n) {
                    n3 = i;
                    break;
                }
                if (this._styles[i] != 0) continue;
                n2 = i;
            }
            if (n3 == -1) {
                n3 = n2;
            }
            return n3;
        }
    }
}

