/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybLineHeaderTableCellRenderer;
import com.sybase.util.SybLineHeaderTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class SybLineHeader
extends JTable
implements PropertyChangeListener,
ChangeListener,
MouseListener,
MouseMotionListener {
    private static final Color HEADER_FOREGROUND_COLOR = UIManager.getColor("TableHeader.foreground");
    private static final Color HEADER_BACKGROUND_COLOR = UIManager.getColor("TableHeader.background");
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final int MIN_SCROLLABLE_VIEWPORT_WIDTH = 28;
    protected int _scrollableViewportWidth = 28;
    protected JTextComponent _textComponent;
    protected JScrollPane _scrollPane;
    protected JViewport _rowHeaderViewport;
    protected SybLineHeaderTableModel _model;
    protected int _fontHeight;
    protected int _pressedMarkLine = -1;
    protected int _draggedDotLine = -1;

    public SybLineHeader(JTextComponent jTextComponent) {
        this._textComponent = jTextComponent;
        this._scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this._textComponent);
        this._rowHeaderViewport = this._scrollPane != null ? this._scrollPane.getRowHeader() : null;
        this._model = new SybLineHeaderTableModel(this, jTextComponent);
        this.setModel(this._model);
        this._textComponent.setBorder(EMPTY_BORDER);
        this.setDefaultRenderer(Integer.class, new SybLineHeaderTableCellRenderer());
        this.setForeground(HEADER_FOREGROUND_COLOR);
        this.setBackground(HEADER_BACKGROUND_COLOR);
        this.setRowMargin(0);
        this.setShowGrid(false);
        this.setEnabled(this._textComponent.isEnabled());
        this._setFontAndRowHeight();
        this._textComponent.addPropertyChangeListener(this);
        if (this._scrollPane != null) {
            this._scrollPane.addPropertyChangeListener(this);
        }
        if (this._rowHeaderViewport != null) {
            this._installRowHeaderViewportChangeListener(null, this._rowHeaderViewport);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void destroy() {
        if (this._textComponent != null) {
            this._textComponent.removePropertyChangeListener(this);
        }
        if (this._scrollPane != null) {
            this._scrollPane.removePropertyChangeListener(this);
        }
        if (this._rowHeaderViewport != null) {
            this._installRowHeaderViewportChangeListener(this._rowHeaderViewport, null);
        }
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this._model != null) {
            this._model.destroy();
        }
        this._textComponent = null;
        this._scrollPane = null;
        this._rowHeaderViewport = null;
        this._model = null;
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public int getLineAtOffset(int n) {
        if (!this._textComponent.isDisplayable() || this._fontHeight == 0) {
            return -1;
        }
        try {
            Rectangle rectangle = this._textComponent.modelToView(n);
            if (rectangle == null) {
                return -1;
            }
            return rectangle.y / this._fontHeight;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int getOffsetAtLine(int n) {
        if (!this._textComponent.isDisplayable()) {
            return -1;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Point point = new Point(rectangle.x, rectangle.y);
        int n2 = this._textComponent.viewToModel(point);
        return n2;
    }

    public Object getWidestCellValue() {
        return this.getLineCount();
    }

    public int getLineCount() {
        if (this._textComponent instanceof JTextArea) {
            return ((JTextArea)this._textComponent).getLineCount();
        }
        return this.getLineAtOffset(this._textComponent.getDocument().getLength()) + 1;
    }

    public void setViewportWidth() {
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(0));
        Component component = tableCellRenderer.getTableCellRendererComponent(this, this.getWidestCellValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        n += this.getIntercellSpacing().width;
        if (this._scrollableViewportWidth != (n = Math.max(n, this._scrollableViewportWidth))) {
            this._scrollableViewportWidth = n;
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this._textComponent);
            if (jScrollPane != null) {
                jScrollPane.revalidate();
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this._scrollableViewportWidth, this.getPreferredSize().height);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setViewportWidth();
        super.tableChanged(tableModelEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this._textComponent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("enabled")) {
                this.setEnabled(this._textComponent.isEnabled());
            } else if (string.equals("font")) {
                this._setFontAndRowHeight();
            }
        } else if (object == this._scrollPane) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("rowHeader")) {
                this._installRowHeaderViewportChangeListener(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this._rowHeaderViewport) {
            JViewport jViewport;
            if (this._scrollPane == null || (jViewport = this._scrollPane.getViewport()) == null) {
                return;
            }
            Point point = jViewport.getViewPosition();
            Point point2 = this._rowHeaderViewport.getViewPosition();
            if (point.y != point2.y) {
                jViewport.setViewPosition(new Point(point.x, point2.y));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._textComponent == null || !this._textComponent.isEnabled()) {
            return;
        }
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) == 1024) {
            int n2;
            int n3;
            int n4 = this.rowAtPoint(mouseEvent.getPoint());
            if (n4 == -1) {
                return;
            }
            Caret caret = this._textComponent.getCaret();
            if ((n & 0x40) == 64) {
                boolean bl;
                int n5 = caret.getDot();
                int n6 = caret.getMark();
                int n7 = this.getLineAtOffset(n5);
                int n8 = this.getLineAtOffset(n6);
                boolean bl2 = bl = n6 == this.getOffsetAtLine(n8);
                if (n7 == -1 || n8 == -1) {
                    return;
                }
                if (n7 >= n8) {
                    if (n4 >= n8) {
                        n3 = this.getOffsetAtLine(n8);
                        n2 = this.getOffsetAtLine(n4 + 1);
                    } else {
                        n2 = this.getOffsetAtLine(n4);
                        n3 = this.getOffsetAtLine(bl ? n8 : n8 + 1);
                    }
                } else if (n4 < n8) {
                    n2 = this.getOffsetAtLine(n4);
                    n3 = this.getOffsetAtLine(bl ? n8 : n8 + 1);
                } else {
                    n3 = this.getOffsetAtLine(n8);
                    n2 = this.getOffsetAtLine(n4 + 1);
                }
            } else {
                n3 = this.getOffsetAtLine(n4);
                n2 = this.getOffsetAtLine(n4 + 1);
            }
            caret.setDot(n3);
            caret.moveDot(n2);
            this._pressedMarkLine = this.getLineAtOffset(n3);
        }
        this._textComponent.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._pressedMarkLine = -1;
        this._draggedDotLine = -1;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        if (this._pressedMarkLine == -1 || (n3 = this.rowAtPoint(mouseEvent.getPoint())) == -1 || n3 == this._draggedDotLine || this._draggedDotLine == -1 && n3 == this._pressedMarkLine) {
            return;
        }
        Caret caret = this._textComponent.getCaret();
        if (n3 >= this._pressedMarkLine) {
            n2 = this.getOffsetAtLine(this._pressedMarkLine);
            n = this.getOffsetAtLine(n3 + 1);
        } else {
            n = this.getOffsetAtLine(n3);
            n2 = this.getOffsetAtLine(this._pressedMarkLine + 1);
        }
        caret.setDot(n2);
        caret.moveDot(n);
        this._draggedDotLine = n3;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void _installRowHeaderViewportChangeListener(Object object, Object object2) {
        if (object != null && object instanceof JViewport) {
            ((JViewport)object).removeChangeListener(this);
        }
        if (object2 != null && object2 instanceof JViewport) {
            ((JViewport)object2).addChangeListener(this);
        }
        this._rowHeaderViewport = (JViewport)object2;
    }

    private void _setFontAndRowHeight() {
        Font font = this._textComponent.getFont();
        int n = this._textComponent.getFontMetrics(font).getHeight();
        this.setFont(font);
        this.setRowHeight(n);
        this._fontHeight = n;
        this.setViewportWidth();
    }
}

