/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybLineHeader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SybLineHeaderTableModel
extends AbstractTableModel
implements DocumentListener,
PropertyChangeListener {
    protected SybLineHeader _lineHeader;
    protected JTextComponent _textComponent;

    public SybLineHeaderTableModel(SybLineHeader sybLineHeader, JTextComponent jTextComponent) {
        this._lineHeader = sybLineHeader;
        this._textComponent = jTextComponent;
        this._installDocumentListener(null, this._textComponent.getDocument());
        this._textComponent.addPropertyChangeListener("document", this);
    }

    public void destroy() {
        if (this._textComponent != null) {
            this._textComponent.removePropertyChangeListener("document", this);
            this._installDocumentListener(this._textComponent.getDocument(), null);
        }
        this._lineHeader = null;
        this._textComponent = null;
    }

    @Override
    public int getRowCount() {
        return this._textComponent != null ? this._lineHeader.getLineCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return n + 1;
    }

    public Class getColumnClass(int n) {
        return Integer.class;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this._handleDocumentEvent();
    }

    private void _handleDocumentEvent() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this._installDocumentListener(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void _installDocumentListener(Object object, Object object2) {
        if (object != null && object instanceof Document) {
            ((Document)object).removeDocumentListener(this);
        }
        if (object2 != null && object2 instanceof Document) {
            ((Document)object2).addDocumentListener(this);
        }
    }
}

