/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybChangeNotificationListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public class SybListSelectionModel
extends DefaultListSelectionModel {
    private static final byte MODE = 0;
    private static final byte SET = 1;
    private static final byte ADD = 2;
    private static final byte REMOVE = 3;
    private static final byte CLEAR = 4;
    private static final byte INSERT_IDX = 5;
    private static final byte REMOVE_IDX = 6;
    private static final byte SET_LEAD = 7;
    private static final byte MOVE_LEAD = 8;
    private static final byte ANCHOR = 9;
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _isSelectionChanging;

    public void destroy() {
        this._listenerList = null;
    }

    public boolean isSelectionChanging() {
        return this._isSelectionChanging;
    }

    public void addChangeNotificationListener(SybChangeNotificationListener sybChangeNotificationListener) {
        this._listenerList.add(SybChangeNotificationListener.class, sybChangeNotificationListener);
    }

    public void removeChangeNotificationListener(SybChangeNotificationListener sybChangeNotificationListener) {
        this._listenerList.remove(SybChangeNotificationListener.class, sybChangeNotificationListener);
    }

    protected boolean fireChangeNotificationChanging() {
        Object[] objectArray = this._listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SybChangeNotificationListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            if (((SybChangeNotificationListener)objectArray[i + 1]).notifyChange(changeEvent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSelectionMode(int n) {
        this._isSelectionChanging = this._isSelectionChanging((byte)0, -1, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.setSelectionMode(n);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        this._isSelectionChanging = this._isSelectionChanging((byte)1, n, n2);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        this._isSelectionChanging = this._isSelectionChanging((byte)2, n, n2);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        this._isSelectionChanging = this._isSelectionChanging((byte)3, n, n2);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.removeSelectionInterval(n, n2);
    }

    @Override
    public void clearSelection() {
        this._isSelectionChanging = this._isSelectionChanging((byte)4, -1, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.clearSelection();
    }

    @Override
    public void insertIndexInterval(int n, int n2, boolean bl) {
        this._isSelectionChanging = this._isSelectionChanging((byte)5, n, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.insertIndexInterval(n, n2, bl);
    }

    @Override
    public void removeIndexInterval(int n, int n2) {
        this._isSelectionChanging = this._isSelectionChanging((byte)6, n, n2);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.removeIndexInterval(n, n2);
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        this._isSelectionChanging = this._isSelectionChanging((byte)7, n, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.setLeadSelectionIndex(n);
    }

    @Override
    public void moveLeadSelectionIndex(int n) {
        this._isSelectionChanging = this._isSelectionChanging((byte)8, n, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.setLeadSelectionIndex(n);
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        this._isSelectionChanging = this._isSelectionChanging((byte)9, n, -1);
        if (!this.fireChangeNotificationChanging()) {
            return;
        }
        super.setAnchorSelectionIndex(n);
    }

    protected boolean _isSelectionChanging(byte by, int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        switch (by) {
            case 0: 
            case 8: 
            case 9: {
                return false;
            }
            case 1: {
                if (this.getMinSelectionIndex() != n3 || this.getMaxSelectionIndex() != n4) {
                    return true;
                }
                for (int i = n3; i <= n4; ++i) {
                    if (this.isSelectedIndex(i)) continue;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                for (int i = n3; i <= n4; ++i) {
                    if (this.isSelectedIndex(i) == (by == 2)) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                return !this.isSelectionEmpty();
            }
            case 5: {
                return this.getSelectionMode() != 0 && this.isSelectedIndex(n);
            }
            case 6: {
                for (int i = n3; i <= n4; ++i) {
                    if (!this.isSelectedIndex(i)) continue;
                    return true;
                }
                return false;
            }
            case 7: {
                return true;
            }
        }
        return true;
    }
}

