/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EmbeddedMnemonic;
import com.sybase.util.EmbeddedMnemonicComponent;
import com.sybase.util.Platform;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class SybMenuItem
extends JMenuItem
implements EmbeddedMnemonicComponent {
    protected EmbeddedMnemonic _em = null;

    public SybMenuItem() {
    }

    public SybMenuItem(Action action) {
        super(action);
        this.setTextWithEmbeddedMnemonicFromAction(action);
    }

    public SybMenuItem(Icon icon) {
        super(icon);
    }

    public SybMenuItem(String string, int n) {
        super(string, n);
    }

    public SybMenuItem(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybMenuItem(String string, Icon icon) {
        super(icon);
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public void setIcon(Icon icon) {
        if (!Platform.isMacOS()) {
            super.setIcon(icon);
        }
    }

    @Override
    public EmbeddedMnemonic getEmbeddedMnemonic() {
        return this._em;
    }

    @Override
    public void setAction(Action action) {
        super.setAction(action);
        this.setTextWithEmbeddedMnemonicFromAction(action);
    }

    @Override
    public void setText(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public void setMnemonic(int n) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(n);
        }
        if (!Platform.isMacOS()) {
            super.setMnemonic(n);
        }
    }

    @Override
    public void setMnemonic(char c) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(c);
        }
        if (!Platform.isMacOS()) {
            super.setMnemonic(c);
        }
    }

    protected void setTextWithEmbeddedMnemonic(String string) {
        int n = this.getMnemonic();
        EmbeddedMnemonic embeddedMnemonic = EmbeddedMnemonic.getEmbeddedMnemonic(string);
        if (embeddedMnemonic.getMnemonic() == '\u0000' && n != 0) {
            embeddedMnemonic.setMnemonic(n);
        }
        this._em = null;
        super.setText(embeddedMnemonic.textWithoutMnemonic);
        if (embeddedMnemonic.index > -1 && !Platform.isMacOS()) {
            super.setMnemonic(embeddedMnemonic.c);
            super.setDisplayedMnemonicIndex(embeddedMnemonic.index);
        }
        this._em = embeddedMnemonic;
    }

    protected void setTextWithEmbeddedMnemonicFromAction(Action action) {
        String string;
        Integer n = (Integer)action.getValue("MnemonicKey");
        if (n == null && (string = (String)action.getValue("Name")) != null && string.length() != 0) {
            this.setTextWithEmbeddedMnemonic(string);
        }
    }
}

