/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.LineSplitter;
import com.sybase.util.Platform;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class SybMultiLineLabelUI
extends BasicLabelUI {
    private static Method _drawStringUnderlineCharAt = null;
    private boolean _painted = false;
    private int _lastRowCount = -1;

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.drawLines(graphics, (SybMultiLineLabel)jComponent);
        this._painted = true;
    }

    private void drawLines(Graphics graphics, SybMultiLineLabel sybMultiLineLabel) {
        int n = -1;
        int n2 = 0;
        LineSplitter lineSplitter = null;
        n = sybMultiLineLabel.getEmbeddedMnemonic().index;
        String string = sybMultiLineLabel.getEmbeddedMnemonic().getTextWithoutMnemonic();
        Insets insets = sybMultiLineLabel.getInsets();
        if (sybMultiLineLabel.isOpaque()) {
            graphics.setColor(sybMultiLineLabel.getBackground());
            graphics.fillRect(insets.left, insets.top, sybMultiLineLabel.getSize().width - (insets.left + insets.right), sybMultiLineLabel.getSize().height - (insets.top + insets.bottom));
        }
        if (string != null && string.length() > 0) {
            lineSplitter = sybMultiLineLabel.columns > 0 ? new LineSplitter(string, sybMultiLineLabel.columns) : new LineSplitter(string, sybMultiLineLabel.getSize().width - (insets.left + insets.right), sybMultiLineLabel);
            while (lineSplitter.hasMoreLines()) {
                String string2 = lineSplitter.nextLine().trim();
                boolean bl = false;
                if (n >= 0) {
                    if (n > string2.length() - 1) {
                        n -= string2.length() - 1;
                    } else {
                        bl = true;
                    }
                }
                if (string2.length() <= 0 && !lineSplitter.hasMoreLines()) continue;
                if (sybMultiLineLabel.isEnabled()) {
                    this.paintEnabledText(sybMultiLineLabel, graphics, string2, bl ? n : -1, this.getStartingXPoint(string2, sybMultiLineLabel), insets.top + this.getRowHeight(sybMultiLineLabel) * (n2 + 1));
                } else {
                    this.paintDisabledText(sybMultiLineLabel, graphics, string2, bl ? n : -1, this.getStartingXPoint(string2, sybMultiLineLabel), insets.top + this.getRowHeight(sybMultiLineLabel) * (n2 + 1));
                }
                if (bl) {
                    n = -1;
                }
                ++n2;
            }
            int n3 = sybMultiLineLabel.getSize().height - (insets.top + insets.bottom);
            int n4 = n3 / this.getRowHeight(sybMultiLineLabel);
            if (this._lastRowCount != n4 && n2 != n4) {
                this._lastRowCount = n4;
                JRootPane jRootPane = sybMultiLineLabel.getRootPane();
                if (jRootPane != null) {
                    sybMultiLineLabel.revalidate();
                }
            } else {
                this._lastRowCount = -1;
            }
        }
    }

    private int getRowHeight(SybMultiLineLabel sybMultiLineLabel) {
        FontMetrics fontMetrics = sybMultiLineLabel.getFontMetrics(sybMultiLineLabel.getFont());
        return fontMetrics.getHeight();
    }

    private int getCharWidth(char c, SybMultiLineLabel sybMultiLineLabel) {
        FontMetrics fontMetrics = sybMultiLineLabel.getFontMetrics(sybMultiLineLabel.getFont());
        return fontMetrics.charWidth(c);
    }

    private int getStringWidth(String string, SybMultiLineLabel sybMultiLineLabel) {
        FontMetrics fontMetrics = sybMultiLineLabel.getFontMetrics(sybMultiLineLabel.getFont());
        return fontMetrics.stringWidth(string);
    }

    private int getStartingXPoint(String string, SybMultiLineLabel sybMultiLineLabel) {
        Insets insets = sybMultiLineLabel.getInsets();
        int n = sybMultiLineLabel.getSize().width;
        int n2 = this.getStringWidth(string, sybMultiLineLabel);
        if (sybMultiLineLabel.getHorizontalAlignment() == 0) {
            return insets.left + (n - insets.left - insets.right - n2) / 2;
        }
        if (sybMultiLineLabel.getHorizontalAlignment() == 4) {
            return insets.left + (n - n2 - insets.right) - 2;
        }
        return insets.left;
    }

    protected void paintEnabledText(SybMultiLineLabel sybMultiLineLabel, Graphics graphics, String string, int n, int n2, int n3) {
        if (Platform.isWindows()) {
            this.paintEnabledWindowsText(sybMultiLineLabel, graphics, string, n, n2, n3);
        } else {
            graphics.setColor(sybMultiLineLabel.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2, n3);
        }
    }

    private void paintEnabledWindowsText(SybMultiLineLabel sybMultiLineLabel, Graphics graphics, String string, int n, int n2, int n3) {
        if (UIUtils.isMnemonicHidden()) {
            n = -1;
        }
        graphics.setColor(sybMultiLineLabel.getForeground());
        SybMultiLineLabelUI.SwingUtilities2_drawStringUnderlineCharAt(sybMultiLineLabel, graphics, string, n, n2, n3);
    }

    protected void paintDisabledText(SybMultiLineLabel sybMultiLineLabel, Graphics graphics, String string, int n, int n2, int n3) {
        if (Platform.isWindows()) {
            this.paintDisabledWindowsText(sybMultiLineLabel, graphics, string, n, n2, n3);
        } else {
            Color color = sybMultiLineLabel.getBackground();
            graphics.setColor(color.brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2 + 1, n3 + 1);
            graphics.setColor(color.darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2, n3);
        }
    }

    private void paintDisabledWindowsText(SybMultiLineLabel sybMultiLineLabel, Graphics graphics, String string, int n, int n2, int n3) {
        if (UIUtils.isMnemonicHidden()) {
            n = -1;
        }
        if (UIManager.getColor("Label.disabledForeground") instanceof Color && UIManager.getColor("Label.disabledShadow") instanceof Color) {
            graphics.setColor(UIManager.getColor("Label.disabledShadow"));
            SybMultiLineLabelUI.SwingUtilities2_drawStringUnderlineCharAt(sybMultiLineLabel, graphics, string, n, n2 + 1, n3 + 1);
            graphics.setColor(UIManager.getColor("Label.disabledForeground"));
            SybMultiLineLabelUI.SwingUtilities2_drawStringUnderlineCharAt(sybMultiLineLabel, graphics, string, n, n2, n3);
        } else {
            Color color = sybMultiLineLabel.getBackground();
            graphics.setColor(color.brighter());
            SybMultiLineLabelUI.SwingUtilities2_drawStringUnderlineCharAt(sybMultiLineLabel, graphics, string, n, n2 + 1, n3 + 1);
            graphics.setColor(color.darker());
            SybMultiLineLabelUI.SwingUtilities2_drawStringUnderlineCharAt(sybMultiLineLabel, graphics, string, n, n2, n3);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SybMultiLineLabel sybMultiLineLabel = (SybMultiLineLabel)jComponent;
        Dimension dimension = super.getPreferredSize(jComponent);
        int n = 0;
        LineSplitter lineSplitter = null;
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Insets insets = null;
        insets = sybMultiLineLabel.getInsets();
        String string2 = sybMultiLineLabel.getEmbeddedMnemonic().getTextWithoutMnemonic();
        if (string2 != null && string2.length() > 0) {
            n3 = !this._painted ? (int)((double)(this.getInitialMaxCharactersPerLineCount() * this.getCharWidth('m', sybMultiLineLabel)) * 0.955) : sybMultiLineLabel.getSize().width - (insets.left + insets.right);
            lineSplitter = sybMultiLineLabel.columns > 0 ? new LineSplitter(string2, sybMultiLineLabel.columns) : new LineSplitter(string2, n3, sybMultiLineLabel);
            while (lineSplitter.hasMoreLines()) {
                string = lineSplitter.nextLine().trim();
                if (string.length() <= 0 && !lineSplitter.hasMoreLines()) continue;
                n4 = this.getStringWidth(string, sybMultiLineLabel);
                if (n5 < n4) {
                    n5 = n4;
                }
                ++n;
            }
            n2 = (int)((double)this.getRowHeight(sybMultiLineLabel) * ((double)n + 0.5));
            dimension = new Dimension(n5 + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }
        return dimension;
    }

    private int getInitialMaxCharactersPerLineCount() {
        Locale locale = null;
        locale = Locale.getDefault();
        String string = locale.getLanguage();
        if (string.equals("ja") || string.equals("ko") || string.equals("zh")) {
            return 42;
        }
        return 64;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SybMultiLineLabelUI();
    }

    private static void SwingUtilities2_drawStringUnderlineCharAt(SybMultiLineLabel sybMultiLineLabel, Graphics graphics, String string, int n, int n2, int n3) {
        block4: {
            try {
                if (_drawStringUnderlineCharAt == null) {
                    Class<?> clazz = Class.forName("sun.swing.SwingUtilities2");
                    _drawStringUnderlineCharAt = clazz.getDeclaredMethod("drawStringUnderlineCharAt", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                if (_drawStringUnderlineCharAt != null) {
                    _drawStringUnderlineCharAt.invoke(null, sybMultiLineLabel, graphics, string, n, n2, n3);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof RuntimeException)) break block4;
                throw (RuntimeException)exception;
            }
        }
    }
}

