/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.EmbeddedMnemonic;
import com.sybase.util.EmbeddedMnemonicComponent;
import com.sybase.util.Platform;
import com.sybase.util.UIUtils;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class SybRadioButton
extends JRadioButton
implements EmbeddedMnemonicComponent {
    protected EmbeddedMnemonic _em = null;

    public SybRadioButton() {
    }

    public SybRadioButton(Action action) {
        super(action);
        this.setTextWithEmbeddedMnemonicFromAction(action);
    }

    public SybRadioButton(Icon icon) {
        super(icon);
    }

    public SybRadioButton(Icon icon, boolean bl) {
        super(icon, bl);
    }

    public SybRadioButton(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybRadioButton(String string, boolean bl) {
        super((String)null, bl);
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybRadioButton(String string, Icon icon) {
        super(icon);
        this.setTextWithEmbeddedMnemonic(string);
    }

    public SybRadioButton(String string, Icon icon, boolean bl) {
        super(null, icon, bl);
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public EmbeddedMnemonic getEmbeddedMnemonic() {
        return this._em;
    }

    @Override
    public void setText(String string) {
        this.setTextWithEmbeddedMnemonic(string);
    }

    @Override
    public void setMnemonic(int n) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(n);
        }
        if (!Platform.isMacOS()) {
            super.setMnemonic(n);
        }
    }

    @Override
    public void setMnemonic(char c) {
        if (this._em != null) {
            super.setText(this._em.getOriginalText());
            this._em.setMnemonic(c);
        }
        super.setMnemonic(c);
    }

    protected void setTextWithEmbeddedMnemonic(String string) {
        int n = this.getMnemonic();
        EmbeddedMnemonic embeddedMnemonic = EmbeddedMnemonic.getEmbeddedMnemonic(string);
        if (embeddedMnemonic.getMnemonic() == '\u0000' && n != 0) {
            embeddedMnemonic.setMnemonic(n);
        }
        this._em = null;
        super.setText(embeddedMnemonic.textWithoutMnemonic);
        if (!Platform.isMacOS()) {
            super.setMnemonic(embeddedMnemonic.c);
            super.setDisplayedMnemonicIndex(embeddedMnemonic.index);
        }
        this._em = embeddedMnemonic;
    }

    protected void setTextWithEmbeddedMnemonicFromAction(Action action) {
        String string;
        Integer n = (Integer)action.getValue("MnemonicKey");
        if (n == null && (string = (String)action.getValue("Name")) != null && string.length() != 0) {
            this.setTextWithEmbeddedMnemonic(string);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getID();
        if (n2 == 402 && ((n = keyEvent.getKeyCode()) == 38 || n == 40) && keyEvent.getModifiers() == 0 && UIUtils.isWindowsLAF() && this.transferFocusForArrowKey(n)) {
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    private boolean transferFocusForArrowKey(int n) {
        boolean bl;
        block8: {
            AbstractButton abstractButton;
            bl = false;
            ButtonModel buttonModel = this.getModel();
            if (!(buttonModel instanceof DefaultButtonModel)) break block8;
            ButtonGroup buttonGroup = ((DefaultButtonModel)buttonModel).getGroup();
            int n2 = buttonGroup.getButtonCount();
            ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>(n2);
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            int n3 = 0;
            int n4 = -1;
            while (enumeration.hasMoreElements()) {
                abstractButton = enumeration.nextElement();
                arrayList.add(abstractButton);
                if (abstractButton.isSelected()) {
                    n4 = n3;
                }
                ++n3;
            }
            if (n4 != -1) {
                n3 = n4;
                do {
                    if (n == 40) {
                        if (++n3 == n2) {
                            n3 = 0;
                        }
                    } else if (--n3 < 0) {
                        n3 = n2 - 1;
                    }
                    if (n3 == n4) break block8;
                } while (!(abstractButton = (AbstractButton)arrayList.get(n3)).isVisible() || !abstractButton.isEnabled());
                abstractButton.setSelected(true);
                abstractButton.requestFocus();
                bl = true;
            }
        }
        return bl;
    }
}

