/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybRowHeaderTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SybRowHeader
extends JTable
implements PropertyChangeListener,
MouseListener,
ChangeListener {
    private static final Color HEADER_FOREGROUND_COLOR = UIManager.getColor("TableHeader.foreground");
    private static final Color HEADER_BACKGROUND_COLOR = UIManager.getColor("TableHeader.background");
    private static final int MIN_SCROLLABLE_VIEWPORT_WIDTH = 28;
    protected int _scrollableViewportWidth = 28;
    protected JTable _table;
    protected JScrollPane _scrollPane;
    protected JViewport _rowHeaderViewport;
    protected SybRowHeaderTableModel _model;

    public SybRowHeader(JTable jTable) {
        this._table = jTable;
        this._scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this._table);
        this._rowHeaderViewport = this._scrollPane != null ? this._scrollPane.getRowHeader() : null;
        this._model = new SybRowHeaderTableModel(jTable);
        this.setModel(this._model);
        this.setForeground(HEADER_FOREGROUND_COLOR);
        this.setBackground(HEADER_BACKGROUND_COLOR);
        this.setSelectionModel(this._table.getSelectionModel());
        this.setEnabled(this._table.isEnabled());
        this.setSelectionForeground(this._table.getSelectionForeground());
        this.setSelectionBackground(this._table.getSelectionBackground());
        this.setRowHeight(this._table.getRowHeight());
        this.setRowMargin(this._table.getRowMargin());
        this.setShowHorizontalLines(this._table.getShowHorizontalLines());
        this.setFont(this._table.getFont());
        this.setViewportWidth();
        this._table.addPropertyChangeListener(this);
        if (this._scrollPane != null) {
            this._scrollPane.addPropertyChangeListener(this);
        }
        if (this._rowHeaderViewport != null) {
            this._installRowHeaderViewportChangeListener(null, this._rowHeaderViewport);
        }
        this.addMouseListener(this);
    }

    public void destroy() {
        this._table.removePropertyChangeListener(this);
        if (this._scrollPane != null) {
            this._scrollPane.removePropertyChangeListener(this);
        }
        if (this._rowHeaderViewport != null) {
            this._installRowHeaderViewportChangeListener(this._rowHeaderViewport, null);
        }
        this.removeMouseListener(this);
        if (this._model != null) {
            this._model.destroy();
        }
        this._table = null;
        this._scrollPane = null;
        this._rowHeaderViewport = null;
        this._model = null;
    }

    public JTable getTable() {
        return this._table;
    }

    public Object getWidestCellValue() {
        return this.getRowCount();
    }

    public void setViewportWidth() {
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(0));
        Component component = tableCellRenderer.getTableCellRendererComponent(this, this.getWidestCellValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        n += this.getIntercellSpacing().width;
        if (this._scrollableViewportWidth != (n = Math.max(n, 28))) {
            this._scrollableViewportWidth = n;
            if (this._scrollPane != null) {
                this._scrollPane.revalidate();
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this._scrollableViewportWidth, this.getPreferredSize().height);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setViewportWidth();
        super.tableChanged(tableModelEvent);
    }

    @Override
    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = this.getRowCount();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n2 >= n) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] >= n) continue;
                ++n4;
            }
            int[] nArray2 = new int[n4];
            n4 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] >= n) continue;
                nArray2[n4] = nArray[n3];
                ++n4;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this._table) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("selectionModel")) {
                this.setSelectionModel(this._table.getSelectionModel());
            } else if (string.equals("enabled")) {
                this.setEnabled(this._table.isEnabled());
            } else if (string.equals("selectionForeground")) {
                this.setSelectionForeground(this._table.getSelectionForeground());
            } else if (string.equals("selectionBackground")) {
                this.setSelectionBackground(this._table.getSelectionBackground());
            } else if (string.equals("rowHeight")) {
                this.setRowHeight(this._table.getRowHeight());
            } else if (string.equals("rowMargin")) {
                this.setRowMargin(this._table.getRowMargin());
            } else if (string.equals("showHorizontalLines")) {
                this.setShowHorizontalLines(this._table.getShowHorizontalLines());
            } else if (string.equals("font")) {
                this.setFont(this._table.getFont());
                this.setViewportWidth();
            } else if (string.equals("model")) {
                this.setViewportWidth();
            }
        } else if (object == this._scrollPane) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("rowHeader")) {
                this._installRowHeaderViewportChangeListener(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this && this._table.isEnabled()) {
            boolean bl;
            TableCellEditor tableCellEditor;
            if (this._table.isEditing() && (tableCellEditor = this._table.getCellEditor()) != null && !(bl = tableCellEditor.stopCellEditing())) {
                tableCellEditor.cancelCellEditing();
            }
            this._table.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this._rowHeaderViewport) {
            JViewport jViewport;
            if (this._scrollPane == null || (jViewport = this._scrollPane.getViewport()) == null) {
                return;
            }
            Point point = jViewport.getViewPosition();
            Point point2 = this._rowHeaderViewport.getViewPosition();
            if (point.y != point2.y) {
                jViewport.setViewPosition(new Point(point.x, point2.y));
            }
        }
    }

    private void _installRowHeaderViewportChangeListener(Object object, Object object2) {
        if (object != null && object instanceof JViewport) {
            ((JViewport)object).removeChangeListener(this);
        }
        if (object2 != null && object2 instanceof JViewport) {
            ((JViewport)object2).addChangeListener(this);
        }
        this._rowHeaderViewport = (JViewport)object2;
    }
}

