/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;

public class SybTableUI
extends TableUI
implements PropertyChangeListener {
    protected TableUI _defaultUI = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SybTableUI();
    }

    public SybTableUI() {
        Object object = UIManager.getDefaults().get("Default_TableUI");
        try {
            this._defaultUI = (TableUI)Class.forName(object.toString()).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._defaultUI.installUI(jComponent);
        this.updateRowHeight((JTable)jComponent);
        jComponent.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
        this._defaultUI.uninstallUI(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this._defaultUI.paint(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this._defaultUI.update(graphics, jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this._defaultUI.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this._defaultUI.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this._defaultUI.getMaximumSize(jComponent);
    }

    @Override
    public boolean contains(JComponent jComponent, int n, int n2) {
        return this._defaultUI.contains(jComponent, n, n2);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent jComponent) {
        return this._defaultUI.getAccessibleChildrenCount(jComponent);
    }

    @Override
    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return this._defaultUI.getAccessibleChild(jComponent, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("font") && (object = propertyChangeEvent.getSource()) instanceof JTable) {
            this.updateRowHeight((JTable)object);
        }
    }

    private void updateRowHeight(JTable jTable) {
        Font font = jTable.getFont();
        if (font != null) {
            FontMetrics fontMetrics = jTable.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            if (border != null) {
                Insets insets = border.getBorderInsets(jTable);
                n += insets.top + insets.bottom;
            }
            Dimension dimension = jTable.getIntercellSpacing();
            int n2 = jTable.getRowHeight();
            if ((n += dimension.height) != n2) {
                jTable.setRowHeight(n);
            }
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

