/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.FontHelper;
import com.sybase.util.ImageLoader;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybTitledPanelCloseEvent;
import com.sybase.util.SybTitledPanelCloseListener;
import com.sybase.util.SybTitledPanelResourceBundle;
import com.sybase.util.SybTitledPanelResourceConstants;
import com.sybase.util.SybToolBarButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class SybTitledPanel
extends JPanel
implements ActionListener,
SybTitledPanelResourceConstants {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(SybTitledPanelResourceBundle.class.getName());
    private static final Color BACKGROUND_COLOR = UIManager.getColor("Button.background");
    private JComponent _component;
    private String _title;
    private boolean _showCloseButton;
    private JPanel _titlePanel;
    private SybLabel _titleLabel;
    private SybButton _closeButton;
    private Vector<SybTitledPanelCloseListener> _closeListeners = new Vector();

    public SybTitledPanel(JComponent jComponent, String string) {
        this(jComponent, string, true);
    }

    public SybTitledPanel(JComponent jComponent, String string, boolean bl) {
        this._component = jComponent;
        this._title = string;
        this._showCloseButton = bl;
        this._init();
    }

    private void _init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._component, "Center");
        this._titlePanel = new JPanel(new BorderLayout());
        this._titlePanel.setBorder(BorderFactory.createEtchedBorder());
        this._titleLabel = new SybLabel(this._title);
        new FontHelper(this._titleLabel);
        this._titleLabel.setOpaque(true);
        this._titleLabel.setBackground(BACKGROUND_COLOR);
        this._titlePanel.add((Component)this._titleLabel, "Center");
        if (this._showCloseButton) {
            this._closeButton = new SybToolBarButton(ImageLoader.getImageIcon(ImageLoader.class, "close", 1006));
            this._closeButton.setToolTipText(BUNDLE.getString("HINT_CLOSE"));
            this._titlePanel.add((Component)this._closeButton, "East");
        } else {
            this._titleLabel.setBorder(new EmptyBorder(new Insets(4, 4, 4, 4)));
        }
        this.add((Component)this._titlePanel, "North");
        if (this._showCloseButton) {
            this._closeButton.addActionListener(this);
        }
    }

    public void releaseResources() {
        if (this._showCloseButton) {
            this._closeButton.removeActionListener(this);
        }
        this._component = null;
        this._title = null;
        this._titlePanel = null;
        this._titleLabel = null;
        this._closeButton = null;
        this._closeListeners = null;
    }

    @Override
    public void requestFocus() {
        this._component.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this._component.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._component.setEnabled(bl);
        this._titlePanel.setEnabled(bl);
        this._titleLabel.setEnabled(bl);
        if (this._showCloseButton) {
            this._closeButton.setEnabled(bl);
        }
    }

    public JComponent getComponent() {
        return this._component;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
        this._titleLabel.setText(string);
    }

    public JPanel getTitledPanel() {
        return this._titlePanel;
    }

    public void addCloseListener(SybTitledPanelCloseListener sybTitledPanelCloseListener) {
        this._closeListeners.add(sybTitledPanelCloseListener);
    }

    public void removeCloseListener(SybTitledPanelCloseListener sybTitledPanelCloseListener) {
        this._closeListeners.remove(sybTitledPanelCloseListener);
    }

    protected void fireCloseRequested(ActionEvent actionEvent) {
        SybTitledPanelCloseEvent sybTitledPanelCloseEvent = new SybTitledPanelCloseEvent(this, actionEvent);
        int n = this._closeListeners.size();
        for (int i = 0; i < n; ++i) {
            this._closeListeners.get(i).closeRequested(sybTitledPanelCloseEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._showCloseButton && actionEvent.getSource() == this._closeButton) {
            this.fireCloseRequested(actionEvent);
        }
    }
}

