/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybButton;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public class SybToolBarButton
extends SybButton
implements MouseListener,
MouseMotionListener {
    protected boolean _isXP;
    protected Border _noBorder;
    protected Border _buttonBorder;
    protected Border _pressedButtonBorder;
    protected static final int ARC_DIAMETER = 8;
    static final int BORDER_SIZE = 2;
    protected static Color _pressedButtonColor;
    protected static Color _pressedButtonBorderColor;
    protected static Color _borderColor;
    protected static Color _enteredColor;
    protected boolean _pressed = false;
    protected boolean _onButton = false;

    public SybToolBarButton() {
        this.init();
    }

    public SybToolBarButton(Icon icon) {
        super(icon);
        this.init();
    }

    public SybToolBarButton(Action action) {
        super(action);
        this.init();
    }

    protected void init() {
        this._isXP = UIUtils.isXPLookAndFeelActive();
        this.initializeBorders();
        this.setAlignmentY(0.5f);
        super.setBorder(this.getNoBorder());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(false);
        if (this._isXP) {
            super.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._isXP) {
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this._onButton) {
                if (this._pressed) {
                    graphics2D.setColor(_pressedButtonColor);
                    graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
                    graphics2D.setColor(_pressedButtonBorderColor);
                    graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
                } else {
                    graphics2D.setColor(_enteredColor);
                    graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
                    graphics2D.setColor(_borderColor);
                    graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
                    Color color = _borderColor;
                    Color color2 = this.averageColor(_enteredColor, color);
                    graphics2D.setColor(color);
                    int n3 = 4;
                    graphics2D.draw(new Line2D.Double(n2 - 2, n3, n2 - 2, n - n3));
                    graphics2D.draw(new Line2D.Double(n3, n - 2, n2 - n3, n2 - 2));
                    graphics2D.setColor(color2);
                    graphics2D.draw(new Line2D.Double(n2 - 3, n3, n2 - 3, n - n3));
                    graphics2D.draw(new Line2D.Double(n3, n - 3, n2 - n3, n2 - 3));
                }
            } else {
                graphics2D.setColor(SystemColor.control);
                graphics2D.fillRect(0, 0, n2, n);
            }
            super.paintComponent(graphics);
        } else {
            super.paintComponent(graphics);
        }
        this._onButton = false;
    }

    protected void initializeBorders() {
        if (this._isXP) {
            this._buttonBorder = this._noBorder = BorderFactory.createEmptyBorder(6, 6, 6, 6);
            this._pressedButtonBorder = this._noBorder;
            _pressedButtonBorderColor = SystemColor.controlShadow;
            _pressedButtonColor = this.averageColor(SystemColor.controlLtHighlight, SystemColor.controlShadow);
            _borderColor = this.averageColor(SystemColor.control, SystemColor.controlShadow);
            _enteredColor = this.averageColor(SystemColor.control, SystemColor.controlLtHighlight);
        } else {
            Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            this._noBorder = BorderFactory.createCompoundBorder(border2, border);
            this._buttonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), border);
            this._pressedButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), border);
        }
    }

    protected Border getNoBorder() {
        return this._noBorder;
    }

    protected Border getButtonBorder() {
        return this._buttonBorder;
    }

    protected Border getPressedButtonBorder() {
        return this._pressedButtonBorder;
    }

    protected Color averageColor(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    public void releaseResources() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public void setBorder(Border border) {
        if (!(this._isXP || border != this.getNoBorder() && border != this.getButtonBorder() && border != this.getPressedButtonBorder())) {
            super.setBorder(border);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._onButton = false;
        if (this._isXP) {
            this.repaint();
        } else {
            super.setBorder(this.getNoBorder());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this._pressed = true;
            if (this._isXP) {
                this.repaint();
            } else {
                super.setBorder(this.getPressedButtonBorder());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._pressed) {
            this._pressed = false;
            if (this._isXP) {
                this.repaint();
            } else {
                if (this.getBorder() == this.getPressedButtonBorder()) {
                    super.setBorder(this.getButtonBorder());
                } else {
                    super.setBorder(this.getNoBorder());
                }
                Container container = this.getParent();
                if (container == null) {
                    super.setBorder(this.getNoBorder());
                } else {
                    while (container != null) {
                        if (!container.isVisible()) {
                            super.setBorder(this.getNoBorder());
                            return;
                        }
                        if (container instanceof Window) {
                            return;
                        }
                        if (!(container instanceof Container)) continue;
                        container = container.getParent();
                    }
                    super.setBorder(this.getNoBorder());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this._onButton = true;
            if (this._isXP) {
                this.repaint();
            } else if (this._pressed) {
                super.setBorder(this.getPressedButtonBorder());
            } else {
                super.setBorder(this.getButtonBorder());
            }
        }
    }

    protected boolean dbgEnabled() {
        return false;
    }
}

