/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DropDownButtonEvent;
import com.sybase.util.DropDownButtonListener;
import com.sybase.util.SybDropDownButtonModel;
import com.sybase.util.SybToolBarButton;
import com.sybase.util.TDDBUI;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ButtonUI;

public class SybToolBarDropDownButton
extends SybToolBarButton {
    protected static Border _noBorder;
    protected static Border _buttonBorder;
    protected static Border _pressedButtonBorder;
    private EventListenerList _dropDownButtonListeners = new EventListenerList();

    public SybToolBarDropDownButton(Icon icon, Object[] objectArray) {
        this(icon, objectArray, null);
    }

    public SybToolBarDropDownButton(Icon icon, Object[] objectArray, Icon[] iconArray) {
        super(icon);
        this.init(objectArray, iconArray);
    }

    private void init(Object[] objectArray, Icon[] iconArray) {
        this.setAlignmentY(0.5f);
        this.setBorder(this.getNoBorder());
        ButtonModel buttonModel = this.getModel();
        super.setModel(new SybDropDownButtonModel(buttonModel, objectArray, iconArray));
        ButtonUI buttonUI = this.getUI();
        super.setUI(new TDDBUI(buttonUI, this));
    }

    public void setListData(Object[] objectArray) {
        this.setListData(objectArray, null);
    }

    public void setListData(Object[] objectArray, Icon[] iconArray) {
        SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)this.getModel();
        sybDropDownButtonModel.setListData(objectArray, iconArray);
    }

    public void setEnabledStates(boolean[] blArray) {
        SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)this.getModel();
        if (sybDropDownButtonModel == null) {
            throw new IllegalStateException("model must be defined before applying enabled states");
        }
        sybDropDownButtonModel.setEnabledStates(blArray);
    }

    public void addDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.add(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void removeDropDownButtonListener(DropDownButtonListener dropDownButtonListener) {
        if (dropDownButtonListener instanceof DropDownButtonListener) {
            this._dropDownButtonListeners.remove(DropDownButtonListener.class, dropDownButtonListener);
        }
    }

    public void showDropDown() {
        ((SybDropDownButtonModel)this.getModel()).fireDropDownEvent();
    }

    void fireDropDownItemClickedEvent(int n) {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent(this, n);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownItemClicked(dropDownButtonEvent);
        }
    }

    void fireDropDownOpeningEvent() {
        DropDownButtonEvent dropDownButtonEvent = null;
        Object[] objectArray = this._dropDownButtonListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (dropDownButtonEvent == null) {
                dropDownButtonEvent = new DropDownButtonEvent(this);
            }
            ((DropDownButtonListener)objectArray[i + 1]).dropDownOpening(dropDownButtonEvent);
        }
    }

    @Override
    protected void initializeBorders() {
        if (this._isXP) {
            _buttonBorder = _noBorder = BorderFactory.createEmptyBorder(6, 6, 6, 20);
            _pressedButtonBorder = _noBorder;
            _pressedButtonBorderColor = SystemColor.controlShadow;
            _pressedButtonColor = this.averageColor(SystemColor.controlLtHighlight, SystemColor.controlShadow);
            _borderColor = this.averageColor(SystemColor.control, SystemColor.controlShadow);
            _enteredColor = this.averageColor(SystemColor.control, SystemColor.controlLtHighlight);
        } else {
            Border border = BorderFactory.createEmptyBorder(2, 2, 2, 16);
            Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            _noBorder = BorderFactory.createCompoundBorder(border2, border);
            _buttonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), border);
            _pressedButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), border);
        }
    }

    @Override
    protected Border getNoBorder() {
        return _noBorder;
    }

    @Override
    protected Border getButtonBorder() {
        return _buttonBorder;
    }

    @Override
    protected Border getPressedButtonBorder() {
        return _pressedButtonBorder;
    }
}

