/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sun.java.swing.plaf.windows.WindowsTextFieldUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class SybWindowsTextFieldUI
extends WindowsTextFieldUI {
    private MyFocusListener _myFocusListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SybWindowsTextFieldUI();
    }

    private SybWindowsTextFieldUI() {
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this._myFocusListener = new MyFocusListener();
        jComponent.addFocusListener(this._myFocusListener);
    }

    public void uninstallUI(JComponent jComponent) {
        if (this._myFocusListener != null) {
            jComponent.removeFocusListener(this._myFocusListener);
            this._myFocusListener = null;
        }
        super.uninstallUI(jComponent);
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Window window;
                Window window2;
                Component component = focusEvent.getOppositeComponent();
                JTextField jTextField = (JTextField)focusEvent.getComponent();
                if (component != null && ((window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, component)) != (window = (Window)SwingUtilities.getAncestorOfClass(Window.class, jTextField)) || component instanceof JTabbedPane)) {
                    component = null;
                }
                if (component == null) {
                    jTextField.select(0, jTextField.getText().length());
                }
                jTextField.removeFocusListener(this);
                SybWindowsTextFieldUI.this._myFocusListener = null;
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

