/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybDropDownButtonModel;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybToolBarDropDownButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

class TDDBUI
extends BasicButtonUI
implements ActionListener,
MouseListener {
    static final int SEPARATOR_WIDTH = 1;
    static final int BORDER_WIDTH = 3;
    static final int ARROW_WIDTH = 7;
    static final int ARROW_HEIGHT = 4;
    static final int DROP_DOWN_BUTTON_WIDTH = 14;
    private ButtonUI _encapsulatedUI;
    private SybToolBarDropDownButton _button;
    private JPopupMenu _popup = null;
    private boolean _isMotifLAF;

    TDDBUI(ButtonUI buttonUI, SybToolBarDropDownButton sybToolBarDropDownButton) {
        this._encapsulatedUI = buttonUI;
        this._button = sybToolBarDropDownButton;
        this._isMotifLAF = false;
        this._button.setMinimumSize(null);
        this._button.setPreferredSize(null);
        this.installListeners(this._button);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this._encapsulatedUI.getPreferredSize(jComponent);
        dimension.width = this._isMotifLAF ? (dimension.width += 4) : (dimension.width += 14);
        return dimension;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this._encapsulatedUI.update(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Color color;
        this._encapsulatedUI.paint(graphics, jComponent);
        Insets insets = ((AbstractButton)jComponent).getMargin();
        int n = jComponent.getInsets().right - insets.right;
        int n2 = jComponent.getWidth() - n - 14;
        int n3 = 14;
        int n4 = insets.top;
        int n5 = jComponent.getHeight() - insets.top - insets.bottom;
        ButtonModel buttonModel = ((AbstractButton)jComponent).getModel();
        if (this._isMotifLAF) {
            n2 += 10;
            if (this._button.getBorder() == this._button.getButtonBorder()) {
                color = SystemColor.controlShadow;
                graphics.setColor(color);
                graphics.fillRect(n2, (n5 - 8) / 2, 1, 12);
            }
        } else if (this._button.getNoBorder() == this._button.getButtonBorder()) {
            if (!((AbstractButton)jComponent).isRolloverEnabled() || buttonModel.isRollover()) {
                color = SystemColor.controlShadow;
                graphics.setColor(color);
                graphics.fillRect(n2, n4, 1, n5);
            }
        } else if (this._button.getBorder() == this._button.getButtonBorder()) {
            color = SystemColor.controlShadow;
            graphics.setColor(color);
            graphics.fillRect(n2, n4, 1, n5);
        }
        ++n2;
        n2 += 3;
        if (buttonModel.isEnabled()) {
            color = jComponent.getForeground();
        } else {
            color = UIManager.getColor("Button.disabledForeground");
            if (color == null) {
                color = SystemColor.textInactiveText;
            }
        }
        graphics.setColor(color);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n2;
        nArray[1] = n2 + 7;
        nArray[2] = n2 + 3;
        nArray2[0] = (n5 - 4) / 2 + insets.top;
        nArray2[1] = nArray2[0];
        nArray2[2] = nArray2[0] + 4;
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners((SybToolBarDropDownButton)jComponent);
        this._encapsulatedUI.uninstallUI(jComponent);
        this._encapsulatedUI = null;
        this._button = null;
    }

    private void installListeners(SybToolBarDropDownButton sybToolBarDropDownButton) {
        sybToolBarDropDownButton.addMouseListener(this);
        ((SybDropDownButtonModel)sybToolBarDropDownButton.getModel()).addDropDownListener(this);
        InputMap inputMap = sybToolBarDropDownButton.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(115, 0);
        inputMap.put(keyStroke, "togglePopup");
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, "openPopup");
        keyStroke = KeyStroke.getKeyStroke(225, 0);
        inputMap.put(keyStroke, "openPopup");
        ActionMap actionMap = sybToolBarDropDownButton.getActionMap();
        actionMap.put("togglePopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TDDBUI.this.togglePopupMenu();
            }
        });
        actionMap.put("openPopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TDDBUI.this.showPopupMenu((SybDropDownButtonModel)TDDBUI.this._button.getModel());
            }
        });
    }

    private void uninstallListeners(SybToolBarDropDownButton sybToolBarDropDownButton) {
        ((SybDropDownButtonModel)sybToolBarDropDownButton.getModel()).removeDropDownListener(this);
        sybToolBarDropDownButton.removeMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof SybDropDownButtonModel && ((SybDropDownButtonModel)object).isEnabled() && (actionEvent.getModifiers() & 0x100) != 0) {
            this.showPopupMenu((SybDropDownButtonModel)object);
        } else if (object instanceof SybMenuItem) {
            JPopupMenu jPopupMenu = (JPopupMenu)((SybMenuItem)object).getParent();
            Component[] componentArray = jPopupMenu.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != object) continue;
                this._button.fireDropDownItemClickedEvent(i);
                break;
            }
        }
    }

    private void togglePopupMenu() {
        if (this._popup == null) {
            this.showPopupMenu((SybDropDownButtonModel)this._button.getModel());
        } else {
            this._popup.setVisible(false);
        }
    }

    private void showPopupMenu(SybDropDownButtonModel sybDropDownButtonModel) {
        if (this._popup != null) {
            return;
        }
        this._button.fireDropDownOpeningEvent();
        Object[] objectArray = sybDropDownButtonModel.getListData();
        Icon[] iconArray = sybDropDownButtonModel.getIcons();
        boolean[] blArray = sybDropDownButtonModel.getEnabledStates();
        if (objectArray != null && objectArray.length != 0) {
            this._popup = new JPopupMenu();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i] != null ? objectArray[i].toString() : null;
                if (string == null || string.length() == 0) {
                    this._popup.add(new JSeparator());
                    continue;
                }
                SybMenuItem sybMenuItem = new SybMenuItem(string);
                if (iconArray != null && i < iconArray.length) {
                    ((AbstractButton)sybMenuItem).setIcon(iconArray[i]);
                }
                if (blArray != null && i < blArray.length) {
                    sybMenuItem.setEnabled(blArray[i]);
                }
                sybMenuItem.addActionListener(this);
                this._popup.add(sybMenuItem);
            }
            this._popup.show(this._button, 0, this._button.getHeight());
            this._popup = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent, true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseEvent(mouseEvent, false);
    }

    public void handleMouseEvent(MouseEvent mouseEvent, boolean bl) {
        SybToolBarDropDownButton sybToolBarDropDownButton;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.mousedOnDropDown(sybToolBarDropDownButton = (SybToolBarDropDownButton)mouseEvent.getSource(), mouseEvent)) {
            SybDropDownButtonModel sybDropDownButtonModel = (SybDropDownButtonModel)sybToolBarDropDownButton.getModel();
            sybDropDownButtonModel.setDropDownPressed(bl);
        }
    }

    private boolean mousedOnDropDown(SybToolBarDropDownButton sybToolBarDropDownButton, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        Insets insets = sybToolBarDropDownButton.getMargin();
        int n2 = sybToolBarDropDownButton.getInsets().right - insets.right;
        int n3 = this._isMotifLAF ? sybToolBarDropDownButton.getWidth() + 10 - n2 - 14 : sybToolBarDropDownButton.getWidth() - n2 - 14;
        return n > n3;
    }
}

