/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.DialogUtils;
import com.sybase.util.EventMonitor;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class UITraceDialog
extends JDialog
implements ActionListener {
    private JTextArea _textArea = new JTextArea(EventMonitor.getEvents(), 20, 80);
    private JButton _copy = null;
    private JButton _close = null;

    static void showDialog() {
        Frame frame = null;
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isVisible() || !frameArray[i].isShowing() || !frameArray[i].isEnabled()) continue;
            frame = frameArray[i];
            break;
        }
        UITraceDialog uITraceDialog = new UITraceDialog(frame);
        uITraceDialog.setVisible(true);
    }

    private UITraceDialog(Frame frame) {
        super(frame, true);
        this._textArea.setEditable(false);
        this._copy = new JButton("Copy To Clipboard");
        this._copy.addActionListener(this);
        this._close = new JButton("Close");
        this._close.addActionListener(this);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JScrollPane(this._textArea), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this._copy);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this._close);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.setTitle("User Actions");
        this.pack();
        this.setLocationRelativeTo(frame);
        UIUtils.ensureWindowIsVisible(this);
    }

    private void close() {
        this._textArea = null;
        this._copy.removeActionListener(this);
        this._copy = null;
        this._close.removeActionListener(this);
        this._close = null;
        this.setVisible(false);
        DialogUtils.removeComponents(this);
    }

    private void copy() {
        StringSelection stringSelection = new StringSelection(this._textArea.getText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._copy) {
            this.copy();
        } else {
            this._close.setEnabled(false);
            this.close();
        }
    }
}

