/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.CollapsedTreeIcon;
import com.sybase.util.EventMonitor;
import com.sybase.util.ExpandedTreeIcon;
import com.sybase.util.GradientPanel;
import com.sybase.util.ImageLoader;
import com.sybase.util.ImagePanel;
import com.sybase.util.KeyNameResourcesBase;
import com.sybase.util.MacRootPaneUI;
import com.sybase.util.MyFocusCellHighlightBorder;
import com.sybase.util.Platform;
import com.sybase.util.SybFocusManager;
import com.sybase.util.win32.Registry;
import com.sybase.util.win32.Win32Util;
import com.sybase.util.win32.WindowsSystemFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;

public class UIUtils {
    private static boolean _lafInstalled = false;

    public static void installLookAndFeel() {
        String string;
        File file;
        String string2;
        block13: {
            if (_lafInstalled) {
                return;
            }
            try {
                Locale locale;
                String string3 = System.getProperty("swing.defaultlaf");
                if (string3 == null) {
                    string3 = !Platform.isWindows() && !Platform.isMacOS() ? "javax.swing.plaf.metal.MetalLookAndFeel" : UIManager.getSystemLookAndFeelClassName();
                }
                UIManager.setLookAndFeel(string3);
                string2 = System.getProperty("com.sybase.util.sybFocusManager");
                if (string2 == null || !string2.equals("0")) {
                    SybFocusManager.install();
                }
                if ((locale = Locale.getDefault()).getLanguage().equals("ja")) {
                    string2 = "OK";
                    UIManager.put("ColorChooser.okText", string2);
                    string2 = "\u30ad\u30e3\u30f3\u30bb\u30eb";
                    UIManager.put("ColorChooser.cancelText", string2);
                }
                if (string3.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                    UIUtils.installWindowsFixes();
                }
                if (string3.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
                    UIUtils.installMetalFixes();
                }
                if (string3.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
                    UIUtils.installMotifFixes();
                }
                if (Platform.isMacOS()) {
                    UIUtils.installMacFixes();
                }
                if ((string2 = System.getProperty("com.sybase.util.crossPlatformFixes")) == null || !string2.equals("0")) {
                    UIUtils.installCrossPlatformFixes();
                }
            }
            catch (Throwable throwable) {
                if (throwable.getMessage().indexOf("AccessBridge") == -1) break block13;
                Toolkit.getDefaultToolkit().beep();
                System.exit(0);
            }
        }
        _lafInstalled = true;
        string2 = System.getProperty("com.sybase.util.eventMonitor");
        if (string2 == null || !string2.equals("0")) {
            EventMonitor.install();
        }
        UIUtils.resetAWTToolkitResources();
        if (Platform.isVista() && (!(file = new File(string = System.getProperty("user.dir"))).exists() || !file.isDirectory() || string.toLowerCase().endsWith(":\\windows\\system32")) && (file = new File(System.getenv("HOMEDRIVE") + System.getenv("HOMEPATH"))).exists() && file.isDirectory()) {
            System.setProperty("user.dir", file.getAbsolutePath());
        }
    }

    public static void resetAWTToolkitResources() {
        try {
            Toolkit.getDefaultToolkit();
            Field field = Toolkit.class.getDeclaredField("resources");
            field.setAccessible(true);
            ResourceBundle resourceBundle = (ResourceBundle)field.get(null);
            if (resourceBundle != null) {
                field.set(null, KeyNameResourcesBase.getBundle());
            }
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"The fix that ensures AWT uses the correct localized resources is broken. See UIUtils.resetAWTToolkitResources() for details.");
        }
    }

    static boolean isMnemonicHidden() {
        return false;
    }

    static boolean isWindowsLAF() {
        return UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    }

    static void installMacFixes() {
        MacRootPaneUI.install();
    }

    public static boolean isXPLookAndFeelActive() {
        return UIUtils.isXP();
    }

    static boolean isXP() {
        boolean bl = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object object = toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (object != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    static void installCrossPlatformFixes() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (!UIManager.getLookAndFeel().getID().equals("Synth") && !UIManager.getLookAndFeel().getID().equals("GTK")) {
            Object[] objectArray = new Object[]{"Default_TableUI", uIDefaults.get("TableUI"), "TableUI", "com.sybase.util.SybTableUI"};
            uIDefaults.putDefaults(objectArray);
        }
        UIUtils.removeKeystrokeBinding(uIDefaults, "ctrl H", "TextField.focusInputMap", "PasswordField.focusInputMap", "TextArea.focusInputMap", "TextPane.focusInputMap", "EditorPane.focusInputMap");
        UIUtils.removeKeystrokeBinding(uIDefaults, "ctrl N", "TextArea.focusInputMap", "TextPane.focusInputMap", "EditorPane.focusInputMap");
        UIUtils.removeKeystrokeBinding(uIDefaults, "ctrl P", "TextArea.focusInputMap", "TextPane.focusInputMap", "EditorPane.focusInputMap");
    }

    private static void removeKeystrokeBinding(UIDefaults uIDefaults, String string, String ... stringArray) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        for (int i = 0; i < stringArray.length; ++i) {
            InputMap inputMap = (InputMap)uIDefaults.get(stringArray[i]);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            inputMap.remove(keyStroke);
        }
    }

    private static void installMetalFixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RootPaneUI");
        arrayList.add("com.sybase.util.SybMetalRootPaneUI");
        arrayList.add("OptionPaneUI");
        arrayList.add("com.sybase.util.OptionPaneUI");
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.putDefaults(arrayList.toArray());
    }

    private static void installMotifFixes() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OptionPaneUI");
        arrayList.add("com.sybase.util.OptionPaneUI");
        Object object = uIDefaults.get("TextField.focusInputMap");
        if (object != null && object instanceof InputMap) {
            UIUtils.addCutCopyPasteKeyMap((InputMap)object);
        }
        if ((object = uIDefaults.get("TextArea.focusInputMap")) != null && object instanceof InputMap) {
            UIUtils.addCutCopyPasteKeyMap((InputMap)object);
        }
        if ((object = uIDefaults.get("PasswordField.focusInputMap")) != null && object instanceof InputMap) {
            UIUtils.addCutCopyPasteKeyMap((InputMap)object);
        }
        uIDefaults.putDefaults(arrayList.toArray());
    }

    private static void addCutCopyPasteKeyMap(InputMap inputMap) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke("CUT");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("ctrl X");
        inputMap.put(keyStroke2, inputMap.get(keyStroke));
        keyStroke = KeyStroke.getKeyStroke("COPY");
        keyStroke2 = KeyStroke.getKeyStroke("ctrl C");
        inputMap.put(keyStroke2, inputMap.get(keyStroke));
        keyStroke = KeyStroke.getKeyStroke("PASTE");
        keyStroke2 = KeyStroke.getKeyStroke("ctrl V");
        inputMap.put(keyStroke2, inputMap.get(keyStroke));
    }

    private static void installWindowsFixes() {
        boolean bl;
        String string = System.getProperty("com.sybase.util.windowsSystemColors");
        boolean bl2 = string == null || !string.equals("0");
        string = System.getProperty("com.sybase.util.windowsSystemFonts");
        boolean bl3 = bl = string == null || !string.equals("0");
        if (bl2) {
            UIUtils.fixWindowsColors();
        }
        if (bl) {
            UIUtils.fixWindowsFonts();
        }
    }

    private static void fixWindowsColors() {
        Insets insets = new Insets(1, 1, 1, 1);
        Border border = BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow);
        Border border2 = BorderFactory.createEtchedBorder(1, SystemColor.controlHighlight, SystemColor.controlShadow);
        Border border3 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        MyFocusCellHighlightBorder myFocusCellHighlightBorder = new MyFocusCellHighlightBorder();
        UIDefaults uIDefaults = UIManager.getDefaults();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("TabbedPaneUI");
        arrayList.add("com.sybase.util.WindowsTabbedPaneUI");
        arrayList.add("Button.disabledForeground");
        arrayList.add(SystemColor.controlShadow);
        arrayList.add("Button.disabledBackground");
        arrayList.add(SystemColor.controlLtHighlight);
        arrayList.add("Button.focus");
        arrayList.add(SystemColor.controlText);
        if (UIUtils.isWindows2000LAF()) {
            arrayList.add("Label.foreground");
            arrayList.add(SystemColor.windowText);
        }
        arrayList.add("Label.disabledForeground");
        arrayList.add(SystemColor.controlShadow);
        arrayList.add("Label.disabledShadow");
        arrayList.add(SystemColor.controlLtHighlight);
        arrayList.add("CheckBox.focus");
        arrayList.add(SystemColor.controlText);
        arrayList.add("RadioButton.focus");
        arrayList.add(SystemColor.controlText);
        arrayList.add("TextFieldUI");
        arrayList.add("com.sybase.util.SybWindowsTextFieldUI");
        arrayList.add("FormattedTextFieldUI");
        arrayList.add("com.sybase.util.SybWindowsFormattedTextFieldUI");
        arrayList.add("TextArea.margin");
        arrayList.add(insets);
        arrayList.add("TextAreaUI");
        arrayList.add("com.sybase.util.SybWindowsTextAreaUI");
        try {
            Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicComboPopup");
            Field field = clazz.getDeclaredField("LIST_BORDER");
            field.setAccessible(true);
            LineBorder lineBorder = new LineBorder(SystemColor.controlText, 1);
            field.set(null, lineBorder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        uIDefaults.remove("MenuBar.windowBindings");
        arrayList.add("MenuItem.disabledForeground");
        arrayList.add(SystemColor.controlShadow);
        arrayList.add("RadioButtonMenuItem.disabledForeground");
        arrayList.add(SystemColor.controlShadow);
        arrayList.add("CheckBoxMenuItem.disabledForeground");
        arrayList.add(SystemColor.controlShadow);
        arrayList.add("ScrollPane.border");
        arrayList.add(border);
        if (UIUtils.isWindows2000LAF()) {
            arrayList.add("TitledBorder.border");
            arrayList.add(border2);
        }
        if (UIUtils.isWindows2000LAF()) {
            arrayList.add("TitledBorder.titleColor");
            arrayList.add(SystemColor.windowText);
        }
        arrayList.add("Viewport.background");
        arrayList.add(SystemColor.window);
        arrayList.add("TableUI");
        arrayList.add("com.sybase.util.WindowsTableUI");
        arrayList.add("Table.foreground");
        arrayList.add(SystemColor.windowText);
        arrayList.add("Table.focusCellForeground");
        arrayList.add(SystemColor.windowText);
        arrayList.add("Table.focusCellHighlightBorder");
        arrayList.add(myFocusCellHighlightBorder);
        arrayList.add("List.focusCellHighlightBorder");
        arrayList.add(myFocusCellHighlightBorder);
        arrayList.add("ListUI");
        arrayList.add("com.sybase.util.WindowsListUI");
        arrayList.add("Tree.hash");
        arrayList.add(SystemColor.textInactiveText);
        arrayList.add("TreeUI");
        arrayList.add("com.sybase.util.WindowsTreeUI");
        arrayList.add("Tree.expandedIcon");
        arrayList.add(new ExpandedTreeIcon());
        arrayList.add("Tree.collapsedIcon");
        arrayList.add(new CollapsedTreeIcon());
        arrayList.add("ToolTip.border");
        arrayList.add(border3);
        arrayList.add("OptionPaneUI");
        arrayList.add("com.sybase.util.OptionPaneUI");
        UIManager.put("Button.showMnemonics", Boolean.TRUE);
        uIDefaults.putDefaults(arrayList.toArray());
    }

    private static void fixWindowsFonts() {
        String string;
        block9: {
            try {
                string = System.getProperty("user.language");
                if (!string.equals("ja") && !string.equals("ko") && !string.equals("zh")) break block9;
                if (Registry.isInstalled()) {
                    String string2 = Registry.getValue(0, "SOFTWARE\\Sybase\\SQL Anywhere", "AlwaysUseSystemFonts");
                    if (!"1".equals(string2)) {
                        return;
                    }
                    break block9;
                }
                return;
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        if (WindowsSystemFont.isInstalled() && (!UIUtils.dbgEnabled() || UIUtils.dbgPrompt("Install windows fonts?"))) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            UIUtils.installWindowsFonts(arrayList);
            if (arrayList.size() > 0) {
                UIDefaults uIDefaults = UIManager.getDefaults();
                uIDefaults.putDefaults(arrayList.toArray());
            }
        }
        if (Registry.isInstalled() && (string = Registry.getValue(0, "SYSTEM\\CurrentControlSet\\Hardware Profiles\\Current\\Software\\Fonts", "LogPixels")) != null && string.length() != 0) {
            try {
                int n = Integer.parseInt(string, 16);
                UIUtils.adjustForFontDPI(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void installWindowsFonts(ArrayList<Object> arrayList) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        WindowsSystemFont windowsSystemFont = new WindowsSystemFont(15);
        WindowsSystemFont windowsSystemFont2 = new WindowsSystemFont(12);
        String[] stringArray = new String[]{"Button.font", "CheckBox.font", "ComboBox.font", "EditorPane.font", "FormattedTextField.font", "Label.font", "List.font", "RadioButton.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "Tree.font", "Viewport.font"};
        float f = windowsSystemFont.getFont().getSize2D();
        uIDefaults = UIManager.getDefaults();
        for (int i = 0; i < stringArray.length; ++i) {
            Font font = (Font)uIDefaults.get(stringArray[i]);
            if (font.getSize2D() == f) continue;
            font = font.deriveFont(f);
            arrayList.add(stringArray[i]);
            arrayList.add(new FontUIResource(font));
        }
        Font font = (Font)uIDefaults.get("PasswordField.font");
        font = font != null ? font.deriveFont(windowsSystemFont.getFont().getStyle(), windowsSystemFont.getFont().getSize2D()) : windowsSystemFont.getFont();
        arrayList.add("PasswordField.font");
        arrayList.add(new FontUIResource(font));
    }

    private static void adjustForFontDPI(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        float f = 21.0f * (float)n / 72.0f + 72.0f;
        if ((double)f != 100.0 && (!UIUtils.dbgEnabled() || UIUtils.dbgPrompt("Compensate for logical font size?"))) {
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                Object object = uIDefaults.get(string);
                if (!(object instanceof Font)) continue;
                Font font = (Font)object;
                float f2 = font.getSize2D() * f / 100.0f;
                Font font2 = font.deriveFont(font.getStyle(), f2);
                uIDefaults.put(string, new FontUIResource(font2));
            }
        }
    }

    public static void showJPopupMenu(JPopupMenu jPopupMenu, JComponent jComponent, Point point) {
        Rectangle rectangle = UIUtils.getWorkArea(jComponent.getX() + point.x, jComponent.getY() + point.y);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point2, jComponent);
        Point point3 = new Point(point2.x + point.x, point2.y + point.y);
        Point point4 = new Point(point3.x, point3.y);
        if (UIUtils.onWindows() && Win32Util.isInstalled()) {
            rectangle = Win32Util.getWorkArea(point4.x, point4.y);
        } else {
            Dimension dimension2 = jComponent.getToolkit().getScreenSize();
            rectangle = new Rectangle(0, 0, dimension2.width, dimension2.height);
        }
        if (point4.x + dimension.width > rectangle.x + rectangle.width) {
            point4.x = rectangle.x + rectangle.width - dimension.width;
        }
        if (point4.y + dimension.height > rectangle.y + rectangle.height) {
            point4.y = rectangle.y + rectangle.height - dimension.height;
        }
        if (point4.x < rectangle.x) {
            point4.x = rectangle.x;
        }
        if (point4.y < rectangle.y) {
            point4.y = rectangle.y;
        }
        SwingUtilities.convertPointFromScreen(point4, jComponent);
        UIUtils.installListeners(jComponent, jPopupMenu);
        jComponent.requestFocusInWindow();
        jPopupMenu.show(jComponent, point4.x, point4.y);
    }

    public static void ensureWindowIsVisible(Window window) {
        boolean bl = false;
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, window);
        Rectangle rectangle = UIUtils.getWorkArea(point.x, point.y);
        Rectangle rectangle2 = window.getBounds();
        if (rectangle2.x < rectangle.x) {
            rectangle2.x = rectangle.x;
            bl = true;
        }
        if (rectangle2.y < rectangle.y) {
            rectangle2.y = rectangle.y;
            bl = true;
        }
        if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            rectangle2.x = rectangle2.width <= rectangle.width ? rectangle.x + rectangle.width - rectangle2.width : rectangle.x;
            bl = true;
        }
        if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            rectangle2.y = rectangle2.height <= rectangle.height ? rectangle.y + rectangle.height - rectangle2.height : rectangle.y;
            bl = true;
        }
        if (bl) {
            window.setBounds(rectangle2);
        }
    }

    public static Rectangle getWorkArea() {
        return UIUtils.getWorkArea(0, 0);
    }

    public static Rectangle getWorkArea(int n, int n2) {
        if (!UIUtils.onWindows() || !Win32Util.isInstalled()) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        Rectangle rectangle = Win32Util.getWorkArea(n, n2);
        return rectangle;
    }

    static boolean isWindows2000LAF() {
        if (Platform.isWindows()) {
            String string = System.getProperty("os.version");
            try {
                double d = Double.parseDouble(string);
                if (d == 5.0) {
                    return true;
                }
                if (d < 5.0) {
                    return false;
                }
                return d > 5.0 && !UIUtils.isXP();
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean shouldDrawSolidSortArrow() {
        if (Platform.isWindows()) {
            String string = System.getProperty("os.version");
            try {
                double d = Double.parseDouble(string);
                return d >= 5.1;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return true;
    }

    static boolean onWindows() {
        String string = System.getProperty("os.name");
        boolean bl = string != null && string.length() > 0 && string.indexOf("Windows") != -1;
        return bl;
    }

    private static void installListeners(JComponent jComponent, JPopupMenu jPopupMenu) {
        TabSelectionHandler tabSelectionHandler = null;
        JTabbedPane jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, jComponent);
        if (jTabbedPane != null) {
            if (tabSelectionHandler == null) {
                tabSelectionHandler = new TabSelectionHandler(jPopupMenu);
            }
            jTabbedPane.addChangeListener(tabSelectionHandler);
        }
    }

    private static boolean dbgEnabled() {
        boolean bl = false;
        return bl;
    }

    private static boolean dbgPrompt(String string) {
        boolean bl = false;
        return bl;
    }

    static void printInstalledFonts(PrintStream printStream) {
    }

    static void printSystemColors(PrintStream printStream) {
    }

    private static String printColor(SystemColor systemColor) {
        return "[r=" + systemColor.getRed() + ",g=" + systemColor.getGreen() + ",b=" + systemColor.getBlue() + "]";
    }

    static void printSystemFonts(PrintStream printStream) {
    }

    static void printDesktopProperties(PrintStream printStream) {
    }

    public static JPanel createExplorerBar() {
        JPanel jPanel;
        if (UIUtils.isXP()) {
            Color color;
            Color color2 = UIUtils.getXPColor(Part.EBP_EXPLORERBAR, State.EBEBS_NORMAL, Prop.TMT_GRADIENTCOLOR1);
            if (color2 == null) {
                color2 = UIUtils.getXPColor("explorerbar.gradientcolor1", Color.DARK_GRAY);
            }
            if ((color = UIUtils.getXPColor(Part.EBP_EXPLORERBAR, State.EBEBS_NORMAL, Prop.TMT_GRADIENTCOLOR2)) == null) {
                color = UIUtils.getXPColor("explorerbar.gradientcolor2", Color.DARK_GRAY);
            }
            jPanel = new GradientPanel(color2, color);
        } else {
            jPanel = new JPanel();
            jPanel.setBackground(UIManager.getColor("Tree.background"));
        }
        return jPanel;
    }

    public static JPanel createExplorerBarHeader() {
        JPanel jPanel = null;
        if (UIUtils.isXP()) {
            BufferedImage bufferedImage = UIUtils.getXPImage(Part.EBP_NORMALGROUPHEAD, State.EBNGHS_NORMAL);
            if (bufferedImage == null) {
                bufferedImage = UIUtils.getXPImage("explorerbar.normalgrouphead.imagefile");
            }
            if (bufferedImage != null) {
                Insets insets = UIUtils.getXPMargin(Part.EBP_NORMALGROUPHEAD, State.EBNGHS_NORMAL, Prop.TMT_SIZINGMARGINS);
                if (insets == null) {
                    insets = UIUtils.getXPMargin("explorerbar.normalgrouphead.sizingmargins");
                }
                jPanel = new ImagePanel(bufferedImage, insets);
                jPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
            }
        }
        if (jPanel == null) {
            jPanel = new JPanel();
            jPanel.setBackground(SystemColor.control);
            jPanel.setBorder(BorderFactory.createLineBorder(SystemColor.control, 2));
        }
        Color color = UIUtils.getExplorerBarHeaderTextColor();
        jPanel.setForeground(color);
        return jPanel;
    }

    public static JPanel createExplorerBarGroup() {
        JPanel jPanel = null;
        if (UIUtils.isXP()) {
            BufferedImage bufferedImage = UIUtils.getXPImage(Part.EBP_NORMALGROUPBACKGROUND, State.EBNGBS_NORMAL);
            if (bufferedImage == null) {
                bufferedImage = UIUtils.getXPImage("explorerbar.normalgroupbackground.imagefile");
            }
            if (bufferedImage != null) {
                Insets insets = UIUtils.getXPMargin(Part.EBP_NORMALGROUPBACKGROUND, State.EBNGBS_NORMAL, Prop.TMT_SIZINGMARGINS);
                if (insets == null) {
                    insets = UIUtils.getXPMargin("explorerbar.normalgroupbackground.sizingmargins");
                }
                jPanel = new ImagePanel(bufferedImage, insets);
                insets = UIUtils.getXPMargin(Part.EBP_NORMALGROUPBACKGROUND, State.EBNGBS_NORMAL, Prop.TMT_CONTENTMARGINS);
                if (insets == null) {
                    insets = UIUtils.getXPMargin("explorerbar.normalgroupbackground.contentmargins");
                }
                if (insets != null) {
                    jPanel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                }
            }
        }
        if (jPanel == null) {
            jPanel = new JPanel();
            jPanel.setBackground(SystemColor.window);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, SystemColor.control), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        Color color = UIUtils.getExplorerBarGroupTextColor();
        jPanel.setForeground(color);
        return jPanel;
    }

    public static Color getExplorerBarHeaderTextColor() {
        Color color = UIUtils.getExplorerBarGroupTextColor();
        return color;
    }

    public static Color getExplorerBarGroupTextColor() {
        Color color = null;
        if (UIUtils.isXP() && (color = UIUtils.getXPColor(Part.EBP_NORMALGROUPBACKGROUND, State.EBNGBS_NORMAL, Prop.TMT_TEXTCOLOR)) == null) {
            color = UIUtils.getXPColor("explorerbar.normalgroupbackground.textcolor", null);
        }
        if (color == null) {
            color = SystemColor.windowText;
        }
        return color;
    }

    public static ImageIcon getExplorerBarGroupExpandButton() {
        ImageIcon imageIcon = null;
        if (UIUtils.isXP()) {
            BufferedImage bufferedImage = UIUtils.getXPImage(Part.EBP_NORMALGROUPEXPAND, State.EBNGES_NORMAL);
            if (bufferedImage == null) {
                bufferedImage = UIUtils.getXPImage("explorerbar.normalgroupexpand.imagefile", 1);
            }
            if (bufferedImage != null) {
                imageIcon = new ImageIcon(bufferedImage);
            }
        }
        if (imageIcon == null) {
            imageIcon = ImageLoader.getImageIcon(ImageLoader.class, "expand", 1006);
        }
        return imageIcon;
    }

    public static ImageIcon getExplorerBarGroupCollapseButton() {
        ImageIcon imageIcon = null;
        if (UIUtils.isXP()) {
            BufferedImage bufferedImage = UIUtils.getXPImage(Part.EBP_NORMALGROUPCOLLAPSE, State.EBNGCS_NORMAL);
            if (bufferedImage == null) {
                bufferedImage = UIUtils.getXPImage("explorerbar.normalgroupcollapse.imagefile", 1);
            }
            if (bufferedImage != null) {
                imageIcon = new ImageIcon(bufferedImage);
            }
        }
        if (imageIcon == null) {
            imageIcon = ImageLoader.getImageIcon(ImageLoader.class, "collapse", 1006);
        }
        return imageIcon;
    }

    public static String getLanguageCode(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = System.getenv(string);
        }
        if (string3 == null && Registry.isInstalled() && string2 != null && (string3 = Registry.getValue(1, string2, "Language")) == null) {
            string3 = Registry.getValue(0, string2, "Language");
        }
        if (string3 == null) {
            string3 = Locale.getDefault().getLanguage().equalsIgnoreCase("zh") ? Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() : Locale.getDefault().getLanguage();
        } else if (string3.equalsIgnoreCase("zh")) {
            string3 = "zh_CN";
        } else if (string3.equalsIgnoreCase("tw")) {
            string3 = "zh_TW";
        } else if (string3.equalsIgnoreCase("hk")) {
            string3 = "zh_HK";
        }
        return string3;
    }

    private static BufferedImage getXPImage(String string, int n) {
        BufferedImage bufferedImage = UIUtils.getXPImage(string);
        if (bufferedImage != null) {
            int n2;
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            int n5 = n4 / (n2 = n3);
            if (n < n5) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n3, n2, 2);
                int[] nArray = new int[n3 * n2];
                bufferedImage.getRGB(0, n * n2, n3, n2, nArray, 0, n3);
                bufferedImage2.setRGB(0, 0, n3, n2, nArray, 0, n3);
                bufferedImage = bufferedImage2;
            } else {
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    private static BufferedImage getXPImage(String string) {
        Object v;
        String string2;
        BufferedImage bufferedImage = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("win.xpstyle.resources.strings");
        if (map != null && (bufferedImage = (BufferedImage)map.get(string2 = "Image " + string)) == null && (v = map.get(string)) != null) {
            int n;
            string2 = v.toString();
            map = (Map)toolkit.getDesktopProperty("win.xpstyle.resources.images");
            bufferedImage = (BufferedImage)map.get(string2);
            if (bufferedImage != null && (n = bufferedImage.getColorModel().getTransparency()) == 1) {
                bufferedImage = UIUtils.convertToTransparent(bufferedImage, null);
            }
        }
        return bufferedImage;
    }

    private static BufferedImage getXPImage(Part part, State state) {
        BufferedImage bufferedImage = null;
        try {
            Class<?> clazz = Class.forName("sun.awt.windows.ThemeReader");
            Method method = clazz.getDeclaredMethod("getPartSize", String.class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            Dimension dimension = (Dimension)method.invoke(null, part.getWidget(), part.value, state.value);
            bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            method = clazz.getDeclaredMethod("paintBackground", int[].class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            method.invoke(null, dataBufferInt.getData(), part.getWidget(), part.value, state.value, 0, 0, dimension.width, dimension.height, dimension.width);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedImage;
    }

    private static BufferedImage convertToTransparent(BufferedImage bufferedImage, Color color) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n, n2, 2);
        int n3 = color != null ? color.getRGB() | 0xFF000000 : -65281;
        int[] nArray = new int[n];
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            for (int j = 0; j < n; ++j) {
                if (nArray[j] != n3) continue;
                nArray[j] = 0;
            }
            bufferedImage2.setRGB(0, i, n, 1, nArray, 0, n);
        }
        return bufferedImage2;
    }

    private static Insets getXPMargin(String string) {
        StringTokenizer stringTokenizer;
        String string2;
        Insets insets = null;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.resources.strings");
        if (map != null && (string2 = map.get(string).toString()) != null && string2.length() > 0 && (stringTokenizer = new StringTokenizer(string2, " \t,")).countTokens() == 4) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                insets = new Insets(n3, n, n4, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return insets;
    }

    private static Insets getXPMargin(Part part, State state, Prop prop) {
        Insets insets;
        try {
            Class<?> clazz = Class.forName("sun.awt.windows.ThemeReader");
            Method method = clazz.getDeclaredMethod("getThemeMargins", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            insets = (Insets)method.invoke(null, part.getWidget(), part.value, state.value, prop.value);
        }
        catch (Exception exception) {
            insets = null;
        }
        return insets;
    }

    private static Color getXPColor(Part part, State state, Prop prop) {
        Color color;
        try {
            Class<?> clazz = Class.forName("sun.awt.windows.ThemeReader");
            Method method = clazz.getDeclaredMethod("getColor", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            color = (Color)method.invoke(null, part.getWidget(), part.value, state.value, prop.value);
        }
        catch (Exception exception) {
            color = null;
        }
        return color;
    }

    private static Color getXPColor(String string, Color color) {
        StringTokenizer stringTokenizer;
        String string2;
        Color color2 = null;
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.resources.strings");
        if (map != null && (color2 = (Color)map.get("Color " + string)) == null && (string2 = (String)map.get(string)) != null && string2.length() > 0 && (stringTokenizer = new StringTokenizer(string2, " \t,")).countTokens() == 3) {
            try {
                color2 = new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public static String shrinkPathnameToWidth(String string, FontMetrics fontMetrics, int n) {
        return UIUtils.shrinkPathnameToWidth(string, fontMetrics, n, false);
    }

    public static String shrinkPathnameToWidth(String string, FontMetrics fontMetrics, int n, boolean bl) {
        String[] stringArray;
        int n2;
        Object object;
        int n3;
        String string2;
        String string3 = File.separator;
        int n4 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n4 <= n) {
            return string;
        }
        int n5 = SwingUtilities.computeStringWidth(fontMetrics, "...");
        if (n5 >= n) {
            return "...";
        }
        int n6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
        String[] stringArray2 = string.split(string3.replace("\\", "\\\\"));
        int n7 = stringArray2.length;
        String string4 = stringArray2[n7 - 1];
        int n8 = SwingUtilities.computeStringWidth(fontMetrics, string4);
        File file = new File(string);
        if (file.isAbsolute()) {
            string2 = stringArray2[0] + string3;
            n3 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            if (bl) {
                if (n3 + n5 >= n) {
                    return UIUtils.truncateString(string2, fontMetrics, n, "", "...", "", false, true);
                }
            } else {
                object = string2 + "...";
                n2 = SwingUtilities.computeStringWidth(fontMetrics, (String)object);
                if (n2 >= n) {
                    return UIUtils.truncateString(string2, fontMetrics, n, "", "...", "", false, false);
                }
            }
            stringArray = new String[n7 -= 2];
            System.arraycopy(stringArray2, 1, stringArray, 0, n7);
            stringArray2 = null;
        } else {
            string2 = "";
            n3 = 0;
            stringArray = new String[--n7];
            System.arraycopy(stringArray2, 0, stringArray, 0, n7);
            stringArray2 = null;
        }
        if (bl) {
            int n9;
            object = new int[n7];
            for (n9 = 0; n9 < n7; ++n9) {
                object[n9] = SwingUtilities.computeStringWidth(fontMetrics, stringArray[n9]);
            }
            if (n3 + n5 + n6 + n8 > n) {
                string = UIUtils.truncateString(string4, fontMetrics, n, string2 + "...", "", "", true, true);
            } else {
                int n10 = n7 / 2;
                boolean bl2 = n7 % 2 == 0;
                int n11 = n10;
                int n12 = n10 + 1;
                int n13 = 0;
                for (n9 = 0; n9 < n11; ++n9) {
                    n13 += object[n9] + n6;
                }
                int n14 = 0;
                for (n9 = n12; n9 < n7; ++n9) {
                    n14 += n6 + object[n9];
                }
                while (n3 + n13 + n5 + n14 + n6 + n8 > n) {
                    if (bl2) {
                        if (n10 - n11 <= n12 - n10 - 1) {
                            --n11;
                        } else {
                            ++n12;
                        }
                    } else if (n10 - n11 < n12 - n10 - 1) {
                        --n11;
                    } else {
                        ++n12;
                    }
                    n13 = 0;
                    for (n9 = 0; n9 < n11; ++n9) {
                        n13 += object[n9] + n6;
                    }
                    n14 = 0;
                    for (n9 = n12; n9 < n7; ++n9) {
                        n14 += n6 + object[n9];
                    }
                }
                StringBuilder stringBuilder = new StringBuilder(string2);
                for (n9 = 0; n9 < n11; ++n9) {
                    stringBuilder.append(stringArray[n9]);
                    stringBuilder.append(string3);
                }
                stringBuilder.append("...");
                for (n9 = n12; n9 < n7; ++n9) {
                    stringBuilder.append(string3);
                    stringBuilder.append(stringArray[n9]);
                }
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                string = stringBuilder.toString();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append("...");
            stringBuilder.append(string3);
            stringBuilder.append(string4);
            n4 = SwingUtilities.computeStringWidth(fontMetrics, stringBuilder.toString());
            if (n4 > n) {
                stringBuilder.delete(string2.length() + "...".length(), stringBuilder.length());
                string = UIUtils.truncateString(string4, fontMetrics, n, stringBuilder.toString(), "", "", true, false);
            } else {
                int n15;
                int n16 = string3.length();
                int[] nArray = new int[n7];
                for (n15 = 0; n15 < n7; ++n15) {
                    nArray[n15] = stringArray[n15].length();
                }
                int n17 = n7 / 2;
                boolean bl3 = n7 % 2 == 0;
                int n18 = n17;
                int n19 = n17 + 1;
                stringBuilder = new StringBuilder(string2);
                int n20 = string2.length();
                for (n15 = 0; n15 < n18; ++n15) {
                    stringBuilder.append(stringArray[n15]);
                    n20 += nArray[n15];
                    stringBuilder.append(string3);
                    n20 += n16;
                }
                stringBuilder.append("...");
                n2 = 0;
                for (n15 = n19; n15 < n7; ++n15) {
                    stringBuilder.append(string3);
                    n2 -= n16;
                    stringBuilder.append(stringArray[n15]);
                    n2 -= nArray[n15];
                }
                stringBuilder.append(string3);
                n2 -= n16;
                stringBuilder.append(string4);
                n2 -= string4.length();
                string = stringBuilder.toString();
                n4 = SwingUtilities.computeStringWidth(fontMetrics, string);
                while (n4 > n) {
                    if (bl3) {
                        if (n17 - n18 <= n19 - n17 - 1) {
                            n20 -= nArray[n18 - 1];
                            n20 -= n16;
                            --n18;
                        } else {
                            n2 += nArray[n19];
                            n2 += n16;
                            ++n19;
                        }
                    } else if (n17 - n18 < n19 - n17 - 1) {
                        n20 -= nArray[n18 - 1];
                        n20 -= n16;
                        --n18;
                    } else {
                        n2 += nArray[n19];
                        n2 += n16;
                        ++n19;
                    }
                    stringBuilder.delete(n20, stringBuilder.length() + n2);
                    stringBuilder.insert(n20, "...");
                    string = stringBuilder.toString();
                    n4 = SwingUtilities.computeStringWidth(fontMetrics, string);
                }
            }
        }
        return string;
    }

    public static String truncateString(String string, FontMetrics fontMetrics, int n) {
        return UIUtils.truncateString(string, fontMetrics, n, "", "", "...", false, false);
    }

    public static String truncateString(String string, FontMetrics fontMetrics, int n, String string2, String string3, String string4, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuilder stringBuilder;
        int n6;
        String string5 = null;
        if (bl2) {
            int n7 = SwingUtilities.computeStringWidth(fontMetrics, string4);
            int n8 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            n6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
            int n9 = SwingUtilities.computeStringWidth(fontMetrics, string);
            if (n8 + n9 + n6 <= n) {
                StringBuilder stringBuilder2 = new StringBuilder(string2);
                stringBuilder2.append(string);
                stringBuilder2.append(string3);
                return stringBuilder2.toString();
            }
            if (n8 + n7 + n6 >= n) {
                StringBuilder stringBuilder3 = new StringBuilder(string2);
                stringBuilder3.append(string4);
                stringBuilder3.append(string3);
                return stringBuilder3.toString();
            }
            n -= n8;
            n -= n6;
            n -= n7;
            stringBuilder = null;
            n5 = 0;
        } else {
            stringBuilder = new StringBuilder(string2);
            stringBuilder.append(string);
            stringBuilder.append(string3);
            String string6 = stringBuilder.toString();
            n6 = SwingUtilities.computeStringWidth(fontMetrics, string6);
            if (n6 <= n) {
                return string6;
            }
            StringBuilder stringBuilder4 = new StringBuilder(string2);
            stringBuilder4.append(string4);
            stringBuilder4.append(string3);
            string6 = stringBuilder4.toString();
            n6 = SwingUtilities.computeStringWidth(fontMetrics, string6);
            if (n6 >= n) {
                return string6;
            }
            n5 = bl ? string2.length() + string4.length() : string2.length();
        }
        if (bl) {
            n4 = 1;
            n3 = string.length();
        } else {
            n4 = 0;
            n3 = string.length() - 1;
        }
        String string7 = string.substring(n4, n3);
        if (bl2) {
            n2 = SwingUtilities.computeStringWidth(fontMetrics, string7);
            if (n2 <= n) {
                stringBuilder = new StringBuilder(string2);
                if (bl) {
                    stringBuilder.append(string4);
                    stringBuilder.append(string7);
                } else {
                    stringBuilder.append(string7);
                    stringBuilder.append(string4);
                }
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        } else {
            stringBuilder.delete(n5, stringBuilder.length());
            stringBuilder.append(string7);
            if (!bl) {
                stringBuilder.append(string4);
            }
            stringBuilder.append(string3);
            n2 = SwingUtilities.computeStringWidth(fontMetrics, stringBuilder.toString());
            if (n2 <= n) {
                return stringBuilder.toString();
            }
        }
        int n10 = 0;
        boolean bl3 = false;
        while (n3 - n4 > 1) {
            int n11;
            int n12;
            if (bl3) {
                n12 = n3 - n4;
                n12 *= (n - n10) / (n2 - n10);
                if ((n12 += n4) == n4) {
                    ++n12;
                } else if (n12 == n3) {
                    --n12;
                }
            } else {
                n12 = (n4 + n3) / 2;
            }
            if (bl) {
                string7 = string.substring(n12);
                if (bl2) {
                    n11 = SwingUtilities.computeStringWidth(fontMetrics, string7);
                } else {
                    stringBuilder.delete(n5, stringBuilder.length());
                    stringBuilder.append(string7);
                    stringBuilder.append(string3);
                    n11 = SwingUtilities.computeStringWidth(fontMetrics, stringBuilder.toString());
                }
                if (n11 > n) {
                    n4 = n12;
                    n2 = n11;
                } else {
                    n3 = n12;
                    n10 = n11;
                    if (!bl2) {
                        string5 = stringBuilder.toString();
                    }
                }
            } else {
                string7 = string.substring(0, n12);
                if (bl2) {
                    n11 = SwingUtilities.computeStringWidth(fontMetrics, string7);
                } else {
                    stringBuilder.delete(n5, stringBuilder.length());
                    stringBuilder.append(string7);
                    stringBuilder.append(string4);
                    stringBuilder.append(string3);
                    n11 = SwingUtilities.computeStringWidth(fontMetrics, stringBuilder.toString());
                }
                if (n11 > n) {
                    n3 = n12;
                    n2 = n11;
                } else {
                    n4 = n12;
                    n10 = n11;
                    if (!bl2) {
                        string5 = stringBuilder.toString();
                    }
                }
            }
            bl3 = !bl3;
        }
        if (string5 == null) {
            stringBuilder = new StringBuilder(string2);
            if (bl) {
                stringBuilder.append(string4);
                stringBuilder.append(string.substring(n3));
            } else {
                stringBuilder.append(string.substring(0, n4));
                stringBuilder.append(string4);
            }
            stringBuilder.append(string3);
            string5 = stringBuilder.toString();
        }
        return string5;
    }

    static enum Prop {
        TMT_SIZINGMARGINS("sizingmargins", Insets.class, 3601),
        TMT_CONTENTMARGINS("contentmargins", Insets.class, 3602),
        TMT_TEXTCOLOR("textcolor", Color.class, 3803),
        TMT_GRADIENTCOLOR1("gradientcolor1", Color.class, 3810),
        TMT_GRADIENTCOLOR2("gradientcolor2", Color.class, 3811);

        private final String propName;
        private final Class type;
        private final int value;

        private Prop(String string2, Class clazz, int n2) {
            this.propName = string2;
            this.type = clazz;
            this.value = n2;
        }

        public String toString() {
            return this.propName + "[" + this.type.getName() + "] = " + this.value;
        }

        private static Prop getProp(String string) {
            for (Prop prop : Prop.values()) {
                if (!prop.propName.equals(string)) continue;
                return prop;
            }
            return null;
        }

        private static int getPropValue(String string) {
            String string2 = string;
            int n = string.lastIndexOf(46);
            if (n > 0 && string.length() > n + 1) {
                string2 = string.substring(n + 1);
            }
            return Prop.getProp((String)string2).value;
        }
    }

    static enum State {
        EBEBS_NORMAL(Part.EBP_EXPLORERBAR, "normal", 0),
        EBNGHS_NORMAL(Part.EBP_NORMALGROUPHEAD, "normal", 0),
        EBNGBS_NORMAL(Part.EBP_NORMALGROUPBACKGROUND, "normal", 0),
        EBNGCS_NORMAL(Part.EBP_NORMALGROUPCOLLAPSE, "normal", 1),
        EBNGCS_HOT(Part.EBP_NORMALGROUPCOLLAPSE, "hot", 2),
        EBNGCS_PRESSED(Part.EBP_NORMALGROUPCOLLAPSE, "pressed", 3),
        EBNGES_NORMAL(Part.EBP_NORMALGROUPEXPAND, "normal", 1),
        EBNGES_HOT(Part.EBP_NORMALGROUPEXPAND, "hot", 2),
        EBNGES_PRESSED(Part.EBP_NORMALGROUPEXPAND, "pressed", 3);

        private final Part part;
        private final String stateName;
        private final int value;

        private State(Part part, String string2, int n2) {
            this.part = part;
            this.stateName = string2;
            this.value = n2;
        }

        public String toString() {
            return (Object)((Object)this.part) + "(" + this.stateName + "=" + this.value + ")";
        }

        private static int getStateValue(String string) {
            int n;
            String string2 = "";
            String string3 = null;
            int n2 = string.lastIndexOf(46);
            if (n2 > 0 && string.length() > n2 + 1 && (n2 = (string2 = string.substring(0, n2)).lastIndexOf(40)) > 0 && (n = string2.indexOf(41, n2)) == string2.length() - 1) {
                string3 = string2.substring(n2 + 1, n);
                string2 = string2.substring(0, n2);
            }
            return string3 != null ? State.getState((String)string2, string3).value : 0;
        }

        private static State getState(String string, String string2) {
            for (State state : State.values()) {
                if (!state.part.name.equals(string) || string2 != null && !state.stateName.equals(string2)) continue;
                return state;
            }
            return null;
        }
    }

    static enum Part {
        EBP_EXPLORERBAR("explorerbar", 0),
        EBP_NORMALGROUPBACKGROUND("explorerbar.normalgroupbackground", 5),
        EBP_NORMALGROUPCOLLAPSE("explorerbar.normalgroupcollapse", 6),
        EBP_NORMALGROUPEXPAND("explorerbar.normalgroupexpand", 7),
        EBP_NORMALGROUPHEAD("explorerbar.normalgrouphead", 8);

        private final int value;
        private final String name;

        private Part(String string2, int n2) {
            this.name = string2;
            this.value = n2;
        }

        String getWidget() {
            int n = this.name.indexOf(".");
            return n > 0 ? this.name.substring(0, n) : this.name;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        static Part getPart(String string) {
            for (Part part : Part.values()) {
                if (!part.name.equals(string)) continue;
                return part;
            }
            return null;
        }
    }

    private static class TabSelectionHandler
    implements ChangeListener {
        JPopupMenu _popup;

        TabSelectionHandler(JPopupMenu jPopupMenu) {
            this._popup = jPopupMenu;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this._popup != null && this._popup.isVisible()) {
                this._popup.setVisible(false);
            }
            this._popup = null;
            ((JTabbedPane)changeEvent.getSource()).removeChangeListener(this);
        }
    }
}

