/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.SybTextArea;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WarningBox
extends JPanel
implements MouseListener,
WindowListener,
ComponentListener,
FocusListener,
HierarchyListener {
    private String _message;
    private SybTextArea _messageArea;

    public WarningBox() {
        this("", null);
    }

    public WarningBox(String string, ImageIcon imageIcon) {
        this._message = string;
        this.addMouseListener(this);
        this.addHierarchyListener(this);
        this.setBackground((Color)UIManager.get("ToolTip.background"));
        this.setForeground((Color)UIManager.get("ToolTip.foreground"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this._messageArea = new SybTextArea(this._message);
        this._messageArea.setFont((Font)UIManager.get("Label.font"));
        this._messageArea.setEditable(false);
        this._messageArea.setEnabled(false);
        this._messageArea.setDisabledTextColor((Color)UIManager.get("ToolTip.foreground"));
        this.putClientProperty("jsyblib.preservecolor", "1");
        this._messageArea.setBackground((Color)UIManager.get("ToolTip.background"));
        this._messageArea.setWrapStyleWord(true);
        this._messageArea.setLineWrap(true);
        this._messageArea.addMouseListener(this);
        this.setBorder(BorderFactory.createLineBorder((Color)UIManager.get("ToolTip.foreground")));
        if (imageIcon != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            JLabel jLabel = new JLabel(imageIcon);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            this.add(Box.createVerticalStrut(1));
        }
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagLayout.setConstraints(this._messageArea, gridBagConstraints);
        this.add(this._messageArea);
        this.requestFocusInWindow();
        this.setVisible(false);
    }

    public void setMessage(String string) {
        this._message = string;
        this._messageArea.setText(this._message);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "mouseClicked"));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._messageArea) {
            this.setBackground(SystemColor.textHighlight);
            this.setForeground(SystemColor.textHighlightText);
            this._messageArea.setBackground(SystemColor.textHighlight);
            this._messageArea.setDisabledTextColor(SystemColor.textHighlightText);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._messageArea) {
            this.setForeground((Color)UIManager.get("ToolTip.foreground"));
            this.setBackground((Color)UIManager.get("ToolTip.background"));
            this._messageArea.setDisabledTextColor((Color)UIManager.get("TextArea.foreground"));
            this._messageArea.setBackground((Color)UIManager.get("ToolTip.background"));
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            if (this.isVisible()) {
                window.addWindowListener(this);
                window.addComponentListener(this);
                if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().addMouseListener(this);
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().addMouseListener(this);
                } else if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().addMouseListener(this);
                }
            } else {
                window.removeWindowListener(this);
                window.removeComponentListener(this);
                if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().removeMouseListener(this);
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().removeMouseListener(this);
                } else if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().removeMouseListener(this);
                }
            }
        }
    }
}

