/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class WindowsListUI
extends BasicListUI {
    protected MyFocusListener _focusListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsListUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (this._focusListener == null) {
            this._focusListener = new MyFocusListener((JList)jComponent);
            jComponent.addFocusListener(this._focusListener);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this._focusListener != null) {
            jComponent.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        super.uninstallUI(jComponent);
    }

    static class MyFocusListener
    implements FocusListener {
        Color _background = null;
        Color _foreground = null;

        MyFocusListener(JList jList) {
            if (!jList.hasFocus()) {
                this._background = jList.getSelectionBackground();
                this._foreground = jList.getSelectionForeground();
                jList.setSelectionBackground(SystemColor.control);
                jList.setSelectionForeground(SystemColor.controlText);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JList) {
                JList jList = (JList)focusEvent.getSource();
                if (this._background == null) {
                    this._background = jList.getSelectionBackground();
                } else {
                    jList.setSelectionBackground(this._background);
                }
                if (this._foreground == null) {
                    this._foreground = jList.getSelectionForeground();
                } else {
                    jList.setSelectionForeground(this._foreground);
                }
                if (jList.getModel().getSize() > 0 && jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() == -1) {
                    ListSelectionModel listSelectionModel = jList.getSelectionModel();
                    listSelectionModel.setAnchorSelectionIndex(0);
                    listSelectionModel.setLeadSelectionIndex(0);
                    listSelectionModel.clearSelection();
                }
                jList.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JList) {
                JList jList = (JList)focusEvent.getSource();
                jList.setSelectionBackground(SystemColor.control);
                jList.setSelectionForeground(SystemColor.controlText);
                jList.repaint();
            }
        }
    }
}

