/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class WindowsTabbedPaneUI
extends com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI {
    protected MyContainerListener _containerListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._containerListener == null && UIUtils.isXP()) {
            this._containerListener = new MyContainerListener();
            this.tabPane.addContainerListener(this._containerListener);
        }
    }

    protected void uninstallListeners() {
        if (this._containerListener != null) {
            this.tabPane.removeContainerListener(this._containerListener);
            this._containerListener = null;
        }
        super.uninstallListeners();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    public class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            if (this.shouldIgnoreEvent(jTabbedPane)) {
                return;
            }
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == WindowsTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(WindowsTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            if (this.shouldIgnoreEvent(jTabbedPane)) {
                return;
            }
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == WindowsTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(WindowsTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }

        private boolean shouldIgnoreEvent(JTabbedPane jTabbedPane) {
            boolean bl;
            boolean bl2 = bl = !jTabbedPane.isVisible();
            if (!bl) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, jTabbedPane);
                bl = window != null && !window.isVisible();
            }
            return bl;
        }
    }

    static class MyContainerListener
    implements ContainerListener {
        private Color _background = new Color(247, 247, 247);

        MyContainerListener() {
        }

        private boolean canSetColor(Component component) {
            Object object;
            boolean bl = true;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("jsyblib.preservecolor")) != null && object.equals("1")) {
                bl = false;
            }
            return bl;
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component != null && component instanceof Container) {
                this.setBackgroundColor((Container)component);
            }
        }

        private void setBackgroundColor(Container container) {
            if (!this.canSetColor(container)) {
                return;
            }
            this.setBackgroundForComponent(container);
            Component[] componentArray = container.getComponents();
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] instanceof Container) {
                        this.setBackgroundColor((Container)componentArray[i]);
                        continue;
                    }
                    this.setBackgroundForComponent(componentArray[i]);
                }
            }
        }

        private void setBackgroundForComponent(Component component) {
            if (component.isOpaque()) {
                Container container;
                if (component instanceof JPanel) {
                    component.setBackground(this._background);
                } else if (component instanceof AbstractButton && (container = component.getParent()) != null) {
                    component.setBackground(container.getBackground());
                }
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
        }
    }
}

