/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;

public class WindowsTableUI
extends BasicTableUI {
    protected MyFocusListener _focusListener = null;
    protected MyPropertyChangeListener _propertyChangeListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (this._focusListener == null) {
            this._focusListener = new MyFocusListener((JTable)jComponent);
            jComponent.addFocusListener(this._focusListener);
        }
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = new MyPropertyChangeListener();
            jComponent.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this._focusListener != null) {
            jComponent.removeFocusListener(this._focusListener);
            this._focusListener.restoreColors((JTable)jComponent);
            this._focusListener = null;
        }
        if (this._propertyChangeListener != null) {
            jComponent.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener.restoreColors((JTable)jComponent);
            this._propertyChangeListener = null;
        }
        super.uninstallUI(jComponent);
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static class MyFocusListener
    implements FocusListener {
        Color _background = null;
        Color _foreground = null;

        MyFocusListener(JTable jTable) {
            if (!jTable.hasFocus()) {
                this._background = jTable.getSelectionBackground();
                this._foreground = jTable.getSelectionForeground();
                jTable.setSelectionBackground(SystemColor.control);
                jTable.setSelectionForeground(SystemColor.controlText);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTable) {
                JTable jTable = (JTable)focusEvent.getSource();
                if (this._background == null) {
                    this._background = jTable.getSelectionBackground();
                } else {
                    jTable.setSelectionBackground(this._background);
                }
                if (this._foreground == null) {
                    this._foreground = jTable.getSelectionForeground();
                } else {
                    jTable.setSelectionForeground(this._foreground);
                }
                int n = jTable.getRowCount();
                if (n > 0 && jTable.getSelectedRow() == -1) {
                    ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                    ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
                    if (listSelectionModel != null && listSelectionModel2 != null) {
                        int n2 = listSelectionModel.getAnchorSelectionIndex();
                        int n3 = listSelectionModel2.getAnchorSelectionIndex();
                        if (n2 == -1 || n2 >= n || n3 == -1 || n3 >= jTable.getColumnCount()) {
                            listSelectionModel.setAnchorSelectionIndex(0);
                            listSelectionModel.setLeadSelectionIndex(0);
                            listSelectionModel2.setAnchorSelectionIndex(0);
                            listSelectionModel2.setLeadSelectionIndex(0);
                            listSelectionModel.clearSelection();
                        }
                    }
                }
                jTable.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTable) {
                JTable jTable = (JTable)focusEvent.getSource();
                jTable.setSelectionBackground(SystemColor.control);
                jTable.setSelectionForeground(SystemColor.controlText);
                jTable.repaint();
            }
        }

        void restoreColors(JTable jTable) {
            if (this._background != null) {
                jTable.setSelectionBackground(this._background);
            }
            if (this._foreground != null) {
                jTable.setSelectionForeground(this._foreground);
            }
        }
    }

    static class MyPropertyChangeListener
    implements PropertyChangeListener {
        private Color _foregroundColor = null;
        private Color _selectionForegroundColor = null;

        MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && string.equals("enabled")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                JTable jTable = (JTable)propertyChangeEvent.getSource();
                if (!bl) {
                    if (this._foregroundColor == null) {
                        this._foregroundColor = jTable.getForeground();
                        jTable.setForeground(SystemColor.textInactiveText);
                    }
                    if (this._selectionForegroundColor == null) {
                        this._selectionForegroundColor = jTable.getSelectionForeground();
                        jTable.setSelectionForeground(SystemColor.textInactiveText);
                    }
                } else {
                    this.restoreColors(jTable);
                }
            }
        }

        void restoreColors(JTable jTable) {
            if (this._foregroundColor != null) {
                jTable.setForeground(this._foregroundColor);
                this._foregroundColor = null;
            }
            if (this._selectionForegroundColor != null) {
                jTable.setSelectionForeground(this._selectionForegroundColor);
                this._selectionForegroundColor = null;
            }
        }
    }
}

