/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WindowsTreeUI
extends com.sun.java.swing.plaf.windows.WindowsTreeUI
implements PropertyChangeListener {
    protected MyFocusListener _focusListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateRowHeight((JTree)jComponent);
        jComponent.addPropertyChangeListener(this);
        if (this._focusListener == null) {
            this._focusListener = new MyFocusListener((JTree)jComponent);
            jComponent.addFocusListener(this._focusListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this._focusListener != null) {
            jComponent.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        jComponent.removePropertyChangeListener(this);
        super.uninstallUI(jComponent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("font") && (object = propertyChangeEvent.getSource()) instanceof JTree) {
            this.updateRowHeight((JTree)object);
        }
    }

    private void updateRowHeight(JTree jTree) {
        Font font = jTree.getFont();
        if (font != null) {
            FontMetrics fontMetrics = jTree.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            int n2 = jTree.getRowHeight();
            if ((n += 3) != n2) {
                jTree.setRowHeight(n);
            }
        }
    }

    static class MyFocusListener
    implements FocusListener {
        Color _background = null;
        Color _foreground = null;

        MyFocusListener(JTree jTree) {
            TreeCellRenderer treeCellRenderer;
            if (!jTree.hasFocus() && (treeCellRenderer = jTree.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                this._background = defaultTreeCellRenderer.getBackgroundSelectionColor();
                this._foreground = defaultTreeCellRenderer.getTextSelectionColor();
                defaultTreeCellRenderer.setBackgroundSelectionColor(SystemColor.control);
                defaultTreeCellRenderer.setTextSelectionColor(SystemColor.controlText);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTree jTree;
            TreeCellRenderer treeCellRenderer;
            if (focusEvent.getSource() instanceof JTree && (treeCellRenderer = (jTree = (JTree)focusEvent.getSource()).getCellRenderer()) instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (this._background == null) {
                    this._background = defaultTreeCellRenderer.getBackgroundSelectionColor();
                } else {
                    defaultTreeCellRenderer.setBackgroundSelectionColor(this._background);
                }
                if (this._foreground == null) {
                    this._foreground = defaultTreeCellRenderer.getTextSelectionColor();
                } else {
                    defaultTreeCellRenderer.setTextSelectionColor(this._foreground);
                }
                jTree.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            JTree jTree;
            TreeCellRenderer treeCellRenderer;
            if (focusEvent.getSource() instanceof JTree && (treeCellRenderer = (jTree = (JTree)focusEvent.getSource()).getCellRenderer()) instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBackgroundSelectionColor(SystemColor.control);
                defaultTreeCellRenderer.setTextSelectionColor(SystemColor.controlText);
                jTree.repaint();
            }
        }
    }
}

