/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.win32;

import com.sybase.util.Dbg;
import com.sybase.util.SCC;
import com.sybase.util.SCCException;
import com.sybase.util.SCCTextOutput;
import com.sybase.util.win32.Registry;
import com.sybase.util.win32.Win32Util;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFrame;

public class Win32SCC
implements SCC {
    private static final String REGKEY_INSTALLED_PROVIDERS = "SOFTWARE\\SourceCodeControlProvider\\InstalledSCCProviders";
    private static final String REGKEY_SCC_ROOT = "SOFTWARE\\SourceCodeControlProvider";
    private static final String REGKEY_DEFAULT_PROVIDER = "ProviderRegKey";
    private static final String REGVALUE_SCC_SERVER_PATH = "SCCServerPath";
    private boolean _initialized = false;
    private long _context = 0L;
    private int _capabilities = 0;
    private int _maximumCommentLength = 0;
    private int _maximumCheckoutCommentLength = 0;
    private Long _hwnd = null;
    private String _providerName = null;
    private String _auxProjPathDescription = null;

    private static native int sccAdd(long var0, long var2, int var4, String[] var5, String var6, long[] var7, long var8);

    private static native int sccAddFromScc(long var0, long var2, Vector var4);

    private static native int sccCloseProject(long var0);

    private static native int sccCheckin(long var0, long var2, int var4, String[] var5, String var6, long var7, long var9);

    private static native int sccCheckout(long var0, long var2, int var4, String[] var5, String var6, long var7, long var9);

    private static native int sccDiff(long var0, long var2, String var4, long var5, long var7);

    private static native int sccGetVersion(int[] var0);

    private static native int sccHistory(long var0, long var2, int var4, String[] var5, long var6, long var8);

    private static native int sccInitialize(long var0, String var2, int[] var3, String[] var4, long[] var5);

    private static native int sccGet(long var0, long var2, int var4, String[] var5, long var6, long var8);

    private static native int sccGetCommandOptions(long var0, long var2, int var4, long[] var5);

    private static native int sccGetProjPath(long var0, long var2, String[] var4, boolean var5, boolean var6, boolean[] var7);

    private static native int sccLoadProvider(String var0);

    private static native int sccOpenProject(long var0, long var2, String var4, String var5, String var6, String var7, String var8, SCCTextOutput var9, long var10, String[] var12, String[] var13, String[] var14, String[] var15);

    private static native int sccPopulateList(long var0, int var2, int var3, String[] var4, Vector var5, long var6);

    private static native int sccQueryInfo(long var0, long var2, int var4, String[] var5, int[] var6);

    private static native int sccProperties(long var0, long var2, String var4);

    private static native int sccRemove(long var0, long var2, int var4, String[] var5, String var6, long var7, long var9);

    private static native int sccRename(long var0, long var2, String var4, String var5);

    private static native int sccRunSCC(long var0, long var2, int var4, String[] var5);

    private static native int sccSetOption(long var0, long var2, int var4, int var5);

    private static native int sccUncheckout(long var0, long var2, int var4, String[] var5, long var6, long var8);

    private static native int sccUninitialize(long var0);

    private static native void cacheJNIIDs();

    public static String getDefaultSourceControlName() {
        String string;
        Vector<String> vector = null;
        String string2 = null;
        if (Registry.isInstalled() && (string = Registry.getValue(0, REGKEY_SCC_ROOT, REGKEY_DEFAULT_PROVIDER)) != null) {
            vector = Registry.enumerateValues(0, REGKEY_INSTALLED_PROVIDERS);
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = Registry.getValue(0, REGKEY_INSTALLED_PROVIDERS, vector.get(i));
                if (string3 == null || !string3.equals(string)) continue;
                string2 = vector.get(i);
                break;
            }
        }
        return string2;
    }

    public static Vector<String> getSourceControlNames() {
        Vector<String> vector = null;
        vector = Registry.isInstalled() ? Registry.enumerateValues(0, REGKEY_INSTALLED_PROVIDERS) : null;
        return vector;
    }

    public static Win32SCC create(JFrame jFrame, String string, String string2) throws SCCException {
        Win32SCC win32SCC = null;
        String string3 = Registry.getValue(0, REGKEY_INSTALLED_PROVIDERS, string);
        if (string3 == null || string3.length() == 0) {
            throw new SCCException(-10000);
        }
        String string4 = Registry.getValue(0, string3, REGVALUE_SCC_SERVER_PATH);
        if (string4 == null || string4.length() == 0) {
            throw new SCCException(-10003);
        }
        File file = new File(string4);
        if (file.isAbsolute() && !file.exists()) {
            throw new SCCException(-10001, new String[]{string4});
        }
        int n = Win32SCC.sccLoadProvider(string4);
        if (n != 0) {
            throw new SCCException(-10002, new String[]{string4});
        }
        win32SCC = new Win32SCC(jFrame, string2);
        return win32SCC;
    }

    private long getHWND(Window window) {
        long l = window != null ? Win32Util.getHWND(window) : (this._hwnd != null ? this._hwnd : 0L);
        return l;
    }

    private long getHWND() {
        long l = 0L;
        if (this._hwnd != null) {
            l = this._hwnd;
        } else {
            Frame[] frameArray = Frame.getFrames();
            for (int i = 0; i < frameArray.length; ++i) {
                if (!frameArray[i].isVisible()) continue;
                l = Win32Util.getHWND(frameArray[i]);
                break;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Win32SCC(JFrame jFrame, String string) throws SCCException {
        int n = 0;
        this._context = 0L;
        if (jFrame != null) {
            this._hwnd = Win32Util.getHWND(jFrame);
        }
        int[] nArray = new int[3];
        Arrays.fill(nArray, 0);
        Object[] objectArray = new String[2];
        Arrays.fill(objectArray, null);
        long[] lArray = new long[]{0L};
        n = Win32SCC.sccInitialize(this.getHWND(), string, nArray, (String[])objectArray, lArray);
        if (n < 0) {
            throw new SCCException(n);
        }
        this._context = lArray[0];
        this._providerName = objectArray[0];
        this._auxProjPathDescription = objectArray[1];
        this._capabilities = nArray[0];
        this._maximumCheckoutCommentLength = nArray[1];
        this._maximumCommentLength = nArray[2];
        this._initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVersion() throws SCCException {
        int n = 0;
        int[] nArray = new int[]{0};
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        int n2 = Win32SCC.sccGetVersion(nArray);
        if (n2 < 0) {
            throw new SCCException(n2);
        }
        n = nArray[0];
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String[] stringArray, String string, long[] lArray, long l) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccAdd(this._context, this.getHWND(), stringArray.length, stringArray, string, lArray, l);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccRemove(this._context, this.getHWND(), stringArray.length, stringArray, string, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    @Override
    public String getName() {
        return this._providerName;
    }

    @Override
    public String getAuxProjectPathDescription() {
        return this._auxProjPathDescription;
    }

    @Override
    public int getCapabilities() {
        return this._capabilities;
    }

    @Override
    public boolean supportsCommand(int n) {
        boolean bl = n == 11 || n == 0 || n == 2 || n == 1 || n == 3 || n == 4 || n == 5 && (this._capabilities & 1) != 0 || n == 6 && (this._capabilities & 4) != 0 || n == 7 && (this._capabilities & 8) != 0 || n == 8 && (this._capabilities & 2) != 0 || n == 9 && (this._capabilities & 0x10) != 0 || n == 10 && (this._capabilities & 0x40) != 0;
        return bl;
    }

    @Override
    public int getMaximumCheckoutCommentLength() {
        return this._maximumCheckoutCommentLength;
    }

    @Override
    public int getMaximumCommentLength() {
        return this._maximumCommentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getProjectPath(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, boolean[] blArray) throws SCCException {
        boolean bl3 = false;
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null || stringArray.length != 1 || stringArray2 == null || stringArray2.length != 1 || stringArray3 == null || stringArray3.length != 1 || stringArray4 == null || stringArray4.length != 1 || blArray == null || blArray.length != 1) {
            throw new IllegalArgumentException();
        }
        if (stringArray[0] == null) {
            stringArray[0] = "";
        }
        if (stringArray2[0] == null) {
            stringArray2[0] = "";
        }
        if (stringArray3[0] == null) {
            stringArray3[0] = "";
        }
        if (stringArray4[0] == null) {
            stringArray4[0] = "";
        }
        String[] stringArray5 = new String[]{stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0]};
        blArray[0] = false;
        int n = Win32SCC.sccGetProjPath(this._context, this.getHWND(), stringArray5, bl, bl2, blArray);
        if (n != 2) {
            if (n < 0) {
                throw new SCCException(n);
            }
            stringArray[0] = stringArray5[0];
            stringArray2[0] = stringArray5[1];
            stringArray3[0] = stringArray5[2];
            stringArray4[0] = stringArray5[3];
            bl3 = true;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCommandOptions(int n) throws SCCException {
        boolean bl;
        block5: {
            bl = false;
            if (!this._initialized) {
                throw new IllegalStateException();
            }
            int n2 = Win32SCC.sccGetCommandOptions(this._context, this.getHWND(), n, null);
            if (n2 == 1) {
                bl = true;
                break block5;
            }
            if (n2 == -14) {
                bl = false;
                break block5;
            }
            throw new SCCException(n2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCommandOptions(int n, Window window, int[] nArray) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        if (n < 0 || n > 10) {
            throw new IllegalArgumentException();
        }
        long[] lArray = new long[]{0L};
        long l = this.getHWND(window);
        int n2 = Win32SCC.sccGetCommandOptions(this._context, l, n, lArray);
        if (n2 < 0) {
            throw new SCCException(n2);
        }
        return lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void history(String[] stringArray, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("filenames cannot be null");
        }
        int n = Win32SCC.sccHistory(this._context, this.getHWND(), stringArray.length, stringArray, l, l2);
        if (n < 0) {
            throw new SCCException(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openProject(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, SCCTextOutput sCCTextOutput, long l) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null || stringArray.length != 1 || stringArray2 == null || stringArray2.length != 1 || stringArray3 == null || stringArray3.length != 1 || stringArray4 == null || stringArray4.length != 1) {
            throw new IllegalArgumentException();
        }
        if (stringArray[0] == null) {
            stringArray[0] = "";
        }
        if (stringArray2[0] == null) {
            stringArray2[0] = "";
        }
        if (stringArray3[0] == null) {
            stringArray3[0] = "";
        }
        if (stringArray4[0] == null) {
            stringArray4[0] = "";
        }
        if (string == null) {
            string = "";
        }
        int n = Win32SCC.sccOpenProject(this._context, this.getHWND(), stringArray[0], stringArray2[0], stringArray3[0], stringArray4[0], string, sCCTextOutput, l, stringArray, stringArray2, stringArray3, stringArray4);
        if (n < 0) {
            throw new SCCException(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeProject() throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccCloseProject(this._context);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(String[] stringArray, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccGet(this._context, this.getHWND(), stringArray.length, stringArray, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkout(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccCheckout(this._context, this.getHWND(), stringArray.length, stringArray, string, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkin(String[] stringArray, String string, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccCheckin(this._context, this.getHWND(), stringArray.length, stringArray, string, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncheckout(String[] stringArray, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccUncheckout(this._context, this.getHWND(), stringArray.length, stringArray, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string, String string2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccRename(this._context, this.getHWND(), string, string2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this._initialized) {
            Win32SCC.sccUninitialize(this._context);
            this._context = 0L;
            this._initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void diff(String string, long l, long l2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccDiff(this._context, this.getHWND(), string, l, l2);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showProperties(String string) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccProperties(this._context, this.getHWND(), string);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSCC(String[] stringArray) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n = Win32SCC.sccRunSCC(this._context, this.getHWND(), stringArray == null ? 0 : stringArray.length, stringArray);
            if (n < 0) {
                throw new SCCException(n);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] populateList(int n, String[] stringArray, long l) throws SCCException {
        String[] stringArray2 = stringArray;
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            Vector vector = new Vector();
            int n2 = Win32SCC.sccPopulateList(this._context, n, stringArray.length, stringArray, vector, l);
            if (n2 < 0) {
                throw new SCCException(n2);
            }
            stringArray2 = new String[vector.size()];
            vector.toArray(stringArray2);
        }
        finally {
            Dbg.printlnEx("Returned");
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getStatus(String[] stringArray) throws SCCException {
        int n = 0;
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("filenames cannot be null");
        }
        int[] nArray = new int[stringArray.length];
        n = Win32SCC.sccQueryInfo(this._context, this.getHWND(), stringArray.length, stringArray, nArray);
        if (n < 0) {
            throw new SCCException(n);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNewSCCFiles() throws SCCException {
        String[] stringArray = null;
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            Vector vector = new Vector();
            int n = Win32SCC.sccAddFromScc(this._context, this.getHWND(), vector);
            if (n < 0) {
                throw new SCCException(n);
            }
            int n2 = vector.size();
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = vector.get(i).toString();
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSCCOption(int n, int n2) throws SCCException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        try {
            int n3 = Win32SCC.sccSetOption(this._context, this.getHWND(), n, n2);
            if (n3 < 0) {
                throw new SCCException(n3);
            }
        }
        finally {
            Dbg.printlnEx("Returned");
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static {
        Win32SCC.cacheJNIIDs();
    }
}

