/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.win32;

import com.sybase.util.DLLLoader;
import com.sybase.util.Platform;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public class Win32Util {
    private static Hashtable<Integer, String> CodepageToCharsetTable = null;

    public static long getHWND(Window window) {
        String string;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        } else {
            return 0L;
        }
        return Win32Util.getHWND(window.getX(), window.getY(), window.getWidth(), window.getHeight(), string);
    }

    private static native long getHWND(int var0, int var1, int var2, int var3, String var4);

    public static native void setForegroundWindow(long var0, boolean var2);

    public static native boolean allowSetForegroundWindow(long var0);

    public static native long getCurrentProcessID();

    public static native String getCurrentProcessFileName();

    public static native Rectangle getWorkArea(int var0, int var1);

    public static native void setCurrentWorkingDirectory(String var0);

    public static native int getANSICodePage();

    public static native int getConsoleCodePage();

    public static String getCharsetNameForCodePage(int n) {
        String string;
        if (CodepageToCharsetTable == null) {
            Win32Util.initializeCodepageToCharsetTable();
        }
        if ((string = CodepageToCharsetTable.get(n)) != null) {
            try {
                String string2 = new String(new byte[]{32}, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = null;
            }
        }
        return string;
    }

    private static void initializeCodepageToCharsetTable() {
        CodepageToCharsetTable = new Hashtable();
        CodepageToCharsetTable.put(37, "IBM037");
        CodepageToCharsetTable.put(437, "IBM437");
        CodepageToCharsetTable.put(500, "IBM500");
        CodepageToCharsetTable.put(708, "ISO-8859-6");
        CodepageToCharsetTable.put(709, "ISO-8859-6");
        CodepageToCharsetTable.put(710, "ISO-8859-6");
        CodepageToCharsetTable.put(720, "ISO-8859-6");
        CodepageToCharsetTable.put(737, "x-IBM737");
        CodepageToCharsetTable.put(775, "IBM775");
        CodepageToCharsetTable.put(850, "IBM850");
        CodepageToCharsetTable.put(852, "IBM852");
        CodepageToCharsetTable.put(855, "IBM855");
        CodepageToCharsetTable.put(857, "IBM857");
        CodepageToCharsetTable.put(858, "IBM00858");
        CodepageToCharsetTable.put(860, "IBM860");
        CodepageToCharsetTable.put(861, "IBM861");
        CodepageToCharsetTable.put(862, "IBM862");
        CodepageToCharsetTable.put(863, "IBM863");
        CodepageToCharsetTable.put(864, "IBM864");
        CodepageToCharsetTable.put(865, "IBM865");
        CodepageToCharsetTable.put(866, "IBM866");
        CodepageToCharsetTable.put(869, "IBM867");
        CodepageToCharsetTable.put(870, "IBM870");
        CodepageToCharsetTable.put(874, "x-IBM874");
        CodepageToCharsetTable.put(875, "x-IBM875");
        CodepageToCharsetTable.put(932, "windows-31j");
        CodepageToCharsetTable.put(936, "GBK");
        CodepageToCharsetTable.put(949, "x-windows-949");
        CodepageToCharsetTable.put(950, "x-IBM950");
        CodepageToCharsetTable.put(1026, "IBM1026");
        CodepageToCharsetTable.put(1047, "IBM1047");
        CodepageToCharsetTable.put(1140, "IBM01140");
        CodepageToCharsetTable.put(1141, "IBM01141");
        CodepageToCharsetTable.put(1142, "IBM01142");
        CodepageToCharsetTable.put(1143, "IBM01143");
        CodepageToCharsetTable.put(1144, "IBM01144");
        CodepageToCharsetTable.put(1145, "IBM01145");
        CodepageToCharsetTable.put(1146, "IBM01146");
        CodepageToCharsetTable.put(1147, "IBM01147");
        CodepageToCharsetTable.put(1148, "IBM01148");
        CodepageToCharsetTable.put(1149, "IBM01149");
        CodepageToCharsetTable.put(1200, "utf-16le");
        CodepageToCharsetTable.put(1201, "utf-16be");
        CodepageToCharsetTable.put(1250, "windows-1250");
        CodepageToCharsetTable.put(1251, "windows-1251");
        CodepageToCharsetTable.put(1252, "windows-1252");
        CodepageToCharsetTable.put(1253, "windows-1253");
        CodepageToCharsetTable.put(1254, "windows-1254");
        CodepageToCharsetTable.put(1255, "windows-1255");
        CodepageToCharsetTable.put(1256, "windows-1256");
        CodepageToCharsetTable.put(1257, "windows-1257");
        CodepageToCharsetTable.put(1258, "windows-1258");
        CodepageToCharsetTable.put(1361, "x-Johab");
        CodepageToCharsetTable.put(10000, "x-MacRoman");
        CodepageToCharsetTable.put(10004, "x-MacArabic");
        CodepageToCharsetTable.put(10005, "x-MacHebrew");
        CodepageToCharsetTable.put(10006, "x-MacGreek");
        CodepageToCharsetTable.put(10007, "x-MacCyrillic");
        CodepageToCharsetTable.put(10010, "x-MacRomania");
        CodepageToCharsetTable.put(10017, "x-MacUkraine");
        CodepageToCharsetTable.put(10021, "x-MacThai");
        CodepageToCharsetTable.put(10079, "x-MacIcelandic");
        CodepageToCharsetTable.put(10081, "x-MacTurkish");
        CodepageToCharsetTable.put(10082, "x-MacCroatia");
        CodepageToCharsetTable.put(20127, "US-ASCII");
        CodepageToCharsetTable.put(20273, "IBM273");
        CodepageToCharsetTable.put(20277, "IBM277");
        CodepageToCharsetTable.put(20278, "IBM278");
        CodepageToCharsetTable.put(20280, "IBM280");
        CodepageToCharsetTable.put(20284, "IBM284");
        CodepageToCharsetTable.put(20285, "IBM285");
        CodepageToCharsetTable.put(20297, "IBM297");
        CodepageToCharsetTable.put(20420, "IBM420");
        CodepageToCharsetTable.put(20424, "IBM424");
        CodepageToCharsetTable.put(20838, "IBM-Thai");
        CodepageToCharsetTable.put(20866, "KOI8-R");
        CodepageToCharsetTable.put(20871, "IBM871");
        CodepageToCharsetTable.put(20924, "IBM01147");
        CodepageToCharsetTable.put(20932, "x-JIS0208");
        CodepageToCharsetTable.put(20936, "GB2312");
        CodepageToCharsetTable.put(28591, "ISO-8859-1");
        CodepageToCharsetTable.put(28592, "ISO-8859-2");
        CodepageToCharsetTable.put(28593, "ISO-8859-3");
        CodepageToCharsetTable.put(28594, "ISO-8859-4");
        CodepageToCharsetTable.put(28595, "ISO-8859-5");
        CodepageToCharsetTable.put(28596, "ISO-8859-6");
        CodepageToCharsetTable.put(28597, "ISO-8859-7");
        CodepageToCharsetTable.put(28598, "ISO-8859-8");
        CodepageToCharsetTable.put(28599, "ISO-8859-9");
        CodepageToCharsetTable.put(28605, "ISO-8859-15");
        CodepageToCharsetTable.put(38598, "ISO-8859-8");
        CodepageToCharsetTable.put(50220, "ISO-2022-JP");
        CodepageToCharsetTable.put(50221, "ISO-2022-JP");
        CodepageToCharsetTable.put(50222, "ISO-2022-JP");
        CodepageToCharsetTable.put(50225, "ISO-2022-KR");
        CodepageToCharsetTable.put(50227, "ISO-2022-CN");
        CodepageToCharsetTable.put(50229, "ISO-2022-CN");
        CodepageToCharsetTable.put(50930, "x-IBM930");
        CodepageToCharsetTable.put(50933, "x-IBM933");
        CodepageToCharsetTable.put(50935, "x-IBM935");
        CodepageToCharsetTable.put(50936, "GBK");
        CodepageToCharsetTable.put(50937, "x-IBM937");
        CodepageToCharsetTable.put(50939, "x-IBM939");
        CodepageToCharsetTable.put(51932, "EUC-JP");
        CodepageToCharsetTable.put(51936, "GBK");
        CodepageToCharsetTable.put(51949, "EUC-KR");
        CodepageToCharsetTable.put(51950, "GB2312");
        CodepageToCharsetTable.put(52936, "GB2312");
        CodepageToCharsetTable.put(54936, "GB18030");
        CodepageToCharsetTable.put(65001, "UTF-8");
    }

    public static native String getPersonalDocumentsFolder();

    public static native int shellExecute(String var0);

    private static native int[] getIconBits(long var0, int var2);

    private static native long getSystemIcon(int var0);

    private static native long getSystemIcon(int var0, int var1);

    private static native int getIconSize(long var0);

    private static Image getSystemIconAsImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        long l = Win32Util.getSystemIcon(n, n2);
        if (l == 0L) {
            l = Win32Util.getSystemIcon(n);
        }
        if (l != 0L) {
            int n3 = Win32Util.getIconSize(l);
            int[] nArray = Win32Util.getIconBits(l, n3);
            if (nArray != null) {
                bufferedImage = new BufferedImage(n3, n3, 2);
                bufferedImage.setRGB(0, 0, n3, n3, nArray, 0, n3);
            }
            if (n3 != n2) {
                BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.drawImage(bufferedImage, 0, 0, n2, n2, null);
                graphics2D.dispose();
                bufferedImage = bufferedImage2;
            }
        }
        return bufferedImage;
    }

    public static ImageIcon getVistaShieldIcon(int n) {
        ImageIcon imageIcon = null;
        Image image = Win32Util.getSystemIconAsImage(32518, n);
        if (image != null) {
            imageIcon = new ImageIcon(image);
        }
        return imageIcon;
    }

    public static Icon getODBCAdministratorIcon() {
        Icon icon = null;
        File file = new File(System.getenv("SystemRoot"), "system32\\odbcad32.exe");
        if (file.exists()) {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            icon = fileSystemView.getSystemIcon(file);
            if (Platform.isVista()) {
                ImageIcon imageIcon = Win32Util.getVistaShieldIcon(8);
                BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                icon.paintIcon(null, graphics2D, 0, 0);
                graphics2D.drawImage(imageIcon.getImage(), 8, 8, null);
                graphics2D.dispose();
                icon = new ImageIcon(bufferedImage);
            }
        }
        return icon;
    }

    public static boolean isInstalled() {
        return Platform.isWindows() && DLLLoader.isInstalled();
    }
}

