/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.debug;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Debug {
    private String propertyName;
    private String property;
    private Map subsystems;
    private WriterFactory factory;
    private static final PrintWriter SYSOUT = new PrintWriter(System.out, true);
    private static final PrintWriter SYSERR = new PrintWriter(System.err, true);
    private static final WriterFactory defaultFactory = new DefaultFactory();

    public Debug(String string) {
        this(string, defaultFactory);
    }

    public Debug(String string, WriterFactory writerFactory) {
        this.propertyName = string;
        this.property = System.getProperty(string, "");
        this.factory = writerFactory;
    }

    Debug(String string, String string2, WriterFactory writerFactory) {
        this.propertyName = string;
        this.property = "";
        this.factory = writerFactory;
    }

    private void buildMap() {
        if (this.subsystems != null) {
            return;
        }
        Debug debug = this;
        synchronized (debug) {
            if (this.subsystems != null) {
                Object var2_2 = null;
                return;
            }
            this.subsystems = Collections.synchronizedMap(new HashMap());
            StringTokenizer stringTokenizer = new StringTokenizer(this.property, " \t,");
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(58);
                if (n < 0) {
                    string = "";
                } else {
                    if (n == 0) {
                        System.err.println(String.valueOf(string2) + " is an illegal debug specifier, ignored (" + this.propertyName + ")");
                        continue;
                    }
                    string = string2.substring(n + 1);
                    string2 = string2.substring(0, n);
                }
                this.subsystems.put(string2, string);
            }
        }
    }

    public static PrivilegedAction getDebugAction(String string) {
        return Debug.getDebugAction(string, defaultFactory);
    }

    public static PrivilegedAction getDebugAction(final String string, final WriterFactory writerFactory) {
        return new PrivilegedAction(){

            public Object run() {
                try {
                    return new Debug(string, writerFactory);
                }
                catch (SecurityException securityException) {
                    return new Debug(string, "", writerFactory);
                }
            }
        };
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PrintWriter getWriter(String string) {
        this.buildMap();
        Object v = this.subsystems.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof PrintWriter) {
            return (PrintWriter)v;
        }
        try {
            PrintWriter printWriter = this.factory.writer(string, (String)v);
            this.subsystems.put(string, printWriter);
            return printWriter;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("debug output for " + string + " to System.out");
            this.subsystems.put(string, SYSOUT);
            return SYSOUT;
        }
    }

    public String toString() {
        return "Debug(" + this.propertyName + ")->\"" + this.property + '\"';
    }

    public static interface WriterFactory {
        public PrintWriter writer(String var1, String var2) throws IOException;
    }

    private static class DefaultFactory
    implements WriterFactory {
        private Map files = new HashMap();

        DefaultFactory() {
            this.files.put("", SYSOUT);
            this.files.put("out", SYSOUT);
            this.files.put("err", SYSERR);
        }

        public synchronized PrintWriter writer(String string, String string2) throws IOException {
            PrintWriter printWriter = (PrintWriter)this.files.get(string2);
            if (printWriter == null) {
                printWriter = new PrintWriter((Writer)new FileWriter(string2), true);
                this.files.put(string2, printWriter);
            }
            return printWriter;
        }
    }
}

